/* ======================================================================

	Component Manager glue for EMSAPI version 3

	Filename:			EMSAPI-Component.c
	Last Edited:		March 7, 1997
	Authors:			Laurence Lundblade, Bob Fronabarger
	Copyright:			1995, 1996 QUALCOMM Inc.
	Technical support:	<emsapi-info@qualcomm.com>

	THIS FILE SHOULD BE COMPILED ALONG WITH THE COMPONENT
	BE SURE YOU SUPPLY A usertrans.h WHEN YOU COMPILE IT
*/

#include <A4Stuff.h>
#include "emsapi-mac.h"
#include "usertrans.h"


typedef enum {
	kems_plugin_versionRtn = 256,
	kems_plugin_initRtn = 257,
	kems_translator_infoRtn = 258,
	kems_can_translateRtn = 259,
	kems_translate_fileRtn = 260,
	kems_plugin_finishRtn = 261,
	kems_plugin_configRtn = 262,
	kems_queued_propertiesRtn = 263,
	kems_attacher_infoRtn = 264,
	kems_attacher_hookRtn = 265,
	kems_special_infoRtn = 266,
	kems_special_hookRtn = 267
} kemsRtn;


/* ----------------------------------------------------------------------
	Declarations of real functions that handle the standard
	housekeeping calls of any component.
 */
pascal ComponentResult  FatOpen(ComponentInstance self);
pascal ComponentResult  FatClose(Handle storage, ComponentInstance self);
pascal ComponentResult  FatCanDo(short selector);
pascal ComponentResult  FatVersion(void);
pascal ComponentResult  main(ComponentParameters *params, Handle storage);


/* ----------------------------------------------------------------------
	 These are a bunch of macros to twist the code below into
	 what's needed to accept component manager calls for both
	 the 68K and Power PC
 */
#ifdef __powerc
#define CallCompFuncWithStorage(storage, params, funcName) \
   CallComponentFunctionWithStorage(storage, params, &funcName##RD)
#define CallComponentFunction(params, funcName) \
   CallComponentFunction(params, &funcName##RD)
#define INSTANTIATE_ROUTINE_DESCRIPTOR(funcName) RoutineDescriptor funcName##RD = \
   BUILD_ROUTINE_DESCRIPTOR (upp##funcName##ProcInfo, funcName)
#else
#define CallCompFuncWithStorage(storage, params, funcName) \
   CallComponentFunctionWithStorage(storage, params, (ComponentFunctionUPP)funcName)
#define CallComponentFunction(params, funcName) \
   CallComponentFunction(params, (ComponentFunctionUPP)funcName)
#endif


#ifdef __powerc
/* ----------------------------------------------------------------------
  These are Power pc specific descriptions of stack frames. These must be
  in synch with the fake declarations above and the ones in emsapi.h.
 */
enum {
	uppFatOpenProcInfo = kPascalStackBased
		 | RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		 | STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(ComponentInstance)))
};

enum {
	uppFatCloseProcInfo = kPascalStackBased
		 | RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		 | STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		 | STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(ComponentInstance)))
};

enum {
	uppFatCanDoProcInfo = kPascalStackBased
		 | RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		 | STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
};

enum {
	uppFatVersionProcInfo = kPascalStackBased
		 | RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
};

enum {
	uppFatTargetProcInfo = kPascalStackBased
		 | RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		 | STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		 | STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(ComponentInstance)))
};

enum {
	uppems_plugin_versionProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short *)))
};

enum {
	uppems_plugin_initProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(emsMailConfigP)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(emsPluginInfoP)))
};

enum {
	uppems_translator_infoProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(emsTranslatorP)))
};

enum {
	uppems_can_translateProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(emsTranslatorP)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(emsDataFileP)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(emsResultStatusP)))
};

enum {
	uppems_translate_fileProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(emsTranslatorP)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(emsDataFileP)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(emsProgress)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(emsDataFileP)))
		| STACK_ROUTINE_PARAMETER(6, SIZE_CODE(sizeof(emsResultStatusP)))
};

enum {
	uppems_plugin_finishProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
};

enum {
	uppems_plugin_configProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(emsMailConfigP)))
};

enum {
	uppems_queued_propertiesProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(emsTranslatorP)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long *)))
};

enum {
	uppems_attacher_infoProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(emsMenuP)))
};

enum {
	uppems_attacher_hookProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(emsMenuP)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(FSSpec *)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(long *)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(emsDataFileH*)))
};

enum {
	uppems_special_infoProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(emsMenuP)))
};

enum {
	uppems_special_hookProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(emsMenuP)))
};


INSTANTIATE_ROUTINE_DESCRIPTOR(FatCanDo);
INSTANTIATE_ROUTINE_DESCRIPTOR(FatOpen);
INSTANTIATE_ROUTINE_DESCRIPTOR(FatClose);
INSTANTIATE_ROUTINE_DESCRIPTOR(FatVersion);

INSTANTIATE_ROUTINE_DESCRIPTOR(ems_plugin_version);
INSTANTIATE_ROUTINE_DESCRIPTOR(ems_plugin_init);
INSTANTIATE_ROUTINE_DESCRIPTOR(ems_plugin_finish);

#if EMS_HAS_TRANSLATOR_INFO
INSTANTIATE_ROUTINE_DESCRIPTOR(ems_translator_info);
#endif
#if EMS_HAS_CAN_TRANSLATE
INSTANTIATE_ROUTINE_DESCRIPTOR(ems_can_translate);
#endif
#if EMS_HAS_TRANSLATE_FILE
INSTANTIATE_ROUTINE_DESCRIPTOR(ems_translate_file);
#endif
#if EMS_HAS_PLUGIN_CONFIG
INSTANTIATE_ROUTINE_DESCRIPTOR(ems_plugin_config);
#endif
#if EMS_HAS_QUEUED_PROPERTIES
INSTANTIATE_ROUTINE_DESCRIPTOR(ems_queued_properties);
#endif
#if EMS_HAS_ATTACHER_INFO
INSTANTIATE_ROUTINE_DESCRIPTOR(ems_attacher_info);
#endif
#if EMS_HAS_ATTACHER_HOOK
INSTANTIATE_ROUTINE_DESCRIPTOR(ems_attacher_hook);
#endif
#if EMS_HAS_SPECIAL_INFO
INSTANTIATE_ROUTINE_DESCRIPTOR(ems_special_info);
#endif
#if EMS_HAS_SPECIAL_HOOK
INSTANTIATE_ROUTINE_DESCRIPTOR(ems_special_hook);
#endif

RoutineDescriptor MainRD = BUILD_ROUTINE_DESCRIPTOR(uppComponentRoutineProcInfo, main);
ProcInfoType __procinfo = uppComponentRoutineProcInfo;
#endif __powerc


static Component	gSelfSave;

/* ----------------------------------------------------------------------
	This is the main entry point for the component. The calls for the
	component functions below are really gigantic horrible macros that
	do weird things

	The return values that Eudora actually sees are the translation API return
	values (EMSR_XXXX) in the case of an API call, and Macintosh system error
	in the case of one of the four Component Manager-specific calls.
 */
pascal ComponentResult main(ComponentParameters *params, Handle storage)
{
	ComponentResult		result = noErr;
	short				resRef, saveRes;

	EnterCodeResource();
	if (params->what < 0) {		// Component Manager request code
		switch (params->what) {
			case kComponentOpenSelect:
				result = CallComponentFunction(params, FatOpen);
				break;
			case kComponentCloseSelect:
				result = CallCompFuncWithStorage(storage, params, FatClose);
				break;
			case kComponentCanDoSelect:
				result = CallComponentFunction(params, FatCanDo);
				break;
			case kComponentVersionSelect:
				result = CallComponentFunction(params, FatVersion);
				break;
		//	case kComponentRegisterSelect:  // not supported
			default:
				result = paramErr;
				break;
		}
	}
	else {						// Our request code
		saveRes = CurResFile();
		resRef = OpenComponentResFile(gSelfSave);
		if (resRef < 0)
			return EMSR_TRANS_FAILED;
		UseResFile(resRef);
		switch (params->what) {
			case kems_plugin_versionRtn:
				result = CallCompFuncWithStorage(storage, params, ems_plugin_version);
				break;
			case kems_plugin_initRtn:
				result = CallCompFuncWithStorage(storage, params, ems_plugin_init);
				break;
			case kems_plugin_finishRtn:
				result = CallCompFuncWithStorage(storage, params, ems_plugin_finish);
				break;
#if EMS_HAS_TRANSLATOR_INFO
			case kems_translator_infoRtn:
				result = CallCompFuncWithStorage(storage, params, ems_translator_info);
				break;
#endif
#if EMS_HAS_CAN_TRANSLATE
			case kems_can_translateRtn:
				result = CallCompFuncWithStorage(storage, params, ems_can_translate);
				break;
#endif
#if EMS_HAS_TRANSLATE_FILE
			case kems_translate_fileRtn:
				result = CallCompFuncWithStorage(storage, params, ems_translate_file);
				break;
#endif
#if EMS_HAS_PLUGIN_CONFIG
			case kems_plugin_configRtn:
				result = CallCompFuncWithStorage(storage, params, ems_plugin_config);
				break;
#endif
#if EMS_HAS_QUEUED_PROPERTIES
			case kems_queued_propertiesRtn:
				result = CallCompFuncWithStorage(storage, params, ems_queued_properties);
				break;
#endif
#if EMS_HAS_ATTACHER_INFO
			case kems_attacher_infoRtn:
				result = CallCompFuncWithStorage(storage, params, ems_attacher_info);
				break;
#endif
#if EMS_HAS_ATTACHER_HOOK
			case kems_attacher_hookRtn:
				result = CallCompFuncWithStorage(storage, params, ems_attacher_hook);
				break;
#endif
#if EMS_HAS_SPECIAL_INFO
			case kems_special_infoRtn:
				result = CallCompFuncWithStorage(storage, params, ems_special_info);
				break;
#endif
#if EMS_HAS_SPECIAL_HOOK
			case kems_special_hookRtn:
				result = CallCompFuncWithStorage(storage, params, ems_special_hook);
				break;
#endif
			default:
				result = EMSR_TRANS_FAILED;
				break;
		}
		CloseComponentResFile(resRef);
		UseResFile(saveRes);
	}
	ExitCodeResource();
	return result;
}


/* ----------------------------------------------------------------------
	Standard component function to open a component
 */
pascal ComponentResult FatOpen(ComponentInstance self)
{
	ComponentResult	 result = noErr;
	emsUserGlobals** globals;

	globals = (emsUserGlobals**) NewHandleClear(sizeof(emsUserGlobals));
	if (globals != nil) {
		(**globals).self = (Component) self;	// remember ourselves
		gSelfSave = (Component) self;

		// tell the component manager that we have global storage
		SetComponentInstanceStorage(self, (Handle) globals);
	}
	else
		result = MemError();

	return result;
}


/* ----------------------------------------------------------------------
	Standard component function to close a component
 */
pascal ComponentResult FatClose(Handle storage, ComponentInstance self)
{
	ComponentResult	 result = noErr;
	emsUserGlobals** globals = (emsUserGlobals**) storage;

	if (globals != nil) {
		DisposeHandle((Handle) globals);
		globals = nil;
	}
	return result;
}


/* ----------------------------------------------------------------------
	Standard component function to test availability of a function
	The EMS_HAS_xxx constants are supplied by the translator writer
	in the file usertrans.h
 */
pascal ComponentResult FatCanDo(short selector)
{
	switch (selector) {					// component Manager request codes
		case kComponentOpenSelect:
		case kComponentCloseSelect:
		case kComponentCanDoSelect:
		case kComponentVersionSelect:
	//	case kComponentRegisterSelect:  // not supported
			return true;
		case kems_plugin_versionRtn:
			return EMS_HAS_PLUGIN_VERSION;
		case kems_plugin_initRtn:
			return EMS_HAS_PLUGIN_INIT;
		case kems_translator_infoRtn:
			return EMS_HAS_TRANSLATOR_INFO;
		case kems_can_translateRtn:
			return EMS_HAS_CAN_TRANSLATE;
		case kems_translate_fileRtn:
			return EMS_HAS_TRANSLATE_FILE;
		case kems_plugin_finishRtn:
			return EMS_HAS_PLUGIN_FINISH;
		case kems_plugin_configRtn:
			return EMS_HAS_PLUGIN_CONFIG;
		case kems_queued_propertiesRtn:
			return EMS_HAS_QUEUED_PROPERTIES;
		case kems_attacher_infoRtn:
			return EMS_HAS_ATTACHER_INFO;
		case kems_attacher_hookRtn:
			return EMS_HAS_ATTACHER_HOOK;
		case kems_special_infoRtn:
			return EMS_HAS_SPECIAL_INFO;
		case kems_special_hookRtn:
			return EMS_HAS_SPECIAL_HOOK;
		default:						// unknown request
			return false;
	}
}


/* ----------------------------------------------------------------------
	Standard component function to return the components version
	The version number here is maintained in parallel with the
	API version number.  The high 16 bits are the API version,
	and the low 16 are the component implementation version (unused).
 */
pascal ComponentResult FatVersion(void)
{
	return EMS_VERSION << 16;
}
