/*____________________________________________________________________________
	CTranslator.h
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CTranslator.h,v 1.22 1999/04/26 09:40:17 heller Exp $
____________________________________________________________________________*/
#pragma once


#include "EudoraTypes.h"
#include "MacStrings.h"
#include "PGPPlugTypes.h"
#include "TranslatorIDs.h"
#include "CComboError.h"
#include "pgpKeys.h"
#include "pgpClientLib.h"
#include "MacSecureMemory.h"

#define InitPtrToNil( p )	{ if ( IsntNull( p ) )	*(p) = nil; }

			
typedef enum
{
	kUsePGPMIME = 3,	// arbitrary
	kUseOldPGPFormat
} CipherOutputType;
	
struct PGPKeySpec;

#include "PassphraseCache.h"
#include "pgpEncode.h"
#include "SignatureStatusMessage.h"

class CTranslator
{
public:

	PGPContextRef		mContext;
	PGPtlsContextRef	mTLSContext;
	PGPKeySetRef		mKeySet;

	class EventHandlerData
	{
	public:
		enum { kMagic = 'EHND' };
		ulong			mMagic;
		CTranslator *	mTranslator;
							
	protected:
		EventHandlerData( CTranslator *translator )
		{
			pgpAssert( IsntNull( translator ) );
			mMagic			= kMagic;
			mTranslator	 	= translator;
		}
	};
	
	class EncryptSignEventHandlerData : public EventHandlerData
	{
	public:
		PGPKeyRef		mLastKey;
		
		EncryptSignEventHandlerData( CTranslator *translator )
			: EventHandlerData( translator )
		{
			mLastKey		= kInvalidPGPKeyRef;
		}
		
	};
	
	class DecryptVerifyEventHandlerData : public EventHandlerData
	{
	public:
		Boolean					mHaveSignatureData;
		SignatureStatusInfo		mSignatureData;
		Boolean					mTriedCachedPassphrase;
		short					mOutputFileRef;
		char *					mFYEOData;
		
		PGPClientDecodeEventHandlerData		mClientHandlerData;
		
		DecryptVerifyEventHandlerData( CTranslator *translator )
			: EventHandlerData( translator )
		{
			PGPError	err;
			
			mHaveSignatureData		= FALSE;
			mTriedCachedPassphrase	= FALSE;
			mOutputFileRef			= -1;
			mFYEOData				= nil;
			
			err = PGPInitClientDecodeEventHandlerData(
						translator->mContext,
						translator->mTLSContext,
						translator->mKeySet,
						&mClientHandlerData );
			pgpAssertNoErr( err );
		}
		
		virtual ~DecryptVerifyEventHandlerData( void )
		{
			PGPCleanupClientDecodeEventHandlerData( &mClientHandlerData );
		}
	};
	
protected:
		
	emsProgress		mEudoraProgress;
	
	PGPError		LoadDefaultKeySet( PGPBoolean	writeable );
	
	CComboError		GetSigningPassBuffer(PGPPassBufferRef *passBufferOut,
						PGPKeyRef *signingKeyOut );
				
	CComboError		HandleEncryptSign( const FSSpec *in,
						const FSSpec *out, emsHeaderDataP header,
						Boolean doSign, PGPOptionListRef options,
						Boolean isPGPMime );

	static PGPError (sPGPEncodeEventHandler)(PGPContextRef context,
						PGPEvent *event, PGPUserValue userValue);

	static PGPError (sPGPDecodeEventHandler)(PGPContextRef context,
						PGPEvent *event, PGPUserValue userValue);
	
	virtual PGPError	PGPEncodeEventHandler(PGPContextRef context,
							PGPEvent *event,
							EncryptSignEventHandlerData *data );

	virtual PGPError	PGPDecodeEventHandler(PGPContextRef context,
							PGPEvent *event,
							DecryptVerifyEventHandlerData *data );
	
	PGPError			HandleProgressEvent(PGPEvent *event);
	
	
	
	virtual PluginError	CanTranslateMIMEType( long transContext,
							ConstemsMIMETypeHandle mimeType,
							ConstStr255Param type, ConstStr255Param subType,
							ConstStr255Param protocol );
	
	virtual void		GetErrorString( CComboError err, StringPtr msg);
	virtual void		ReportError( CComboError err );
	
public:
				CTranslator(PGPContextRef context, PGPtlsContextRef tlsContext,
					emsProgress progressHook);
	virtual		~CTranslator( void );
	
	static	PluginError	GetInfo(emsTranslatorP transInfo);
	
	virtual PluginError	CanTranslate(emsTranslatorP trans, emsDataFileP inTransData,
   								emsResultStatusP transStatus);
	
	/* return TRUE if successful; report any errors */
	virtual CComboError		PrepareToTranslate( void );
						
	virtual PluginError	TranslateFile(emsTranslatorP trans, emsDataFileP inFile,
    							emsDataFileP outFile, emsResultStatusP transStatus);
};
