/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPclientLibDialogs.h,v 1.18 1999/03/10 02:47:42 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <Dialogs.h>

#include <PP_Types.h>

#include "MacBasics.h"
#include "pgpPubTypes.h"
#include "pgpGroups.h"
#include "pgpTLS.h"
#include "pflPrefs.h"
#include "WarningAlertTypes.h"

const ResID		kDialogStringListResID			= 4747;
const ResID		kOptionDialogStringListResID	= 4748;
const ResID		kRecipientDialogStringListResID	= 4751;

enum	/* kDialogStringListResID */
{
	kDSSDHKeySizeFormatStrIndex		= 1,
	kImportButtonNameIndex
};


enum	/* kOptionDialogStringListResID */
{
	kDetachedSignatureTitleStrIndex		= 1,
	kDetachedSignatureDescStrIndex,
	kTextOutputTitleStrIndex,
	kTextOutputDescStrIndex,
	kConvEncryptTitleStrIndex,
	kConvEncryptDescStrIndex,
	kWipeOriginalTitleStrIndex,
	kWipeOriginalDescStrIndex,
	kFYEOTitleStrIndex,
	kFYEODescStrIndex,
	kSDATitleStrIndex,
	kSDADescStrIndex,
	kMacBinaryTitleStrIndex,
	
	kFirstMacBinaryMenuItemStrIndex,

	kMacBinaryNoStrIndex				= kFirstMacBinaryMenuItemStrIndex,
	kMacBinarySmartStrIndex,
	kMacBinaryYesStrIndex,
	
	kLastMacBinaryMenuItemStrIndex		= kMacBinaryYesStrIndex,
	
	kMacBinaryDescStrIndex
};

enum	/* kRecipientDialogStringListResID */
{
	kCorporateADKDisabledOrMissingStrIndex	= 1,
	kNoDefaultPrivateKeyFoundStrIndex,
	kMustSelectKeyOrConvEncryptStrIndex,
	kCorporateSigningKeyMissingStrIndex,
	kKeysNotSignedByCorporateKeyStrIndex
};
	

PGPError		PGPGetGroupFromServerInternal(
							PGPContextRef 		context,
							PGPtlsContextRef	tlsContext,
							PGPPrefRef			clientPrefsRef,
							PGPGroupSetRef		groupSet,
							PGPGroupID			groupID,
							const char			*domain,
							PGPUInt32			dialogDelayTicks,
							PGPKeySetRef		*resultSet);

PGPError		PGPGroupListOperationOnServerInternal(
							PGPContextRef		context,
							PGPtlsContextRef	tlsContext,
							PGPKeySetRef		allKeys,
							PGPPrefRef			clientPrefsRef,
							PGPBoolean			sendGroups,
							PGPGroupSetRef		*groupSet );

MessageT		PGPUIWarningAlert(
					WarningAlertType alertType, WarningAlertStyle alertStyle,
					ConstStr255Param message, ConstStr255Param str1 = NULL,
					ConstStr255Param str2=NULL, ConstStr255Param str3 = NULL);
	
MessageT		PGPUIWarningAlert(
					WarningAlertType alertType, WarningAlertStyle alertStyle,
					ResID stringListResID, short stringListIndex,
					ConstStr255Param str1 = NULL,
					ConstStr255Param str2 = NULL,
					ConstStr255Param str3 = NULL);
