/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CCAServer.cp,v 1.6.4.1 1999/06/13 21:34:51 wprice Exp $
____________________________________________________________________________*/
#include "CCAServer.h"
#include "pgpClientLib.h"
#include "MacSecureMemory.h"
#include "pgpClientPrefs.h"
#include "GetPassphrase.h"


CAThread::CAThread(
	PGPkeysCAOp				op,
	PGPKeyRef				key,
	PGPUserIDRef			userID,
	PGPKeySetRef			keySet,
	PGPAttributeValue*		avList,
	PGPUInt32				numAVs,
	PGPEventHandlerProcPtr	eventHandler,
	PGPUserValue			userValue,
	PGPError *				outErr )
        : LThread(	FALSE,
        			thread_DefaultStack,
        			threadOption_Default,
        			(void**) outErr )
{
	mOp				= op;
	mKey			= key;
	mUserID			= userID;
	mKeySet			= keySet;
	mAVList			= avList;
	mNumAVs			= numAVs;
	mUserValue		= userValue;
	mEventHandler	= eventHandler;
	SetResult( (void *)kPGPCA_InProgress );
}

CAThread::~CAThread()
{
}

	void *
CAThread::Run(void)
{
	PGPError						err = kPGPError_NoErr;
	StPGPPreserveKeyServerStorage	keyserverStorage;
	char							serverURL[256];
	PGPKeyServerClass				serverClass;
	PGPKeyServerRef					server = kInvalidPGPKeyServerRef;
	PGPtlsSessionRef				tls = kInvalidPGPtlsSessionRef;
	PGPFilterRef					filter = kInvalidPGPFilterRef;
	CSecureCString256				passphrase;
	PGPByte							*passKey = NULL;
	PGPSize							passKeySize;
	PGPBoolean						split = FALSE;
	PGPSize							expSize,
									reqSize,
									keyIDSize,
									iasnSize;
	PGPInputFormat					iFormat;
	PGPOutputFormat					oFormat;
	PGPExportFormat					eFormat;
	PGPByte *						keyID = NULL,
			*						iasn = NULL,
			*						expBuffer = NULL,
			*						reqBuffer = NULL;
	PGPUInt32						algNum;
	PGPKeyRef						mCAKey;
	PGPSigRef						mCACert;
	
	PGPGetPrefData( gPrefRef, kPGPPrefCARootKeyID, &keyIDSize, &keyID );CKERR;
	PGPGetPrefNumber( gPrefRef, kPGPPrefCARootKeyAlg, &algNum );		CKERR;
	PGPGetPrefData( gPrefRef, kPGPPrefCARootX509IASN, &iasnSize, &iasn );CKERR;
	err = PGPX509CertFromExport( gPGPContext,
			algNum, keyID, iasn, iasnSize, mKeySet, &mCAKey, &mCACert );CKERR;
	if( !PGPSigRefIsValid( mCACert ) )
	{
		err = kPGPError_MissingX509Certificate;
		goto done;
	}
	LThread::Yield();
	LThread::Yield();
	if( mOp == kPGPCA_OP_UpdateCRL )
		err = PGPGetPrefStringBuffer( gPrefRef, kPGPPrefCARevocationServerURL,
										sizeof(serverURL), serverURL );
	else
		err = PGPGetPrefStringBuffer( gPrefRef, kPGPPrefCAServerURL,
										sizeof(serverURL), serverURL );	CKERR;
	err = PGPGetPrefNumber( gPrefRef, kPGPPrefCAType,
								(PGPUInt32 *)&serverClass );			CKERR;
	
	err = PGPNewKeyServer( gPGPContext, serverClass, &server,
				PGPONetURL( gPGPContext, serverURL ),
				PGPOLastOption( gPGPContext ) );						CKERR;
	PGPSetKeyServerEventHandler( server, mEventHandler, mUserValue );
	err = PGPNewTLSSession( gTLSContext, &tls );						CKERR;
	if( PGPKeyRefIsValid( mKey ) &&
		( ( mOp == kPGPCA_OP_RequestCert ) ||
		( ( serverClass == kPGPKeyServerClass_Verisign ) ||
		  	( serverClass == kPGPKeyServerClass_Entrust ) ) ) )
	{
		err = GetPassForKey( mKey, &split, passphrase,
								&passKey, &passKeySize );				CKERR;
	}
	switch( serverClass )
	{
		case kPGPKeyServerClass_NetToolsCA:
			iFormat = kPGPInputFormat_NetToolsCAV1_DataInPKCS7;
			eFormat = kPGPExportFormat_NetToolsCAV1_CertReq;
			oFormat = kPGPOutputFormat_NetToolsCAV1_CertReqInPKCS7;
			break;
		case kPGPKeyServerClass_Verisign:
			iFormat = kPGPInputFormat_VerisignV1_DataInPKCS7;
			eFormat = kPGPExportFormat_VerisignV1_CertReq;
			oFormat = kPGPOutputFormat_VerisignV1_CertReqInPKCS7;
			break;
		case kPGPKeyServerClass_Entrust:
			iFormat = kPGPInputFormat_EntrustV1_DataInPKCS7;
			eFormat = kPGPExportFormat_EntrustV1_CertReq;
			oFormat = kPGPOutputFormat_EntrustV1_CertReqInPKCS7;
			break;
	}
	err = PGPKeyServerOpen( server, tls );								CKERR;
	switch( mOp )
	{
		case kPGPCA_OP_RequestCert:
			LThread::Yield();
			err = PGPExport( gPGPContext,
					PGPOExportKey( gPGPContext, mKey ),
					PGPOAllocatedOutputBuffer( gPGPContext,
						&expBuffer, MAX_PGPSize, &expSize ),
					PGPOExportFormat( gPGPContext, eFormat),
					split ?
						PGPOPasskeyBuffer( gPGPContext, passKey, passKeySize ) :
						PGPOPassphrase( gPGPContext, passphrase),
					PGPOAttributeValue( gPGPContext, mAVList, mNumAVs ),
					PGPOLastOption( gPGPContext ) );					CKERR;
#if 0
			{
				FSSpec fileSpec = {-1, 2, "\pcertreq"};
				short fileRef;
				long count;

				FSpCreate( &fileSpec, 'xxxx', 'xxxx', 0 );
				FSpOpenDF( &fileSpec, fsRdWrPerm, &fileRef );
				count = expSize;
				FSWrite( fileRef, &count, expBuffer );
				FSClose( fileRef );
				err = -1;
			}
#endif
			LThread::Yield();
			err = PGPEncode( gPGPContext,
					PGPOInputBuffer( gPGPContext, expBuffer, expSize),
					PGPOOutputFormat( gPGPContext, oFormat ),
					PGPOAllocatedOutputBuffer( gPGPContext,
							&reqBuffer, MAX_PGPSize, &reqSize ),
					PGPOSignWithKey( gPGPContext, mKey,
						split ?
						PGPOPasskeyBuffer( gPGPContext, passKey, passKeySize ) :
						PGPOPassphrase( gPGPContext, passphrase),
						PGPOLastOption( gPGPContext ) ),
					PGPOLastOption( gPGPContext ) );					CKERR;
			LThread::Yield();
			err = PGPSendCertificateRequest( server,
					PGPOKeyServerCAKey( gPGPContext, mCAKey ),
					PGPOKeyServerRequestKey( gPGPContext, mKey ),
					PGPOInputBuffer( gPGPContext, reqBuffer, reqSize ),
					PGPOLastOption( gPGPContext ) );					CKERR;
			break;
		case kPGPCA_OP_RetrieveCert:
		{
			PGPByte			hashBuffer[128];
			PGPSize			hashSize;
			
			LThread::Yield();
			switch( serverClass )
			{
				case kPGPKeyServerClass_NetToolsCA:
					err = PGPGetKeyPropertyBuffer( mKey,
							kPGPKeyPropX509MD5Hash, sizeof(hashBuffer),
							hashBuffer, &hashSize );					CKERR;
					LThread::Yield();
					err = PGPNewKeyPropertyBufferFilter( gPGPContext,
							kPGPKeyPropX509MD5Hash, hashBuffer, hashSize,
							kPGPMatchEqual, &filter);					CKERR;
					LThread::Yield();
					err = PGPRetrieveCertificate( server, 
							PGPOKeyServerSearchFilter( gPGPContext, filter ),
							PGPOAllocatedOutputBuffer( gPGPContext,
									&expBuffer, MAX_PGPSize, &expSize ),
							PGPOLastOption( gPGPContext ) );			CKERR;
					break;
				case kPGPKeyServerClass_Verisign:
				case kPGPKeyServerClass_Entrust:
					err = PGPRetrieveCertificate( server,
							PGPOSignWithKey( gPGPContext, mKey,
								split ?
								PGPOPasskeyBuffer( gPGPContext,
									passKey, passKeySize ) :
								PGPOPassphrase( gPGPContext, passphrase),
								PGPOLastOption( gPGPContext ) ),
							PGPOKeyServerSearchKey( gPGPContext, mKey ),
							PGPOAllocatedOutputBuffer( gPGPContext,
									&expBuffer, MAX_PGPSize, &expSize ),
							PGPOLastOption( gPGPContext ) );			CKERR;
					break;
			}
			LThread::Yield();
			err = PGPDecode( gPGPContext,
					PGPOInputBuffer( gPGPContext, expBuffer, expSize ),
					PGPODiscardOutput( gPGPContext, TRUE ),
					PGPOImportKeysTo( gPGPContext, mKeySet ),
					PGPOInputFormat( gPGPContext, iFormat ),
					PGPOLastOption( gPGPContext ) );					CKERR;
			break;
		}
		case kPGPCA_OP_UpdateCRL:
			LThread::Yield();
			err = PGPRetrieveCertificateRevocationList( server,
					PGPOKeyServerCAKey( gPGPContext, mCAKey ),
					( serverClass != kPGPKeyServerClass_NetToolsCA ) ?
						PGPOSignWithKey( gPGPContext, mKey,
							split ?
							PGPOPasskeyBuffer( gPGPContext,
								passKey, passKeySize ) :
							PGPOPassphrase( gPGPContext, passphrase),
							PGPOLastOption( gPGPContext ) ) :
						PGPONullOption( gPGPContext ),
					PGPOAllocatedOutputBuffer( gPGPContext, 
							&expBuffer, MAX_PGPSize, &expSize ),
					PGPOLastOption( gPGPContext ) );					CKERR;
			LThread::Yield();
			err = PGPDecode( gPGPContext,
					PGPOInputBuffer( gPGPContext, expBuffer, expSize),
					PGPODiscardOutput( gPGPContext, TRUE),
					PGPOImportKeysTo( gPGPContext, mKeySet ),
					PGPOInputFormat( gPGPContext, iFormat ),
					PGPOLastOption( gPGPContext ) );					CKERR;
			break;
	}
	PGPKeyServerClose( server );

done:
	if( IsntNull( iasn ) )
		PGPFreeData( iasn );
	if( IsntNull( keyID ) )
		PGPFreeData( keyID );
	if( IsntNull( reqBuffer ) )
		PGPFreeData( reqBuffer );
	if( IsntNull( expBuffer ) )
		PGPFreeData( expBuffer );
	if( IsntNull( passKey ) )
		PGPFreeData( passKey );
	if( PGPFilterRefIsValid( filter ) )
		PGPFreeFilter( filter );
	if( PGPKeyServerRefIsValid( server ) )
		PGPFreeKeyServer( server );
	if( PGPtlsSessionRefIsValid( tls ) )
		PGPFreeTLSSession( tls );
	return (void *)err;
}

