/*____________________________________________________________________________
	Copyright (C) 1998 Network Associates, Inc.
	All rights reserved.

	$Id: CCertProperties.h,v 1.3 1998/12/30 10:06:21 wprice Exp $
____________________________________________________________________________*/
#pragma once

#include <LWindow.h>
#include <LListener.h>
#include "pgpKeys.h"

class CKeyTable;

const short	kMaxCertPropWindows	=	16;	// Prevent memory problems

class CCertPropertiesWindow :	public LWindow,
								public LListener
{
public:
	enum { class_ID = 'CERw' };
								CCertPropertiesWindow(LStream *inStream);
								~CCertPropertiesWindow();
	void						ListenToMessage(MessageT inMessage, void *ioParam);

	virtual void				AttemptClose(void);
	virtual void				DoClose(void);
									
	static Boolean				OpenCertProp(	PGPSigRef		cert,
												PGPKeyRef		ownerKey,
												CKeyTable *		table );
	static void					CloseAll();
	
	PGPSigRef					GetCert();
	
private:

	enum
	{
		kX509PropertiesBox		= 'g509',
		kPGPPropertiesBox		= 'gPGP',
		kPGPKeyID				= 'cKID',
		kPGPSignerName			= 'cSNa',
		kX509LongName 			= 'cNam',
		kX509IssuerName			= 'cIss',
		kX509LastCRL			= 'cRev',
		kX509NextCRL			= 'cNRe',
		
		kCertCreationDate		= 'cCre',
		kCertExpirationDate		= 'cExp',
		kCertIcon				= 'iSig',
		kExportableButton		= 'bExp',
		kExpiredButton			= 'bEpi',
		kRevokedButton			= 'bRev',
		
		kGetSignerButton		= 'bSig'
	};

	PGPSigRef					mWindowCert;
	PGPKeyRef					mOwnerKey;
	PGPKeyRef					mSignerKey;
	PGPSigRef					mSignerCert;
	CKeyTable					*mParentTable;

	void						ProcessClose(void);
	void						SetInfo(		PGPSigRef		cert,
												PGPKeyRef		ownerKey,
												CKeyTable *		table );
	
	static CCertPropertiesWindow *sCertWindows[kMaxCertPropWindows];
	static short				sNumCertPropWindows;
		
	enum	{
				kCertPropStringListID		= 1024,
				kNAStringID		= 1,
				kNeverExpiresStringID		= 2
			};
};

