/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CPGPmenu.h,v 1.7.4.1 1999/06/18 18:19:18 jason Exp $
____________________________________________________________________________*/

#pragma once

#include <Menus.h>

#include "pgpClientPrefs.h"
#include "pgpErrors.h"

#include "CPGPException.h"
#include "PGPmenuMESP.h"
#include "CExitToShellPatcher.h"
#include "CDrawMenuBarPatcher.h"
#include "CInsertMenuPatcher.h"
#include "CMenuSelectPatcher.h"
#include "CWaitNextEventDispatcher.h"


class CPGPmenu {
public:
						CPGPmenu(FSSpec * inSpec);
	virtual				~CPGPmenu();
	
	static void			Setmenu(CPGPmenu * inMenu)
							{ sMenu = inMenu; }
	static CPGPmenu *	Getmenu()
							{ PGPThrowIfNULL_(sMenu); return sMenu; }
							
	static void			ShowError(CPGPException & inError);
	
	virtual void		Patch();
	
	FSSpec *			GetPGPmenuSpec() { return &mPGPmenuSpec; }
	
protected:
	class CPGPmenuExitToShellPatch	:	public CExitToShellPatcher {
		virtual void	NewExitToShell();
	};

	class CPGPmenuDrawMenuBarPatch	:	public CDrawMenuBarPatcher {
		virtual void	NewDrawMenuBar();
	};
	friend class CPGPmenuDrawMenuBarPatch;

	class CPGPmenuInsertMenuPatch	:	public CInsertMenuPatcher {
		virtual void	NewInsertMenu(MenuRef theMenu, short beforeID);
	};
	friend class CPGPmenuInsertMenuPatch;

	class CPGPmenuMenuSelectPatch	:	public CMenuSelectPatcher {
	public:
						CPGPmenuMenuSelectPatch() : mSemaphore(0) { }
	protected:
		PGPInt16		mSemaphore;
		virtual long	NewMenuSelect(Point startPt);
	};
	friend class CPGPmenuMenuSelectPatch;

	class CPGPmenuWaitNextEventPatch	:	public CWaitNextEventDispatcher {
		virtual void	FirstEvent();
		virtual void	HandleKeyDown();
		virtual void	HandleIdleEvents();
	};
	friend class CPGPmenuWaitNextEventPatch;

	static CPGPmenu *	sMenu;
	static const OSType	kPGPkeysType;
	static const OSType	kPGPkeysCreator;
	static const OSType	kPGPtoolsType;
	static const OSType	kPGPtoolsCreator;
	static const OSType	kPGPnetType;
	static const OSType	kPGPnetCreator;
	
	FSSpec				mPGPmenuSpec;
	PGPUInt32			mPGPPrefsUpdateCount;
	PGPBoolean			mPatchExitToShell;
	PGPBoolean			mPatchDrawMenuBar;
	PGPBoolean			mPatchInsertMenu;
	PGPBoolean			mPatchMenuSelect;
	PGPBoolean			mPatchWaitNextEvent;
	PGPBoolean			mEncryptEnabled;
	PGPBoolean			mSignEnabled;
	PGPBoolean			mDecryptEnabled;
	PGPBoolean			mVerifyEnabled;
	PGPBoolean			mClearPassphraseCachesEnabled;
	PGPBoolean			mForceRecipientsDialog;
	MenuHandle			mMenuHandle;
	Handle				mMenuIconSuite;
	PGPmenuHotkeys		mHotKeys;
	
	virtual void		Initialize();
	
	virtual void		CreateMenu();
	virtual void		DeleteMenu();
	virtual void		DrawMenuBar();
	virtual void		InsertMenu(short * beforeID);
	virtual void		AdjustMenuItems();
	virtual long		FilterMenuSelect(long inResult);
	virtual void		RestoreMenuItems();
	virtual void		HandleKeyDown();
	virtual void		CheckPrefs();
	virtual void		UpdatePrefs();
	
	virtual void		Sign();
	virtual void		Encrypt();
	virtual void		EncryptAndSign();
	virtual void		DecryptVerify();
	virtual void		ClearPassphraseCaches();
	virtual void		LaunchPGPkeys();
	virtual void		LaunchPGPtools();
	virtual void		LaunchPGPnet();
	
private:
	void				CheckBeta();
};