/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: StSaveCurResFile.cp,v 1.5 1999/04/02 09:21:08 jason Exp $
____________________________________________________________________________*/

#include <LowMem.h>

#include "StSaveCurResFile.h"


StSaveCurResFile::StSaveCurResFile(
	Boolean	inResLoad)
{
	Initialize(inResLoad);
}



StSaveCurResFile::StSaveCurResFile(
	SInt16	inRefNum,
	Boolean	inResLoad)
{
	Initialize(inResLoad);
	::UseResFile(inRefNum);
}



StSaveCurResFile::StSaveCurResFile(
	FSSpec	inSpec,
	SInt16	inPerm,
	Boolean	inResLoad)
		: mOpenedFile(inSpec)
{
	Initialize(inResLoad);
	mOpenedFile.OpenResourceFork(inPerm);
}
					


StSaveCurResFile::~StSaveCurResFile()
{
	::UseResFile(mSavedResFile);
	::LMSetResLoad(mResLoad);
}



	void
StSaveCurResFile::Initialize(
	Boolean	inResLoad)
{
	mSavedResFile = ::CurResFile();
	mResLoad = ::LMGetResLoad();
	::SetResLoad(inResLoad);
}