/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: pgpNavServices.cp,v 1.6 1999/03/10 02:53:39 heller Exp $
____________________________________________________________________________*/

#include "pgpNavServices.h"
#include "MacStrings.h"
#include "pgpMem.h"


typedef struct PGPOSTypeList
{
	PGPUInt16	count;
	OSType		*list;
} PGPOSTypeList;


	pascal Boolean
PGPNavFilterProc(
	AEDesc *				theItem,
	void *					info,
	NavCallBackUserData		callBackUD,
	NavFilterModes			filterMode );
	pascal void
PGPNavEventProc(
	NavEventCallbackMessage	callbackSelector,
	NavCBRecPtr				callbackParms,
	NavCallBackUserData		callbackUD );

	pascal Boolean
PGPNavFilterProc(
	AEDesc *				theItem,
	void *					info,
	NavCallBackUserData		callBackUD,
	NavFilterModes			filterMode )
{
	OSErr					theErr = noErr;
	Boolean					display = true;
	NavFileOrFolderInfo *	theInfo = (NavFileOrFolderInfo *)info;
	PGPOSTypeList *			typeList = (PGPOSTypeList *) callBackUD;

	if( theItem->descriptorType == typeFSS )
		if ( !theInfo->isFolder && ( filterMode == kNavFilteringBrowserList ) )
		{
			PGPUInt16	typeIndex;
			
			display = false;
			for( typeIndex = 0; typeIndex < typeList->count; typeIndex++ )
			{
				if( theInfo->fileAndFolder.fileInfo.finderInfo.fdType ==
					typeList->list[typeIndex] )
				{
					display = true;
					break;
				}
			}
		}
	return display;
}

	OSErr
PGPNavGetFileOrFolder(
	Boolean					chooseFolder,
	Str255					message,
	OSType					defaultCreator,
	PGPUInt16				numTypes,
	OSType *				allowTypes,
	NavEventProcPtr			updateFunc,
	FSSpec *				choice )
{
	OSErr					osErr;
	NavReplyRecord			navRR;
	NavDialogOptions		navDO;
	NavEventUPP				navEP = NewNavEventProc( updateFunc );
	NavObjectFilterUPP		navOF = NewNavObjectFilterProc( PGPNavFilterProc );
	PGPOSTypeList			typeList;
	NavTypeListHandle		navTypeHand = NULL;
	WindowRecord			*frontWindow;
	short					saveWindowKind;
	
	DebugPatches_DisableWhackFreeSpace();
	
	/*
	** Stupid Appearance Manager has bugs where controls in underlying
	** dialogs will get automatically disabled. Temporarily set the
	** front window's windowKind to be something other that dialogKind
	** to work around this.
	*/
	
	frontWindow = (WindowRecord *) FrontWindow();
	
	saveWindowKind = frontWindow->windowKind;
	frontWindow->windowKind = kApplicationWindowKind;

	osErr = NavGetDefaultDialogOptions( &navDO ); if( osErr ) goto done;
	navDO.dialogOptionFlags = kNavAllFilesInPopup;
	CopyPString( message, navDO.message );
	CopyPString( LMGetCurApName(), navDO.clientName );
	
	if( chooseFolder )
		osErr = NavChooseFolder( NULL, &navRR, &navDO, navEP, NULL, NULL );
	else
	{
		typeList.count	= numTypes;
		typeList.list	= allowTypes;
		
		navTypeHand = (NavTypeListHandle) NewHandle( sizeof(NavTypeList) +
						( sizeof( OSType ) * ( numTypes - 1 ) ) );
		if( IsntNull( navTypeHand ) )
		{
			(*navTypeHand)->componentSignature	= defaultCreator;
			(*navTypeHand)->reserved			= 0;
			(*navTypeHand)->osTypeCount			= numTypes;
			for( PGPUInt16 typeIndex = 0; typeIndex < numTypes; typeIndex++ )
				(*navTypeHand)->osType[typeIndex] = allowTypes[typeIndex];
		}
		
		osErr = NavGetFile( NULL, &navRR, &navDO, navEP, NULL, NULL, //navOF,
						navTypeHand, (NavCallBackUserData) &typeList );
	}
	
	frontWindow->windowKind = saveWindowKind;

	if( navRR.validRecord && ( osErr == noErr ) )
	{
		AEDesc				aed;
		
		osErr = AEGetNthDesc( &navRR.selection, 1, typeFSS, NULL, &aed );
		if( osErr == noErr )
		{
			BlockMoveData( *aed.dataHandle, choice, sizeof( FSSpec ) );
			AEDisposeDesc( &aed );
		}
		NavDisposeReply( &navRR );
	}
done:
	if( IsntNull( navTypeHand ) )
	{
		HUnlock( (Handle) navTypeHand );
		DisposeHandle( (Handle) navTypeHand );
	}
	DisposeRoutineDescriptor( navEP );
	DisposeRoutineDescriptor( navOF );
	
	DebugPatches_EnableWhackFreeSpace();

	return osErr;
}

typedef struct PGPNavCallbackData
{
	NavMenuItemSpecHandle	addItem;
	PGPBoolean				itemSelected;
	NavEventProcPtr			updateFunc;
} PGPNavCallbackData;

	pascal void
PGPNavEventProc(
	NavEventCallbackMessage	callbackSelector,
	NavCBRecPtr				callbackParms,
	NavCallBackUserData		callbackUD )
{
	PGPNavCallbackData		*necd = (PGPNavCallbackData *) callbackUD;
	
	switch( callbackSelector )
	{
		case kNavCBPopupMenuSelect:
		{
			NavMenuItemSpec *	nms;
			
			if( IsntNull( necd->addItem ) )
			{
				nms = (NavMenuItemSpec *) callbackParms->eventData.param;
				if( ( nms->menuCreator == (*necd->addItem)->menuCreator ) &&
					( nms->menuType == (*necd->addItem)->menuType ) )
				{
					necd->itemSelected = TRUE;
				}
				else
					necd->itemSelected = FALSE;
			}
			break;
		}
	}
	(necd->updateFunc)( callbackSelector, callbackParms, callbackUD );
}

	OSErr
PGPNavPutFile(
	Str255					message,
	Str255					defaultName,
	OSType					fileType,
	OSType					fileCreator,
	PGPNavReply *			navReply,
	NavMenuItemSpecHandle	addItem,
	PGPBoolean *			itemSelected,
	NavEventProcPtr			updateFunc,
	FSSpec *				choice )
{
	OSErr					osErr;
	NavReplyRecord			navRR;
	NavReplyRecord *		navRRP;
	NavDialogOptions		navDO;
	NavEventUPP				navEP = NewNavEventProc( PGPNavEventProc );
	PGPNavCallbackData		navCD;
	WindowRecord			*frontWindow;
	short					saveWindowKind;
	
	DebugPatches_DisableWhackFreeSpace();

	/*
	** Stupid Appearance Manager has bugs where controls in underlying
	** dialogs will get automatically disabled. Temporarily set the
	** front window's windowKind to be something other that dialogKind
	** to work around this.
	*/
	
	frontWindow = (WindowRecord *) FrontWindow();
	
	saveWindowKind = frontWindow->windowKind;
	frontWindow->windowKind = kApplicationWindowKind;
	
	osErr = NavGetDefaultDialogOptions( &navDO ); if( osErr ) goto done;
	if( IsntNull( navReply ) )
	{
		navRRP = &navReply->rr;
		navDO.dialogOptionFlags = 0;
	}
	else
	{
		navRRP = &navRR;
		navDO.dialogOptionFlags =	kNavDontAutoTranslate |
									kNavDontAddTranslateItems;
	}
	if( IsntNull( addItem ) )
		navDO.popupExtension = (Handle) addItem;
	CopyPString( message, navDO.message );
	CopyPString( LMGetCurApName(), navDO.clientName );
	CopyPString( defaultName, navDO.savedFileName );
	
	navCD.addItem = addItem;
	navCD.itemSelected = FALSE;
	navCD.updateFunc = updateFunc;
	
	osErr = NavPutFile( NULL, navRRP, &navDO, navEP,
						fileType, fileCreator, (NavCallBackUserData) &navCD );
	if( IsntNull( itemSelected ) )
		*itemSelected = navCD.itemSelected;

	frontWindow->windowKind = saveWindowKind;

	if( navRRP->validRecord && ( osErr == noErr ) )
	{
		AEDesc				aed;
		
		osErr = AEGetNthDesc( &navRRP->selection, 1, typeFSS, NULL, &aed );
		if( osErr == noErr )
		{
			BlockMoveData( *aed.dataHandle, choice, sizeof( FSSpec ) );
			if( navRRP->replacing )
				osErr = FSpDelete( choice );
			AEDisposeDesc( &aed );
		}
		
		if( IsNull( navReply ) )
			NavDisposeReply( navRRP );
	}
	
done:
	DisposeRoutineDescriptor( navEP );

	DebugPatches_EnableWhackFreeSpace();

	return osErr;
}

	OSErr
PGPNavFinishSave(
	PGPNavReply	*			navReply )
{
	DebugPatches_DisableWhackFreeSpace();

	OSErr osErr = NavCompleteSave( &navReply->rr, kNavTranslateInPlace );
	NavDisposeReply( &navReply->rr );

	DebugPatches_EnableWhackFreeSpace();

	return osErr;
}

