/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CXferWindow.cp,v 1.4 1999/03/10 02:42:00 heller Exp $
____________________________________________________________________________*/
#include <PP_KeyCodes.h>

#include "CXferWindow.h"

#include "PGPFMacUtils.h"
#include "CXferView.h"
#include "CXferThread.h"
#include "CFileDrop.h"
#include "CFileTable.h"
#include "CMessageQueue.h"
#include "PGPFoneApplication.h"
#include "CStatusPane.h"
#include "IterateDirectory.h"

#include <string.h>

pascal void DirectoryRecurseFilter(const CInfoPBRec * const cpbPtr,
											  Boolean *quitFlag,
											  void *priv);

CXferWindow *
CXferWindow::CreateXferWindowStream(
	LStream *inStream)
{
	return (new CXferWindow(inStream));
}

CXferWindow::CXferWindow(LStream *inStream)
	:		LWindow(inStream)
{
}

CXferWindow::~CXferWindow()
{
}

void
CXferWindow::FinishCreateSelf()
{
	mXferQueue = NIL;
	mXfer = NIL;
	mSends = NIL;
	mNumSends = mNumReceives = 0;
	mSendFocus = true;
	mAbortSend = (LCicnButton *)FindPaneByID('bAot');
	mAbortReceive = (LCicnButton *)FindPaneByID('bAin');
	mXVSend = (CXferView *)FindPaneByID('xfot');
	mXVReceive = (CXferView *)FindPaneByID('xfin');
	mReceiveTable = (CFileTable *)FindPaneByID('lFin');
	mReceiveTable->AddListener(this);
	mReceiveTable->InsertCols(1, 1, NIL, 0, TRUE);
	mSendTable = (CFileTable *)FindPaneByID('lFot');
	mSendTable->AddListener(this);
	mSendTable->InsertCols(1, 1, NIL, 0, TRUE);
	mSendScroller = (LActiveScroller *)FindPaneByID('scot');
	mRcvScroller = (LActiveScroller *)FindPaneByID('scin');
	mXVSend->SetDirection(true);
	mXVReceive->SetDirection(false);
	mXVSend->SetAbortButton(mAbortSend);
	mXVReceive->SetAbortButton(mAbortReceive);
	mAbortSend->AddListener(this);
	mAbortReceive->AddListener(this);
	((CFileDrop *)FindPaneByID('fdrp'))->AddListener(this);
	
	StartIdling();
}

void
CXferWindow::DrawSelf()
{
	Rect frame;
	
	LWindow::DrawSelf();
	FocusDraw();
	CalcLocalFrameRect(frame);
	::ForeColor(whiteColor);
	::MoveTo(0,0);
	::LineTo(frame.right, 0);
	::MoveTo(0,0);
	::LineTo(0, frame.bottom);
	::RGBForeColor(&gGrayRamp[6]);
	::MoveTo(0, frame.bottom-1);
	::LineTo(frame.right-16, frame.bottom-1);
	::LineTo(frame.right-16, frame.bottom-16);
	::LineTo(frame.right-1, frame.bottom-16);
	::LineTo(frame.right-1, frame.top);
	DrawFocus();
}

void
CXferWindow::DrawFocus()
{
	RGBColor focusColor;
	Rect frame;
	
	FocusDraw();
	ApplyForeAndBackColors();
	::PenNormal();
	::PenSize(2, 2);
	if(!mSendFocus)
		GetBackColor(&focusColor);
	else
		focusColor.red = focusColor.green = focusColor.blue = 0;
	::RGBForeColor(&focusColor);
	mSendScroller->CalcPortFrameRect(frame);
	::InsetRect(&frame, -3, -3);
	::FrameRect(&frame);
	if(mSendFocus)
		GetBackColor(&focusColor);
	else
		focusColor.red = focusColor.green = focusColor.blue = 0;
	::RGBForeColor(&focusColor);
	mRcvScroller->CalcPortFrameRect(frame);
	::InsetRect(&frame, -3, -3);
	::FrameRect(&frame);
}

void
CXferWindow::AddSend(HFSFlavor *hfsfp)
{
	HFSLinked *h, *walk;
	
	if(h = (HFSLinked *)pgp_malloc(sizeof(HFSLinked)))
	{
		h->next = NIL;
		BlockMoveData(hfsfp, &h->hfsf, sizeof(HFSFlavor));
		if(!mSends)
			mSends = h;
		else
		{
			for(walk=mSends;walk->next;walk=walk->next);
			walk->next = h;
		}
		StartIdling();
	}
}

void
CXferWindow::DequeueSend(XSendFile *nxs)
{
	short inx;
	
	for(inx=0;inx<mNumSends;inx++)
		if(nxs == mQSends[inx])
		{
			mSendTable->RemoveRows(1, inx+1, true);
			::BlockMoveData(&mQSends[inx+1], &mQSends[inx],
						sizeof(XSendFile *) * (mNumSends - inx - 1));
			mNumSends--;
			break;
		}
}

void
CXferWindow::DequeueReceive(XRcvFile *nxr)
{
	short inx;
	
	for(inx=0;inx<mNumReceives;inx++)
		if(nxr == mQReceives[inx])
		{
			mReceiveTable->RemoveRows(1, inx+1, true);
			::BlockMoveData(&mQReceives[inx+1], &mQReceives[inx],
						sizeof(XRcvFile *) * (mNumReceives - inx - 1));
			mNumReceives--;
			break;
		}
}

void
CXferWindow::QueueSend(XSendFile *nxs)
{
	FileTableRec ftr;
	
	pgpAssert(mNumSends<MAXSNDFILES);
	mQSends[mNumSends++] = nxs;
	pstrcpy(ftr.name, nxs->xi.file.name);
	ftr.xi = &nxs->xi;
	mSendTable->InsertRows(1, 1024, &ftr, sizeof(FileTableRec), true);
}

void
CXferWindow::QueueReceive(XRcvFile *nxr)
{
	FileTableRec ftr;
	
	if(!mNumReceives)
		Show();
	pgpAssert(mNumReceives<MAXRCVFILES);
	mQReceives[mNumReceives++] = nxr;
	pstrcpy(ftr.name, nxr->xi.file.name);
	ftr.xi = &nxr->xi;
	mReceiveTable->InsertRows(1, 1024, &ftr, sizeof(FileTableRec), true);
}

void
CXferWindow::ListenToMessage(MessageT inMessage, void *ioParam)
{
	switch(inMessage)
	{
		case 'bAin':	// Abort receive
			mXferQueue->Send(_mt_abortReceive);
			break;
		case 'bAot':	// Abort send
			mXferQueue->Send(_mt_abortSend);
			break;
		case 'ckFT':	// Clicked receive list
			if(mSendFocus && (mReceiveTable == ioParam))
			{
				mSendFocus = !mSendFocus;
				DrawFocus();
			}
			else if(!mSendFocus && (mSendTable == ioParam))
			{
				mSendFocus = !mSendFocus;
				DrawFocus();
			}
			break;
	}
}

void
CXferWindow::SetXferThread(CXferThread *xferThread)
{
	mXfer = xferThread;
	if(xferThread)
		mXferQueue = xferThread->GetQueue();
	else
		mXferQueue = NIL;
}

void
CXferWindow::StartSend(XferInfo *xi)
{
	mSendTable->RemoveRows(1, 1, true);
	mNumSends--;
	::BlockMoveData(&mQSends[1], &mQSends[0],
					sizeof(XSendFile *) * mNumSends);
	mXVSend->StartXfer(xi);
}

void
CXferWindow::StartReceive(XferInfo *xi)
{
	mReceiveTable->RemoveRows(1, 1, true);
	mNumReceives--;
	::BlockMoveData(&mQReceives[1], &mQReceives[0],
					sizeof(XRcvFile *) * mNumReceives);
	mXVReceive->StartXfer(xi);
}

void
CXferWindow::EndSend()
{
	mXVSend->EndXfer(mNumSends);
}

void
CXferWindow::EndReceive()
{
	mXVReceive->EndXfer(mNumReceives);
}

void
CXferWindow::SendFile(FSSpec *fs, Boolean inDir)
{
	XferFileSpec *fss;

	fss = (XferFileSpec *)pgp_malloc(sizeof(XferFileSpec));
	::BlockMoveData(fs, &fss->fs, sizeof(FSSpec));
	if(!inDir)
	{
		fss->rootDir = fs->parID;
		fss->rootVol = fs->vRefNum;
	}
	else
	{
		fss->rootDir = mRootDir;
		fss->rootVol = mRootVol;
	}
	if(mXferQueue)
		mXferQueue->Send(_mt_sendFile, fss, sizeof(XferFileSpec), 0);
	else	// oops, there is no xfer thread!
		pgp_free(fss);
}

pascal void DirectoryRecurseFilter(const CInfoPBRec * const cpbPtr,
											  Boolean */*quitFlag*/,
											  void *priv)
{
	if((cpbPtr->hFileInfo.ioFlAttrib & ioDirMask) == 0)
	{	// make sure it is a file not a directory
		CXferWindow *cxw = (CXferWindow *)priv;
		FSSpec fs;
		
		fs.parID = cpbPtr->hFileInfo.ioFlParID;
		fs.vRefNum = cpbPtr->hFileInfo.ioVRefNum;
		pstrcpy(fs.name, cpbPtr->hFileInfo.ioNamePtr);
		cxw->SendFile(&fs, TRUE);
	}
}

void
CXferWindow::SpendTime(const EventRecord &/*inMacEvent*/)
{
	if(mSends)
	{
		HFSLinked *first = mSends;
		HFSFlavor *hfsf;
		
		hfsf=(HFSFlavor *)&mSends->hfsf;
		if((hfsf->fileCreator == 'MACS') && (hfsf->fileType == 'fold'))
		{
			// they dropped a folder, so we need to walk the whole folder tree
			// and insert each file
			mRootDir = hfsf->fileSpec.parID;
			mRootVol = hfsf->fileSpec.vRefNum;
			FSpIterateDirectory(&hfsf->fileSpec, 0, DirectoryRecurseFilter, this);
		}
		else if((hfsf->fileCreator != 'MACS') || (hfsf->fileType != 'disk'))
		{	// the above filters out disks
			SendFile(&hfsf->fileSpec, FALSE);
		}
		mSends = mSends->next;
		pgp_free(first);
		if(!mSends)
			StopIdling();
	}
}

void
CXferWindow::DeleteFromFocus()
{
	STableCell cell;
	
	if(mSendFocus)
	{
		cell.row = cell.col = 0;
		if(mSendTable->GetNextSelectedCell(cell))
		{
			mXferQueue->Send(_mt_abortSend, mQSends[cell.row-1]);
			mSendTable->RemoveRows(1, cell.row, true);
			::BlockMoveData(&mQSends[cell.row], &mQSends[cell.row-1],
						sizeof(XSendFile *) * (mNumSends - cell.row));
			mNumSends--;
		}
	}
	else
	{
		cell.row = cell.col = 0;
		if(mReceiveTable->GetNextSelectedCell(cell))
		{
			mXferQueue->Send(_mt_abortReceive, mQReceives[cell.row-1]);
			mReceiveTable->RemoveRows(1, cell.row, true);
			::BlockMoveData(&mQReceives[cell.row], &mQReceives[cell.row-1],
						sizeof(XRcvFile *) * (mNumReceives - cell.row));
			mNumReceives--;
		}
	}
}

Boolean
CXferWindow::ObeyCommand(
	CommandT	inCommand,
	void		*ioParam)
{
	Boolean	cmdHandled = true;

	switch (inCommand)
	{
		case cmd_Cut:
		case cmd_Clear:
			DeleteFromFocus();
			break;
		default:
			cmdHandled = LWindow::ObeyCommand(inCommand, ioParam);
			break;
	}
	return cmdHandled;
}

void
CXferWindow::FindCommandStatus(
	CommandT	inCommand,
	Boolean		&outEnabled,
	Boolean		&outUsesMark,
	Char16		&outMark,
	Str255		outName)
{
	outUsesMark = false;
	switch(inCommand)
	{
		case cmd_Cut:
		case cmd_Clear:
			outEnabled = true;
			break;
		default:
			LWindow::FindCommandStatus(inCommand, outEnabled,
										outUsesMark, outMark, outName);
			break;
	}
}

Boolean
CXferWindow::HandleKeyPress(
	const EventRecord&	inKeyEvent)
{
	Boolean	keyHandled = true;
	Char16	theChar = inKeyEvent.message & charCodeMask;
	
	if(theChar == char_Tab)
	{
		mSendFocus = !mSendFocus;
		DrawFocus();
	}
	else if(theChar == char_Backspace)
	{
		DeleteFromFocus();
	}
	else
		keyHandled = LWindow::HandleKeyPress(inKeyEvent);
	return keyHandled;
}

