/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: PGPFoneApplication.h,v 1.6 1999/03/10 02:50:57 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LGADialog.h>
#include <LAttachment.h>
#include <LPeriodical.h>
#include <LApplication.h>
#include <LModelDirector.h>
#include <LMenuBar.h>

#include "PGPFone.h"

class CPFWindow;

class CTimeAttachment : public LAttachment 
{
public:
					CTimeAttachment(CPFWindow *pfWindow);
	void			SetFoneTime(Boolean inFone);
protected:
	virtual	void	ExecuteSelf(MessageT inMessage, void *ioParam);
	
	Boolean			mFoneTime;
	long			mNextSystemTime, mNextOSTime;
	ushort			mLastModifiers;
	CPFWindow		*mPFWindow;
};

class	PGPFoneApplication :	public LApplication,
								public LPeriodical
{
public:
						PGPFoneApplication();
						~PGPFoneApplication();

	Boolean				ObeyCommand(CommandT inCommand, void *ioParam = nil);
	void				FindCommandStatus(CommandT inCommand,
							Boolean &outEnabled, Boolean &outUsesMark,
							Char16 &outMark, Str255 outName);
	virtual void		HandleAppleEvent(
								const AppleEvent&	inAppleEvent,
								AppleEvent&			outAEReply,
								AEDesc&				outResult,
								SInt32				inAENumber);
	void				ShowAboutBox();
	void				FindSerialDevices();
	void				SpendTime(const EventRecord &inMacEvent);
	void				AddRandomEntropy();
	Boolean				AllowSubRemoval(LCommander	*inSub);
	virtual void		MakeModelDirector();
	virtual void		MakeMenuBar();
	
	void				ShowSplashScreen();
	void				EndSplashScreen();
	
	CTimeAttachment		*mTimeAttachment;
private:
	
	CPFWindow			*mPFWindow;
	LGADialog			*mSplashScreen;
	LWindow				*mAuthWindow, *mXferWindow;
	LModelDirector		*mModelDirector;
	LMenuBar			*mMenuBar;
	Boolean				mAdjustCursor;	// for spinning the cursor
	ulong				mSplashDisplayTime;
};

