/*  Hey Emacs, switch to -*-C-*-, please 

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.

 */


#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <stdlib.h>

#include <malloc.h>

#include "pgplib.h"

static char *progname;

void
usage()
{
    fprintf(stderr, "usage: %s [-d] infile outfile\n", progname);
    exit(1);
}

void
main(int argc, char *argv[])
{
    FILE	*fin, *fout;
    extern char *optarg;
    extern int 	optind;
    int		iflag, oflag, deflag;
    int		ch;
    int		i;
    long	file_size;
    u_char	*ibuf, *tmp;
    u_char	*buffer;
    int		buf_len;
    int		used;

    progname = argv[0];
    
    fout = stdout;
    iflag = oflag = deflag = 0;
    while ((ch = getopt(argc, argv, "di:o:")) != -1)
	switch(ch) {
	case 'd':
	    deflag = 1;
	    break;
	case 'i':
	    if ( iflag )
		usage();
	    iflag = 1;
	    if ( (fin = fopen(optarg, "r")) == NULL) {
		perror("fopen");
		exit(1);
	    }
	    fseek(fin, 0L, SEEK_END);
	    file_size = ftell(fin);
	    ibuf = calloc(file_size, 1);
	    if ( ibuf == NULL ) {
		fprintf(stderr, "Out of memory\n");
		exit(1);
	    }
	    rewind(fin);
	    i = fread(ibuf, file_size, 1, fin);
	    if ( i != 1 ) {
		fprintf(stderr, "Error: fread\n");
		exit(1);
	    }
	    fclose(fin);

	    break;
	case 'o':
	    if ( oflag )
		usage();
	    oflag = 1;
	    if (( fout = fopen(optarg, "w+")) == NULL) {
		perror("open");
		exit(1);
	    }

	    break;
	case '?':
	default:
	    usage();
	}

    if ( iflag == 0 ) {
	int num_buf;

	ibuf = calloc(BUFSIZ, 1);
	file_size = num_buf = 0;
	while ((i = fread(ibuf+(num_buf*BUFSIZ), 1, BUFSIZ, stdin)) == BUFSIZ) {
	    file_size += i;
	    i = 0;
	    tmp = realloc(ibuf, (num_buf+1)*BUFSIZ);
	    if ( tmp == NULL ) {
		fprintf(stderr, "Out of memory\n");
		exit(1);
	    }
	    num_buf += 1;
	}
	if ( i != 0)
	    file_size += i;
    }
    if ( deflag ) {
	used = dearmor_buffer(ibuf, file_size, &buffer, &buf_len);
	switch ( used ) {
	case -1:
	    fprintf(stderr, "Internal Error\n");
	    exit(-1);
	case 0:
	    fprintf(stderr, "Incorrect format\n");
	    exit(-1);
	default:
	    fprintf(stderr, "Used %d bytes\n", used);
	    i = fwrite(buffer, buf_len, 1, fout);
	    if ( i != 1 ) {
		fprintf(stderr, "Could not write result\n");
		exit(-1);
	    }
	    fflush(fout);
	}
    }
    else {
	armor_buffer(ibuf, file_size, (char **)&buffer, &buf_len);
	i = fwrite(buffer, buf_len, 1, fout);
	exit(0);
    }
}
