/*  Hey Emacs, switch to -*-C-*-, please 
(Emacs, please switch to -*-indented-text-*- mode)
------------

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.


 */

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>
#include <malloc.h>


#include <md5.h>
#include <bn.h>

#include "pgplib.h"
#include "pgp_m.h"

#define PASSWORD "Test"

char 	*progname;
int 	verbose;
int	more_to_do;

void
usage(void)
{
    fprintf(stderr, "Usage: %s [-v] [-p password] [-k pubring] file\n", 
	    progname);
    exit(1);
}

int 
main(int argc, char *argv[])
{
    /* Used by getopt */
    extern char	*optarg;
    extern int 	optind;
    
    /* USed to keep context between calls */
    char 	password[32];	
    MD5_CTX 	context;
    unsigned char digest[16];
    unsigned char CTB;
    int 	length;
    int 	count, used;
    int 	fd;
    unsigned char *file_buf;
    char 	*pubring;
    struct stat s_buf;
    /* scratch variables */
    int 	i, j,ch;
    unsigned char *data;

    PGPliteral_t	literal;


    progname = argv[0];
    password[0] = 0;
    pubring = NULL;
    fd = NULL;
    verbose = 0;
    count = 0;

    while ((ch = getopt(argc, argv, "vp:k:")) != -1) {
	switch(ch) {
	case 'k':
	    i = strlen(optarg);
	    if ( i > MAXPATHLEN) {
		fprintf(stderr, "%s: Pubring too long\n", progname);
		exit(1);
	    }
	    else
		pubring = strdup(optarg);
	    break;
	case 'p':
	    if ( strlen(optarg) > 31 ) {
		(void) fprintf(stderr, "%s: Password too long\n", progname);
		exit(1);
	    }
	    strcpy(password, optarg);
	    break;
	case 'v':
	    verbose = 1;
	    break;
	default:
	    usage();
	}
    }
    argc -= optind;
    argv += optind;

    if ((fd = open(argv[0], O_RDONLY, 0)) < 0) {
	usage();
    }
    if ( password[0] == 0 ) 
	strcpy(password, PASSWORD);

    /* Get the entire file into memory for easy access */

    i = fstat(fd, &s_buf);
    if ( i < 0 ) {
	perror(progname);
	exit(1);
    }
    length = s_buf.st_size;
    file_buf = (unsigned char *)calloc(length, 1);
    if (file_buf == NULL ) {
	fprintf(stderr, "Out of memory on %s:%d\n", __FILE__, __LINE__);
	exit(1);
    }
    i = read(fd, file_buf, length);
    if ( i != length ) {
	perror(progname);
	exit(1);
    }
    /* Since PGP has many layers of "objects", we must loop over them
     * and do whatever we have to do.
     */
    
    more_to_do = 0;
    do { 
	CTB = *file_buf;
    
	/* This test is _very_ weak */
	if ( ! is_ctb(CTB)) {
	    fprintf(stderr, "First byte definitely not CBT, but %d\n", (int)CTB);
	    exit(1);
	}

	/* Find the type */
	switch ( (CTB & CTB_TYPE_MASK) >> 2) {

	case CTB_USERID_TYPE: {
	    PGPuserid_t uid;
	    
	    if ( verbose )
		fprintf(stdout, "CTB is UID package\n");
	    used = buf2userid(file_buf, length, &uid);
	    fprintf(stdout, "Name = %s\n", uid.name);
	    free_uid(&uid);
	    if ( length - used > 0 ) {
		data = malloc(length - used);
		memcpy(data, file_buf+used, length-used);
		free(file_buf);
		file_buf = data;
		length -= used;
		more_to_do = 1;
	    }
	    else
		more_to_do = 0;
	    break;
	}
	case CTB_CERT_SECKEY_TYPE : {
	    PGPseckey_t	*seckey;

	    if ( verbose ) 
		fprintf(stderr, "CTB is secret key package\n");
	    used = get_seckey_from_buffer(file_buf, length, &seckey);
	    if ( used == -1 ) {
		fprintf(stderr, "Error in buffer (no seckey)\n");
		exit(1);
	    }
	    if ( used == 0 ) {
		if ( verbose ) 
		    fprintf(stdout, "No more\n");
		more_to_do = 0;
		break;
	    }
	    print_seckey(verbose, stdout, seckey);
	    free_seckey(seckey);
	    free(seckey);
	    
	    if ( length - used > 0 ) {
		data = malloc(length - used);
		memcpy(data, file_buf+used, length-used);
		free(file_buf);
		file_buf = data;
		length -= used;
		more_to_do = 1;
	    }
	    break;
	}
	case CTB_COMPRESSED_TYPE:
	    if ( verbose ) 
		fprintf(stdout, "CTB is Compressed Data Packet\n");
	    i = decompress_buffer(file_buf, length, &j, &data);
	    if ( i != 0 ) {
		fprintf(stderr, "Didn't decompress properly\n");
		exit(1);
	    }
	    free(file_buf);
	    file_buf = data;
	    length = j;

	    break;

	case CTB_LITERAL_TYPE:
	    fprintf(stderr, "Ha, Ha\n");
	    exit(1);
	case CTB_LITERAL2_TYPE:
	    fprintf(stderr, "CTB is Raw Literal plaintext data, with filename and mode\n");
	    
	    i = parse_literal_buffer(file_buf, length, &literal);
	    if ( i != 0 ) {
		fprintf(stderr, "Didn't find literal\n");
		exit(1);
	    }
	    /* create the file */
	    errno = 0;
	    fd = open(literal.filename, O_WRONLY|O_CREAT|O_EXCL, 0600);
	    if ( fd < 0 ) {
		perror(literal.filename);
		exit(1);
	    }
	    write(fd, literal.data, literal.datalen);
	    close(fd);
	    more_to_do = 0;
	    break;

	case CTB_CKE_TYPE: 
	    if (verbose )
		fprintf(stderr, 
			"CTB is type Conventional-key-encrypted data\n"); 
	    /* Convert the password to a 16-byte key by means of MD5 */
	    MD5_Init(&context);
	    MD5_Update(&context, password, strlen(password));
	    MD5_Final(digest, &context);
	    if ( verbose ) {
		fprintf(stderr, "The MD5 hash of the password is :");
		for (i = 0; i < 16; i++)
		    fprintf(stderr, "%02x", digest[i]);
		fprintf(stderr, "\n"); 
	    }
	    length = conventional_key_decrypt(file_buf, digest, &data);
	    if ( length == -1 ) {
		fprintf(stderr, "Returned -1\n");
		exit(-1);
	    }
	    if ( length == 0 ) {
		fprintf(stderr, "Wrong key\n");
		exit(-1);
	    }
	    else {
		free(file_buf);
		file_buf = data;
		more_to_do = 1;
		break;
	    }
	default:
	    fprintf(stderr, "Some strange type (%d)\n",
		    (CTB & CTB_TYPE_MASK) >> 2);
	    exit(1);
	}
	if ( more_to_do ) 
	    fprintf(stderr, "----------------\n");
    }while (more_to_do);
}
