/*  Hey Emacs, switch to -*-C-*-, please 

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.


 */
#include <ctype.h>
#include <stdlib.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <malloc.h>

#include "shell.h"
#include <pgplib.h>
#include <pgp_m.h>

void
scan(int argc, char *argv[])
{

    int		fid;
    char	*p;
    int		armor;
    u_char	*packet;
    int		p_len;
    FILE	*file;

    int		long_keys, short_keys, long_name;

    PGPsig_t	sig;
    PGPpubkey_t	key;
    PGPuserid_t	uid;
    PGPliteral_t literal;
    int		how_much;
    int		have_key;
    u_char	CTB;

    /* scratch */
    int		i;


    if ( argc > 3 || argc < 2) {
	fprintf(stderr, "SCAN file [armor] .  Will scan the file\n");
	return;
    }
    
    armor = 0;
    if ( argc == 3 ) {
	for(p=argv[2]; *p; p++)
	    *p = tolower(*p);
	if ( strcmp(argv[2], "armor")) {
	    fprintf(stderr, "SCAN: arg 3 MUST be \"armor\" (or \"ARMOR\") or nothing (not \"%s\")\n",
		    argv[2]);
	    return;
	}
	else {
	    armor = 1;
	}
    }

    if ( armor ) {

	FILE	*tmp1, *tmp2;
	char	*fname;

	tmp1 = fopen(argv[1], "r");
	if ( tmp1 == NULL ) {
	    fprintf(stderr, "Can't open %s\n", argv[1]);
	    return;
	}
	i = mkstemp("/tmp/temp.XXXXXX");
	tmp2 = fdopen(i, "w+");
	if ( tmp2 == NULL ) {
	    fclose(tmp1);
	    fprintf(stderr, "Error in creating tmp-file\n");
	    return;
	}
	fprintf(stdout, "DeArmoring....\n");
	i = dearmor_file(tmp1, tmp2);
	if ( i != 0 ) {
	    fclose(tmp1);
	    fclose(tmp2);
	    fprintf(stderr, "Could not dearmor file %s\n", argv[1]);
	    return;
	}
	fclose(tmp2);
	fprintf(stdout, "....Done.\n");
	
	fid = open(fname, O_RDONLY);
    }
    else { /* not armored */
	fid = open(argv[1], O_RDONLY);
    }
    if ( fid < 0 ) {
	perror("open");
	return;
    }
    file = fdopen(fid, "r");
    if ( file == NULL ) {
	fprintf(stderr, "Canr fdopen file\n");
	return;
    }

    /* Turn it into a file we can handle */
more:
    i  = fgetc(file);
    if ( i == EOF ) {
	fprintf(stderr, "EOF reached\n");
	fclose(file);
	return;
    }
    CTB = (u_char) i;

    switch ( (CTB & CTB_TYPE_MASK) >> 2) {
    case CTB_SKE_TYPE:
    case CTB_CERT_PUBKEY_TYPE:
    case CTB_KEYCTRL_TYPE:
    case CTB_USERID_TYPE:
    case CTB_COMMENT_TYPE:
	ungetc(CTB, file);
	break;
    case CTB_COMPRESSED_TYPE: {
	/* We have to read from here and until EOF storing the
	 * result in a new file (to get rid of the CTB).
	 * Then we uncompreee and reopen.
	 */
	FILE    *tmp1;

        fprintf(stdout, "File is compressed.  Decompressing....\n");
        tmp1 = tmpfile();
        i = decompress_file(file, tmp1);
        if ( i != 0 ) {
            fprintf(stderr, "Compressed, but it wouldn't decompress\n");
            fclose(tmp1);
            return;
        }
	fprintf(stdout, "...Done\n");
	goto more;
    }
    case CTB_LITERAL_TYPE:
	fprintf(stdout, "File is literal.  Unpacking....\n");
	i = parse_literal_file(file, &literal);
	if ( i == -1 ) {
	    fprintf(stderr, "First package was literal, but would't unpack\n");
	    fclose(file);
	    return;
	}
	fprintf(stdout, "Literal info:\n");
	fprintf(stdout, "\tMode:\t\t%d\n", literal.mode);
	fprintf(stdout, "\tFilename:\t%s\n", literal.filename);
	fprintf(stdout, "\tTimestamp:\t%ld\n", literal.timestamp);
	fprintf(stdout, "\tLength:\t\t%d\n", literal.datalen);

	goto more;
	
    case CTB_CKE_TYPE:
	fprintf(stdout, "Encrypted data.\n");
	fclose(file);
	return;
    default:
	fprintf(stderr, "File contains packet of unknown type\n");
	fclose(file);
	return;
    }
    
    how_much = 0;
    packet = NULL;
    long_keys = short_keys = long_name = 0;
    while ( 1 ) {

	/* malloc_dump(2);*/

	free(packet);
	packet = NULL;
	i = read_packet(file, &p_len, &packet);
	switch( i ) {
	case -1:
	    free(packet);
	    fprintf(stderr, "Some error\n");
	    return;
	case 1:
	    free(packet);
	    if ( feof(file) ) {
		fclose(file);
	    }
	    else
		fprintf(stderr, "Syntax error in the file\n");
	    fprintf(stderr, "Lange=%d korte=%d\n", long_keys, short_keys);
	    fprintf(stderr, "%d har navn > 50 bytes\n", long_name);
	    return;
	case 0:
	    /* We found a package.  We consumed j bytes */
	    how_much += p_len;
	    break;
	default:
	    assert(0);
	}
	
 	CTB = (packet[0] & CTB_TYPE_MASK) >> 2;
    
	switch ( CTB ) {
	    
	case CTB_COMMENT_TYPE:
	case CTB_CKE_TYPE:
	case CTB_COMPRESSED_TYPE:
	    fprintf(stderr, "CTB = %x\n", packet[0]);
	    assert(0);

	case CTB_CERT_SECKEY_TYPE: {
	    u_short	us;
	    
	    memcpy(&us, packet+11, 2);
	    us = ntohs(us);
	    fprintf(stdout, "%d Secret key (length=%d)!! \n", how_much, us);
	    continue;
	}
 	case CTB_KEYCTRL_TYPE:
	    fprintf(stdout, "%d Key Control Packet\n", how_much);
	    continue;
	case CTB_CERT_PUBKEY_TYPE:
	    have_key = 1;
	    i = buf2pubkey(packet, p_len, &key);
	    fprintf(stdout, "%d Key: %#.16llx\n", how_much, 
		    BN_get_keyid(key.N));
	    free_pubkey(&key);
	    continue;
 	case CTB_USERID_TYPE:
	    i = buf2userid(packet, p_len, &uid);
	    fprintf(stdout, "%d UserID: %s\n", how_much, uid.name);
	    if ( strlen(uid.name) > 50)
		long_name += 1;
	    free_uid(&uid);
	    continue;

	case CTB_SKE_TYPE: {
	    /* a local variable */
	    PGPuserid_t	**uidp;
	    
	    (void)buf2signature(packet, p_len, &sig);
	    fprintf(stdout, "%d Signature KeyID:\t%#.16llx\n", 
		    how_much, sig.key_id);
	    i = find_uids_with_key(sig.key_id, &uidp);
	    if ( i == 1 || i == -1 )
		fprintf(stdout, "\tUnknown\n");
	    else {
		for(i = 0; uidp[i] != 0; i++) {
		    fprintf(stdout, "\t%s\n", uidp[i]->name);
		    free_uid(uidp[i]);
		}
		free(uidp);
	    }
	    (void) free_signature(&sig);
	    continue;
	}
	default:
	    fprintf(stderr, "%d Unknown CTB=%d\n", how_much, CTB);
	    assert(0);
	}
    } /* while */
    
    return;
}

