package Ssh::TkSsh;

use Tk;
use Tk::Dialog;
use Tk::DialogBox;
use Tk::LabEntry;
use Ssh;

@ISA= qw(Ssh);


sub new {
    my ($proto,$top,@args) = @_;
    my $class = ref($proto) || $proto;
    my $self = {};
    bless ($self, $class);
    $self->SUPER::initialize();
    $self->initialize($top,@args);
    return $self;
}

sub initialize {
    my ($self,$top,@args) = @_;

    $self->{"-printsub"} = \&defaultprintsub;
    $self->{"-yesnodialog"} = \&defaultyes_no_dialog;
    $self->{"-inputdialog"} = \&defaultinput_dialog;
    $self->{"-passworddialog"} = \&defaultpassword_dialog;
    $self->{"-topwindow"} = $top;
    my $i;
    my $totalargs = @args;
    for($i=0;$i<$totalargs-1;$i+=2) {
	my $key = $args[$i];
	my $value = $args[$i+1];
	$self->{$key} = $value;
    }
}

sub defaultprintsub {
    my $self = shift;

    my $message = shift;
    my $top = $self->{"-topwindow"};
    my $ret = $top->Dialog( -title => "Message",
			   -text => $message
			   );
    $result = $ret->Show;
    return $result;
}


sub defaultinput_dialog {
    my $self = shift;

    my $message = shift;
    my $top = $self->{"-topwindow"};
    my $value = "";
    my $ret = $top->DialogBox( -title => "Input Required",
			      -buttons => ["OK", "Cancel"]
			      );
    $label = $ret->add(LabEntry, 
		       -label => $message,
		       -labelPack => [-side => "left", -anchor => "w"], 
		       -textvariable => \$value)->pack(
						       -side => 'top', 
						       -expand =>0,
						       -fill => 'x');
    $result = $ret->Show;
    if ($result eq 'OK') {
	my $value = $label->get();
	return $value;
    }
    return 0;
}
    
sub defaultpassword_dialog {
    my $self = shift;

    my $message = shift;
    my $top = $self->{"-topwindow"};
    my $value = "";
    my $ret = $top->DialogBox( -title => "Input Required",
			      -buttons => ["OK", "Cancel"]
			      );
    $label = $ret->add(LabEntry, 
		       -label => $message,
		       -labelPack => [-side => "left", -anchor => "w"], 
		       -show => '*',
		       -textvariable => \$value)->pack(
						       -side => 'top', 
						       -expand =>0,
						       -fill => 'x');
    $result = $ret->Show;
    if ($result eq 'OK') {
	my $value = $label->get();
	return $value;
    }
    return 0;
}

sub defaultyes_no_dialog {
    my ($self,$text) = @_;

    my $top = $self->{"-topwindow"};
    my ($yes, $no) = ('yes', 'no');
    my $ret = $top->Dialog(
			   -title => "Question",
			   -text => $text,
			   -default_button => $yes,
			   -buttons => [$yes, $no],
			   );
    my $result = $ret->Show;
    return $result;
}

sub topwindow {
    my $self = shift;

    return $self->{"-topwindow"};
}
1;
