package Ssh::Tunnel;

use Ssh;
use Carp;

@ISA=qw(Ssh);

my $Debugging = 0;
my $Verbose = 0;

use strict;

sub new {
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $self = {};
    bless ($self, $class);
    $self->SUPER::initialize();
    $self->initialize(@_);
    return $self;
}

sub initialize {
    my ($self,@args) = @_;

    my $i;
    my $totalargs = @args;
    for($i=0;$i<$totalargs-1;$i+=2) {
	my $key = $args[$i];
	my $value = $args[$i+1];
	$self->{$key} = $value;
    }
}

sub check_or_generate_tunnel_key {
    my ($self,$filename,$prefix,$comment) = @_;

    my $path = $prefix . '/' .  $filename;
    my $pubpath = $path . '.pub';
    return (1,"Key file $path already exists.") if (-e $path);
    return (2,"Public key file $pubpath already exists.") if (-e $pubpath);

    if (($Verbose > 1) || ($self->{"_VERBOSE"} > 1)) {
	$self->printsub("cat /dev/null | ssh-keygen -f $path -N \"\" -C \"$comment\"\n");
    }
    my $ok = `cat /dev/null | ssh-keygen -f $path -N \"\" -C \"$comment\"`;
    return $ok;
}

sub check_or_add_key_to_authorized_keys {
    my ($self,@args) = @_;

    my $i;
    my $totalargs = @args;
    my %args;
    for($i=0;$i<$totalargs-1;$i+=2) {
	my $key = $args[$i];
	my $value = $args[$i+1];
	$args{$key} = $value;
    }
    my $keyfile = $args{'-keyfile'} || $self->{'-keyfile'} || return (-1,"No Private Key File specified!");
    my $pubkeyfile = $args{'-pubkeyfile'} || $self->{'-pubkeyfile'} || return (-1,"No Public Key File specified!");
    my $keydir = $VPS::keydir;
    my $filename = $args{'-name'} || $self->{'-name'};
    my $remoteuser = $args{'-remoteuser'} || $self->{'-remoteuser'} || return (-1,"No Remote User specified!");
    my $remotesystem = $args{'-gateway'} || $self->{'-gateway'} || return (-1,"No Gateway specified!");
    if ($Verbose || $self->{"_VERBOSE"}) {
	$self->printsub("Copying authorized key to remote system\n");
    }
    open (FILE,"$pubkeyfile") or return (-1,"Can't open $pubkeyfile, $!");
    my $key = <FILE>;
    chop $key;
    close(FILE);
    open (NEWSCRIPT,">$filename.$$") or return (-1, "Can't open $filename.$$ script!");

    print NEWSCRIPT <<_EOM_;
#!/bin/sh

#DO NOT EDIT!
#This is an automatically generated script.
touch ~/.ssh/authorized_keys
if grep -q "$key" ~/.ssh/authorized_keys
then
echo "The key is already authorized."
rm -f ~/.ssh/$filename.$$
exit 1
else
echo "$key" >> ~/.ssh/authorized_keys
echo "Authorized key added!"
fi

rm -f ~/.ssh/$filename.$$

_EOM_

    close (NEWSCRIPT);
    $self->remoteuser($remoteuser);
    $self->remotehost($remotesystem);
    $self->debug(2);
    my ($error, $ret) = $self->secure_copy(-filename => "$filename.$$",
					   -remotepath => "./.ssh/${filename}.$$");
    unlink("${filename}.$$");
    return (-1, "check_or_add_key_to_authorized_keys failed during secure_copy, $ret") if ($error ne "2:EOF");
    if ($Verbose || $self->{"_VERBOSE"}) {    
	$self->printsub("Installing authorized key in remote system\n");
    }
    my @expectstring = ("Authorized key added","The key is already authorized");
    my ($error2, $retval) = $self->secure_shell(-remotecommand => "sh ./.ssh/$filename.$$",
						-expectstring => \@expectstring);
    if ($retval eq "Authorized key added") {
	if ($Verbose || $self->{"_VERBOSE"}) {
	    $self->printsub("Authorized key added!");
	}
	return (0, "Authorized key added!");
    }
    elsif ($retval eq "The key is already authorized") {
	if ($Verbose || $self->{"_VERBOSE"}) {
	    $self->printsub("Key already authorized.");
	}
	return (1,"Key already authorized.");	
    }
    else {
	return (-1,"check_or_add_key_to_authorized_keys failed during secure_shell, $retval");
    }
    return (-1, "Add_key_to_authorized_keys failed after secure_shell, $error") if ($error2 ne "2:EOF");
    return 0;
}

sub check_or_add_tunnel_routes {
    my ($self,@args) = @_;
    
    my $i;
    my $totalargs = @args;
    my %args;
    for($i=0;$i<$totalargs-1;$i+=2) {
	my $key = $args[$i];
	my $value = $args[$i+1];
	$args{$key} = $value;
    }
    my $keyfile = $args{'-keyfile'} || $self->{'-keyfile'} || return (-1,"No Key File specified!");
    my $pubkeyfile = $args{'-pubkeyfile'} || $self->{'-pubkeyfile'} || return (-1,"No Public Key File specified!");
    my $name = $args{'-name'} || $self->{'-name'} || return (-1,"No Filename specified!");
    my $localip = $args{'-local'} || $self->{'-local'} or return (-1,"No Local IP address specified");
    my $remoteip = $args{'-remote'} || $self->{'-remote'} or return (-1,"No Remote IP address specified");
    my $remoteuser = $args{'-remoteuser'} || $self->{'-remoteuser'} || return (-1,"No Remote User specified!");
    my $remotesystem = $args{'-gateway'} || $self->{'-gateway'} || return (-1,"No Gateway specified!");
    my $localroutes = $args{'-localroute'} || $self->{'-localroute'};
    my $remoteroutes = $args{'-remoteroute'} || $self->{'-remoteroute'};
    if ($Verbose || $self->{"_VERBOSE"}) {    
	$self->printsub("Checking and installing routes in local system\n");
    }
    open (LOCALSCRIPT,">./localroutetest.$$") or return (-1,"Can't open localroutetest.$$");
    print LOCALSCRIPT <<_EOM_;
#!/bin/sh
touch /etc/ppp/ip-up
if grep -q "sh /etc/ppp/ip-up-$name" /etc/ppp/ip-up
then
echo 
else
cp /etc/ppp/ip-up /etc/ppp/ip-up.orig
echo "sh /etc/ppp/ip-up-$name \\\$*" >> /etc/ppp/ip-up
fi
echo "#!/bin/sh" > /etc/ppp/ip-up-$name
_EOM_
    if (defined($localroutes)) {
	my $numroutes = @$localroutes;
	print LOCALSCRIPT <<_EOM_;
echo "if [ \\\$5 = \\\"$remoteip\\\" ]" >> /etc/ppp/ip-up-$name
echo "then" >> /etc/ppp/ip-up-$name
_EOM_
        my $i;
	for ($i=0;$i<$numroutes;$i++) {
	    my ($network,$netmask) = split(' ', $$localroutes[$i]);
	    print LOCALSCRIPT <<_EOM_;
echo "    /sbin/route add -net $network netmask $netmask \\\$1" >> /etc/ppp/ip-up-$name
_EOM_
        }
	print LOCALSCRIPT <<_EOM_;
echo "fi" >> /etc/ppp/ip-up-$name
_EOM_
    }
    else {
	print LOCALSCRIPT <<_EOM_;
echo "# No routes to add." >> /etc/ppp/ip-up-$name
_EOM_
    }
    print LOCALSCRIPT <<_EOM_;
echo "Local Routes installed."
rm -f ./localroutetest.$$
_EOM_
    close (LOCALSCRIPT);
    system("sh ./localroutetest.$$");
	
    open (ROUTESCRIPT,">./remoteroutetest.$$") or return (-1,"Can't open remoteroutetest.$$");
    print ROUTESCRIPT <<_EOM_;
#!/bin/sh
if grep -q "sh /etc/ppp/ip-up-$name" /etc/ppp/ip-up
then
echo 
else
cp /etc/ppp/ip-up /etc/ppp/ip-up.orig
echo "sh /etc/ppp/ip-up-$name \\\$*" >> /etc/ppp/ip-up
fi
echo "#!/bin/sh" > /etc/ppp/ip-up-$name
_EOM_

    if (defined($remoteroutes)) {
	my $numroutes = @$remoteroutes;
	print ROUTESCRIPT <<_EOM_;
echo "if [ \\\$5 = \\\"$localip\\\" ]" >> /etc/ppp/ip-up-$name
echo "then" >> /etc/ppp/ip-up-$name
_EOM_
        my $i;
	for ($i=0;$i<$numroutes;$i++) {
	    my ($network,$netmask) = split(' ', $$remoteroutes[$i]);
	    print ROUTESCRIPT <<_EOM_;
echo "    /sbin/route add -net $network netmask $netmask \\\$1" >> /etc/ppp/ip-up-$name
_EOM_
        }
	print ROUTESCRIPT <<_EOM_;
echo "fi" >> /etc/ppp/ip-up-$name
_EOM_
    }
    else {
	print ROUTESCRIPT <<_EOM_;
echo "# No routes to add." >> /etc/ppp/ip-up-$name
_EOM_
    }
    print ROUTESCRIPT <<_EOM_;
echo "Remote Routes installed."
rm -f ./remoteroutetest.$$
_EOM_
    close (ROUTESCRIPT);
    my ($error, $ret) = $self->secure_copy(-filename => "./remoteroutetest.$$",
					   -remotepath => "/etc/ppp/remoteroutetest.$$");
    unlink("./remoteroutetest.$$");
    return (-1, "check_or_add_tunnel_routes failed during secure_copy, $ret") if ($error ne "2:EOF");
    if ($Verbose || $self->{"_VERBOSE"}) {    
	$self->printsub("Checking and installing routes in remote system\n");
    }
    my @expectstring = ("Remote Routes installed","The routes already exist");
    my ($error2, $retval) = $self->secure_shell(-remotecommand => "sh /etc/ppp/remoteroutetest.$$",
						-expectstring => \@expectstring);
    if ($retval eq "Remote Routes installed") {
	if ($Verbose || $self->{"_VERBOSE"}) {
	    $self->printsub("Remote Routes installed!");
	}
	return (0, "Remote Routes installed!");
    }
    elsif ($retval eq "The routes already exist") {
	if ($Verbose || $self->{"_VERBOSE"}) {
	    $self->printsub("The routes already exist.");
	}
	return (1,"The routes already exist.");	
    }
    else {
	return (-1,"check_or_add_tunnel_routes failed during secure_shell, $retval");
    }
    return (-1, "check_or_add_tunnel_routes failed after secure_shell, $error") if ($error2 ne "2:EOF");
    return 0;
    
}    
    
sub bring_up_tunnel {
    my ($self,@args) = @_;

    my $i;
    my $totalargs = @args;
    my %args;
    for($i=0;$i<$totalargs-1;$i+=2) {
	my $key = $args[$i];
	my $value = $args[$i+1];
	$args{$key} = $value;
    }
    my $localip = $args{'-local'} || $self->{'-local'} or return (-1,"No Local IP address specified");
    my $remoteip = $args{'-remote'} || $self->{'-remote'} or return (-1,"No Remote IP address specified");
    my $remotehost = $args{'-gateway'} || $args{'-remotesystem'} || $self->{'-gateway'} || $self->{'-remotesystem'} or return (-1,"No Gateway specified!");

    if ($> != 0) {
	return (-1,"You must be root to start a tunnel.");
    }
    open(NETSTAT1,"netstat -rn |") or return (-1,"Could not run netstat.  Please check the documentation for details.");
    while (<NETSTAT1>) {
	if (/$remoteip/) {
	    close(NETSTAT1);
	    if ($Verbose || $self->{"_VERBOSE"}) {
		$self->printsub("Tunnel to $remoteip through $remotehost is already up.");
	    }
	    return(1,"Tunnel to $remoteip through $remotehost is already up.");
	}
    }
    close(NETSTAT1);
    open(NETSTAT2,"netstat -r |") or return (-1,"Could not run netstat.  Please check the documentation for details.");
    while (<NETSTAT2>) {
	if (/$remoteip/) {
	    close(NETSTAT2);
	    if ($Verbose || $self->{"_VERBOSE"}) {
		$self->printsub("Tunnel to $remoteip through $remotehost is already up.");
	    }
	    return(1,"Tunnel to $remoteip through $remotehost is already up.");
	}
    }
    close(NETSTAT2);
    $self->printsub("Starting Tunnel to $remotehost\n");
    my $timer;
    for ($timer=15;$timer<61;$timer+=15) {
	if (($Verbose>1) || ($self->{"_VERBOSE"}>1)) {
	    $self->printsub("Running start_tunnel...");
	}
	$self->ssh_ppp($localip,$remoteip,$timer);
	if ($Verbose || $self->{"_VERBOSE"}) {
	    $self->printsub("Checking Routes...\n");
	}
	my $i;
	for ($i=0;$i<3;$i++) {
	    open(NETSTAT1,"netstat -rn |") or return (-1,"Could not run netstat.  Please check the documentation for details.");
	    while (<NETSTAT1>) {
		if (/$remoteip/) {
		    close(NETSTAT1);
		    if ($Verbose || $self->{"_VERBOSE"}) {
			$self->printsub("Tunnel to $remoteip is up.");
		    }
		    return(0,"Tunnel to $remoteip is up.");
		}
	    }
	    close(NETSTAT1);
	    sleep 2;
	}
    }
    if ($Verbose || $self->{"_VERBOSE"}) {
	$self->printsub("Cound not create tunnel to $remoteip.  Please check your configuration and try again.");
    }
    return(-1,"Cound not create tunnel to $remoteip.  Please check your configuration and try again.");
}


1;
