# Sample SpecTcl main program for testing GUI

package VPS::mainWindow;

use strict;
use VPS;
use VPS::simpleAlert;
use VPS::tunnelBuilder;
use VPS::keyManager;

use Tk;
use Tk::Menu;
use Tk::DialogBox;

use Exporter;

@VPS::mainWindow::ISA = qw(Exporter);
@VPS::mainWindow::EXPORT    = qw(main_ui);

# interface generated by SpecTcl (Perl enabled) version 1.1 
# from main.ui
# For use with Tk402.002, using the grid geometry manager

local $VPS::mainWindow::root;
my $currentDir;

my $labelMessageArea;

my $butTunnelName;
my $butDestination;
my $butNetmask;
my $butStatus;
local $VPS::mainWindow::lbTunnel;

sub main_ui {
    my ($dataref,$message) = @_;

    $VPS::mainWindow::root = MainWindow->new();
    $VPS::mainWindow::root->title("VPS $main::VPSversion Administrator - Main");
    
    # widget creation 
    
    my($frame_3) = $VPS::mainWindow::root->Frame (
				 );
    my($frame_1) = $VPS::mainWindow::root->Frame (
				 -borderwidth => '1',
				 );
    my($mbFile) = $VPS::mainWindow::root->Menubutton (
				     -text => 'File',
				     -tearoff => 'n',
				     );
    my($mbEdit) = $VPS::mainWindow::root->Menubutton (
				     -text => 'Edit',
				     -tearoff => 'n',
				     );
    my($mbConfigure) = $VPS::mainWindow::root->Menubutton (
					  -text => 'Configure',
					  -tearoff => 'n',
					  );
    my($mbHelp) = $VPS::mainWindow::root->Menubutton (
				     -text => 'Help',
				     -tearoff => 'n',
				     );
    my $tunnelName = 'Tunnel Name';
    my $localIPAddr = 'Local IP Address';
    my $remoteIPAddr = 'Remote IP Address';    
    my $gateway = 'Gateway';
    my($labelTunnel) = $VPS::mainWindow::root->Label (
				     -anchor => 'sw',
				     -justify => 'left',
				     -font => "-*-Courier-Medium-R-Normal--*-120-*-*-*-*-*-*",
				     -text => buildMainString($tunnelName,$localIPAddr,$remoteIPAddr,$gateway),
				 );
    ($VPS::mainWindow::lbTunnel) = $VPS::mainWindow::root->Scrolled ('Listbox',
				     -scrollbars => 'e',
				     -font => "-*-Courier-Medium-R-Normal--*-120-*-*-*-*-*-*",
				     -height => '0',
				     -width => '0',
				     );
    $labelMessageArea = $VPS::mainWindow::root->Label (
				      -relief => 'sunken',
				      -anchor => 'w',
				      -justify => 'left'
				      );

    # Geometry management

    $frame_3->grid(
		   -in => $VPS::mainWindow::root,
		   -column => '1',
		   -row => '2',
		   -sticky => 'nesw',
		   -padx => 5,
		   -pady => 5,
		   );
    $frame_1->grid(
		   -in => $VPS::mainWindow::root,
		   -column => '1',
		   -row => '1',
		   -sticky => 'nw',
		   );
    $mbFile->grid(
		  -in => $frame_1,
		  -column => '1',
		  -row => '1'
		  );
    $mbEdit->grid(
		  -in => $frame_1,
		  -column => '2',
		  -row => '1'
		  );
    $mbConfigure->grid(
		       -in => $frame_1,
		       -column => '3',
		       -row => '1'
		       );
    $mbHelp->grid(
		  -in => $frame_1,
		  -column => '4',
		  -row => '1'
		  );
    $labelTunnel->grid(
		       -in => $frame_3,
		       -column => '1',
		       -row => '1',
		       -sticky =>'new',
		       );
    $VPS::mainWindow::lbTunnel->grid(
		    -in => $frame_3,
		    -column => '1',
		    -row => '2',
		    -sticky => 'nesw'
		    );

    $labelMessageArea->grid(
			    -in => $VPS::mainWindow::root,
			    -column => '1',
			    -row => '3',
			    -sticky => 'nesw'
			    );
    # Resize behavior management
    
    # container $frame_3 (rows)
    $frame_3->gridRowconfigure(1, -weight  => 0, -minsize  => 30);
    $frame_3->gridRowconfigure(2, -weight  => 1, -minsize  => 250);
    
    # container $frame_3 (columns)
    $frame_3->gridColumnconfigure(1, -weight => 1, -minsize => 30);
    
    # container $VPS::mainWindow::root (rows)
    $VPS::mainWindow::root->gridRowconfigure(1, -weight  => 0, -minsize  => 30);
    $VPS::mainWindow::root->gridRowconfigure(2, -weight  => 1, -minsize  => 250);
    $VPS::mainWindow::root->gridRowconfigure(3, -weight  => 0, -minsize  => 30);
    
    # container $VPS::mainWindow::root (columns)
    $VPS::mainWindow::root->gridColumnconfigure(1, -weight => 1, -minsize => 30);
    
    # container $frame_1 (rows)
    $frame_1->gridRowconfigure(1, -weight  => 0, -minsize  => 30);
    
    # container $frame_1 (columns)
    $frame_1->gridColumnconfigure(1, -weight => 0, -minsize => 44);
    $frame_1->gridColumnconfigure(2, -weight => 0, -minsize => 30);
    $frame_1->gridColumnconfigure(3, -weight => 0, -minsize => 30);
    $frame_1->gridColumnconfigure(4, -weight => 0, -minsize => 18);
    
    # additional interface code
    
    my $fileExitCommand = \&fileExitCommand;
    my $fileNewCommand = \&fileNewCommand;
    my $fileOpenCommand = \&fileOpenCommand;
    my $fileSaveCommand = \&fileSaveCommand;
    my $fileSaveAsCommand = \&fileSaveAsCommand;
    my $fileCloseCommand = \&fileCloseCommand;
    my $editUndoCommand = \&editUndoCommand;
    my $editCutCommand = \&editCutCommand;
    my $editCopyCommand = \&editCopyCommand;
    my $editPasteCommand = \&editPasteCommand;
    my $helpAboutCommand = \&helpAboutCommand;
    $mbFile->command(-label => 'New', -underline => 0,
		     -command => $fileNewCommand,
		     -accelerator => 'C-n');
    $VPS::mainWindow::root->bind('<Control-Key-n>' => $fileNewCommand);
    $mbFile->command(-label => 'Open', -underline => 0,
		     -command => $fileOpenCommand,
		     -accelerator => 'C-o');
    $VPS::mainWindow::root->bind('<Control-Key-o>' => $fileOpenCommand);
    $mbFile->command(-label => 'Save', -underline => 0,
		     -command => $fileSaveCommand,
		     -accelerator => 'C-s');
    $VPS::mainWindow::root->bind('<Control-Key-s>' => $fileSaveCommand);
    $mbFile->command(-label => 'Save As...', -underline => 0,
		     -command => $fileSaveAsCommand,
		     -accelerator => 'C-a');
    $VPS::mainWindow::root->bind('<Control-Key-a>' => $fileSaveAsCommand);
    $mbFile->command(-label => 'Close', -underline => 0,
		     -command => $fileCloseCommand,
		     -accelerator => 'C-w');
    $VPS::mainWindow::root->bind('<Control-Key-w>' => $fileCloseCommand);
    $mbFile->separator;
    $mbFile->command(-label => 'Exit', -underline => 0,
		     -command => $fileExitCommand,
		     -accelerator => 'C-x');
    $VPS::mainWindow::root->bind('<Control-Key-x>' => $fileExitCommand);
    $VPS::mainWindow::root->protocol("WM_DELETE_WINDOW" => $fileExitCommand);
    
    
    $mbEdit->command(-label => 'Undo', -underline => 0,
		     -command => $editUndoCommand,
		     -accelerator => 'C-z');
    $VPS::mainWindow::root->bind('<Control-Key-z>' => $editUndoCommand);
    $mbEdit->command(-label => 'Cut', -underline => 0,
		     -command => $editCutCommand,
		     -accelerator => 'C-x');
    $VPS::mainWindow::root->bind('<Control-Key-x>' => $editCutCommand);
    $mbEdit->command(-label => 'Copy', -underline => 0,
		     -command => $editCopyCommand,
		     -accelerator => 'C-c');
    $VPS::mainWindow::root->bind('<Control-Key-c>' => $editCopyCommand);
    $mbEdit->command(-label => 'Paste', -underline => 0,
		     -command => $editPasteCommand,
		     -accelerator => 'C-v');
    $VPS::mainWindow::root->bind('<Control-Key-v>' => $editPasteCommand);
    $mbConfigure->command(-label => 'New Tunnel', -underline => 0,
			  -command => [\&newTunnelCommand,$VPS::mainWindow::lbTunnel],
			  -accelerator => 'C-t');
    $VPS::mainWindow::root->bind('<Control-Key-t>' => [\&newTunnelCommand,$VPS::mainWindow::lbTunnel]);
    $mbConfigure->command(-label => 'Modify Tunnel', -underline => 0,
			  -command => [\&modifyTunnelCommand,$VPS::mainWindow::lbTunnel],
			  -accelerator => 'C-m');
    $VPS::mainWindow::root->bind('<Control-Key-m>' => [\&modifyTunnelCommand,$VPS::mainWindow::lbTunnel]);
    $VPS::mainWindow::lbTunnel->bind('<Double-1>' => [\&modifyTunnelCommand,$VPS::mainWindow::lbTunnel]);
    $mbConfigure->command(-label => 'Delete Tunnel', -underline => 0,
			  -command => [\&deleteTunnelCommand,$VPS::mainWindow::lbTunnel],
			  -accelerator => 'C-d');
    $VPS::mainWindow::root->bind('<Control-Key-d>' => [\&deleteTunnelCommand,$VPS::mainWindow::lbTunnel]);
    $mbConfigure->command(-label => 'Manage Tunnels...', -underline => 0,
			  -command => \&key_ui,
			  -accelerator => 'C-k');
    $VPS::mainWindow::root->bind('<Control-Key-d>' => [\&deleteTunnelCommand,$VPS::mainWindow::lbTunnel]);
    $mbHelp->command(-label => 'About Tunnel Manager', -underline => 0,
		     -command => $helpAboutCommand);
    
    if ((defined($$dataref[0])) && $$dataref[0]{'tunnelName'}) {
	my $index = $#$dataref;
	my $i;
	for ($i=0;$i<=$index;$i++) {
	    my $string = buildMainString($$dataref[$i]{'tunnelName'},$$dataref[$i]{'tunnelLocalAddr'},$$dataref[$i]{'tunnelRemoteAddr'},$$dataref[$i]{'tunnelGatewayAddr'});
	    $VPS::mainWindow::lbTunnel->insert("end",$string);
	}
    }
    message($message);
    # end additional interface code
}

sub fileNewCommand {
    if ((windowOpen("key_ui")) || (windowOpen("fileSaveWindow")) || (windowOpen('tunnelBuilder')) || (windowOpen('route_ui')) || (windowOpen('simpleAlert'))) {
	message("Function currently inaccessable.");
	return (1,\@VPS::data);
    }
    
    if (&fileDirty) {
	if (simpleAlert($VPS::mainWindow::root, "You have unsaved changes to " . &currentlyOpenFilename . ". Save now?")) {
	    &fileSaveCommand; 
	    &fileCloseCommand;
	}
    }
    $currentDir = &getCurrentDir;
    my $file = &currentlyOpenFilename;
    
    if (defined($VPS::mainWindow::lbTunnel)) {
	my $index = $VPS::mainWindow::lbTunnel->index("end");
	my $i;
	for ($i=0;$i<$index;$i++) {
	    $VPS::mainWindow::lbTunnel->delete(0);
	    undef($VPS::data[$i]);
	}
    }
    $VPS::keydir = $VPS::defaultkeydir;
    return(0,\@VPS::data);
}

sub fileOpenCommand {
    if ((windowOpen("key_ui")) || (windowOpen("fileSaveWindow")) || (windowOpen('tunnelBuilder')) || (windowOpen('route_ui')) || (windowOpen('simpleAlert'))) {
	message("Function currently inaccessable.");
	return (1,\@VPS::data);
    }
    $currentDir = &getCurrentDir;
    openWindow("fileSaveWindow");
    my $file = $VPS::mainWindow::root->getOpenFile(-initialdir => $currentDir);
    $file = saveCurrentDir($file);
    closeWindow("fileSaveWindow");
    print "$currentDir\n";
    my ($error,$dataref) = &parseConfigFile($file);
    message($error) if ($file);
    if ($$dataref[0]{'tunnelName'}) {
	my $index = $#$dataref;
	my $i;
	for ($i=0;$i<=$index;$i++) {
	    my $string = buildMainString($$dataref[$i]{'tunnelName'},$$dataref[$i]{'tunnelLocalAddr'},$$dataref[$i]{'tunnelRemoteAddr'},$$dataref[$i]{'tunnelGatewayAddr'});
	    $VPS::mainWindow::lbTunnel->insert("end",$string);
	}
    }
    return ($error,$dataref);
}

sub fileSaveCommand {

    if ((windowOpen("key_ui")) || (windowOpen("fileSaveWindow")) || (windowOpen('tunnelBuilder')) || (windowOpen('route_ui')) || (windowOpen('simpleAlert'))) {
	message("Function currently inaccessable.");
	return (1,\@VPS::data);
    }
    print "CAF: " . &currentlyOpenFile;
    if (&currentlyOpenFile()) {
	message(&saveConfigFile(&currentlyOpenFile,$VPS::globalrefdata));
    }
    else {
	$currentDir = &getCurrentDir;
	openWindow("fileSaveWindow");
	my $winFileSelect = $VPS::mainWindow::root->getSaveFile(-initialdir => $currentDir);
	my $file = $winFileSelect->Show;
	$file = saveCurrentDir($file);
	closeWindow("fileSaveWindow");
	my $ref = \@VPS::data;
	message(&saveConfigFile($file,$VPS::globalrefdata)) if ($file);
    }
}

sub fileSaveAsCommand {
    if ((windowOpen("key_ui")) || (windowOpen('fileSaveWindow')) || (windowOpen('tunnelBuilder')) || (windowOpen('route_ui')) || (windowOpen('simpleAlert'))) {
	message("Function currently inaccessable.");
	return (1,\@VPS::data);
    }
    $currentDir = &getCurrentDir;
    openWindow("fileSaveWindow");
    my $winFileSelect = $VPS::mainWindow::root->getSaveFile(-initialdir => $currentDir);
    my $file = $winFileSelect->Show;
    $file = saveCurrentDir($file);
    closeWindow("fileSaveWindow");
    my $ref = \@VPS::data;
    message(&saveConfigFile($file,$VPS::globalrefdata)) if ($file);
}

sub fileCloseCommand {

    if ((windowOpen("key_ui")) || (windowOpen("fileSaveWindow")) || (windowOpen('tunnelBuilder')) || (windowOpen('route_ui')) || (windowOpen('simpleAlert'))) {
	message("Function currently inaccessable.");
	return (1,\@VPS::data);
    }
    &fileNewCommand;
}

sub fileExitCommand {
    if ((windowOpen("key_ui")) || (windowOpen("fileSaveWindow")) || (windowOpen('tunnelBuilder')) || (windowOpen('route_ui')) || (windowOpen('simpleAlert'))) {
	message("Function currently inaccessable.");
	return (1,\@VPS::data);
    }
    if (&fileDirty) {
	if (&currentlyOpenFile) {
	    if (simpleAlert($VPS::mainWindow::root, "You have unsaved changes to " . &currentlyOpenFilename . ". Save now?")) {
		&fileSaveCommand; 
	    }
	}
    }
    if (simpleAlert($VPS::mainWindow::root,"Do you really want to quit?")) {
	exit;
    }
}

sub displayMessage {
    my ($msg) = @_;

    $labelMessageArea->configure (text => $msg);
}

sub editUndoCommand {}
sub editCutCommand {}
sub editCopyCommand {}
sub editPasteCommand {}
sub helpAboutCommand {}

1;
