/*
 * stats.c        1.1 4/30/95
 *
 *      (c) Copyright 1995 by Lance Cottrell. All right reserved.
 *      The author assumes no liability for damages resulting from the
 *      use of this software, even if the damage results from defects in
 *      this software. No warranty is expressed or implied.
 *
 *      This software is being distributed under the GNU Public Licence,
 *      see the file GNU.license for more details.
 *
 *	This software is slightly modified from Matt Ghio's "stats.c"
 *	distributed as part of his anonymous remailer.
 *
 *                      - Lance Cottrell (loki@obscura.com) 4/23/95
 *
 */

#include <stdio.h>
#include <time.h>
#include "crypt.h"
#include "mixmaster.h"

#ifndef LOCK_SH
#define LOCK_SH 1    /* shared lock */
#define LOCK_EX 2    /* exclusive lock */
#define LOCK_NB 4    /* don't block when locking */
#define LOCK_UN 8    /* unlock */
#endif


void stats(int flag, char *address)
{

  int m[24];
  int ccm;
  int p[24];
  int ccpgp;
  int l[24];
  int ccl;
  char month[24][5];
  int date[24];
  int hour;
  int currenthour;
  FILE *datafile,*pp,*statlock;
  int x;
  int y;
  char	line[256];

  struct tm *curtime;
  time_t now;

  now = time(NULL);
  curtime = localtime(&now);

  mix_lock("stats",&statlock);
  if((datafile=open_mix_file(STATS,"r"))==NULL) {
    mix_unlock("stats",statlock);
    return;
  }

  fscanf(datafile,"%d",&hour);
  fscanf(datafile,"%d %d %d",&ccm,&ccpgp,&ccl);
  for(x=0;x<24;x++) {
    fscanf(datafile,"%s %d %d %d %d",month[x],&date[x],&m[x],&p[x],&l[x]); }

  fclose(datafile);
  mix_unlock("stats",statlock);

  currenthour=curtime->tm_hour;

  x=hour;
  while (x!=currenthour) {
    if (x>0) {
      strcpy(month[x],month[x-1]);
      date[x]=date[x-1];
    }else{
      strftime(month[0],5,"%b",curtime);
      date[0] = curtime->tm_mday;
    }
    m[x]=0;
    p[x]=0;
    l[x]=0;
    x++;if (x>23) x=0;
  }

  if (hour!=currenthour) {
    m[hour]=ccm;
    p[hour]=ccpgp;
    l[hour]=ccl;
    ccm=0;
    ccpgp=0;
    ccl=0;
  }

  if (flag & FL_MESSAGE) ccm++;
  if (flag & FL_OLD) ccpgp++;
  if (flag & FL_NEW) ccl++;

  mix_lock("stats",&statlock);
  if((datafile=open_mix_file(STATS,"w"))==NULL) {
    mix_unlock("stats",statlock);
    return;
  }
  flock(fileno(datafile),LOCK_EX);

  fprintf(datafile,"%d\n",currenthour);
  fprintf(datafile,"%d %d %d\n",ccm,ccpgp,ccl);
  for(x=0;x<24;x++) {
    fprintf(datafile,"%s %d %d %d %d\n",month[x],date[x],m[x],p[x],l[x]);
  }

  flock(fileno(datafile),LOCK_UN);
  fclose(datafile);
  mix_unlock("stats",statlock);

  if (flag & FL_STATS) {
    strcpy(line,SENDMAIL);
    strcat(line,address);
    if((pp = popen(line,"w"))==NULL) return;
    fprintf(pp,"From: Remailer-Stats (%s)",REMAILERNAME);
    fprintf(pp," (via automated remailer software)\n");
    fprintf(pp,"Subject: Re: Remailer Statistics\n");
    fprintf(pp,"\n");
    fprintf(pp,"Statistics for last 24 hours from anonymous remailer \n");
    fprintf(pp,"%s\n",REMAILERNAME);
    fprintf(pp,"\n");
    fprintf(pp,"Number of messages per hour from %s %d %d:00 to %s %d %d:59\n",
     month[23],date[23],currenthour,month[0],date[0],(currenthour+23)%24);
    fprintf(pp,"\n");
    /*ccm=0;ccpgp=0;ccl=0;*/
    for(x=0;x<24;x++) {
      fprintf(pp," %2d:00 (%2d) ",x,m[x]);
      if (m[x]>0) {
        y=0;while((y<m[x])&&(y<67)) {
          fprintf(pp,"*");
          y++;
        }
        ccm+=m[x];
        ccpgp+=p[x];
        ccl+=l[x];
      }
      fprintf(pp,"\n");
    }
    fprintf(pp,"\n");
    if(strlen(TYPE1) > 1) {	/* We support type 1 messages */
       fprintf(pp,"Total messages remailed in last 24 hours: %d\n",ccm);
       fprintf(pp,"Number of Mixmaster messages : %d\n",ccl);
       fprintf(pp,"Number of cypherpunk remailer messages: %d\n",ccpgp);
    } else { 	/* Mixmaster only */
       fprintf(pp,"Number of messages remailed in last 24 hours: %d\n",ccm);
    }
    fprintf(pp,"Current message reordering pool size: %d\n",POOLSIZE);
    pclose(pp);
  }
}
