/*
 * Error Handeling routines
 *
 * The functions in this file are independant of any application
 * variables, and may be used with any C program
 * Either of the names CLIENT or SERVER may be defined when compileing
 * this function. If neither are defined, we assume CLINET.
 */

#include	<stdio.h>
#include	<varargs.h>

/* #include	"systype.h" */ /* Define needed defs by hand here */
#define BSD 1

#ifdef	CLIENT
#ifdef	SERVER
cant define both CLIENT and SERVER
#endif
#endif

#ifndef	CLIENT
#ifndef	SERVER
#define CLIENT	1	/* default to CLIENT */
#endif
#endif

#ifndef NULL
#define	NULL	((void *) 0)
#endif

char	*pname = NULL;

#ifdef	CLIENT

/*
 * Fatel error. Print a message and terminate.
 * Don't dump core and don't print the system's errno value.
 *
 *	err_quit(str, arg1, arg2, ...)
 *
 * The string "str" must specify the conversion specification for any args.
 */

/*VARARGS1*/
err_quit(va_alist)
va_dcl
{
	va_list		args;
	char		*fmt;

	va_start(args);
	if (pname !=NULL)
		fprintf(stderr, "%s: ", pname);
	fmt = va_arg(args, char *);
	vfprintf(stderr, fmt, args);
	fputc('\n',stderr);
	va_end(args);

	exit(1);
}

/* err_sys */

/* err_ret */


/*
 * Fatal error. Print a message, dump core (for debugging) and terminate.
 *
 *	err_dump(str, arg1, arg2, ...)
 *
 * The string "str" must specify the conversion specification for any args.
 */

/*VARARGS1*/
err_dump(va_alist)
va_dcl
{
	va_list		args;
	char		*fmt;

	va_start(args);
	if (pname !=NULL)
		fprintf(stderr, "%s: ", pname);
	fmt = va_arg(args, char *);
	vfprintf(stderr, fmt, args);
	va_end(args);

	my_perror();

	fflush(stdout);
	fflush(stderr);

	abort();
	exit(1);
}

my_perror()
{
	char	*sys_err_str();

	fprintf(stderr, " %s\n", sys_err_str());
}

#endif /* CLIENT */

#ifdef SERVER

#ifdef BSD

#include	<syslog.h>

#else /* NOT BSD */

#define syslog(a,b)	fprintf(stderr, "%s\n", (b))
#define openlog(a,b,c)	fprintf(stderr, "%s\n", (a))

#endif /* BSD */

char	emesgstr[255] = {0};

/* err_init */

/* err_quit */

/* err_sys */

/* err_ret */

/*
 * Fatal error. Print a message, dump core (for debugging) and terminate.
 *
 *	err_dump(str, arg1, arg2, ...)
 *
 * The string "str" must specify the conversion specification for any args.
 */

err_dump(va_alist)
va_dcl
{
	va_list		args;
	char		*fmt;

	va_start(args);
	fmt = va_arg(args, char *);
	vsprintf(emesgstr, fmt, args);
	va_end(args);

	my_perror();
	syslog(LOG_ERR, emesgstr);

	abort();
	exit(1);
}

my_perror()
{
	register int	len;
	char		*sys_err_str();

	len = strlen(emesgstr);
	sprintf(emesgstr + len, " %s", sys_err_str());
}

#endif /* SERVER */

extern int	errno;
extern int	sys_nerr;
extern char	*sys_errlist[];

#ifdef	SYS5
int	t_errno;
int	t_nerr;
char	*t_errlist[1];
#endif

/*
 * Return a tring containing some additional operating-system
 * dependent information.
 * Note that different versions of UNIX assign different meanings
 * to the same value of "errno" ( compare errno's starting with 35
 * between System V and BSD, for example). This means that if an error
 * conditon is being sent to another UNIX system, we must interpret
 * the errno value on the system that generated the error, and not
 * just send the decimal value of errno to the other system.
 */

char *sys_err_str()
{
	static char	msgstr[200];

	if (errno != 0) {
	  if (errno > 0 && errno < sys_nerr)
	  	sprintf(msgstr, "(%s)", sys_errlist[errno]);
	  else
	  	sprintf(msgstr, "(errno = %d)", errno);
	} else {
	  msgstr[0] = '\0';
	}

#ifdef SYS5
	if(t_errno != 0) {
	  char tmsgstr[100];

	  if (t_errno > 0 && t_errno < sys_nerr)
	  	sprintf(tmsgstr, "(%s)", t_errlist[t_errno]);
	  else
	  	sprintf(t_msgstr, "(t_errno = %d)", t_errno);
	  strcat (msgstr, tmsgstr);
	}
#endif
	return(msgstr);
}
