/*
 * stats.c        1.3 11/22/95
 *    	Info on news posting setings printed at end of stats.
 * 
 * stats.c        1.2 9/10/95
 *    	Added automatic creation of non-existant stats.log file,
 *      and reinit to default if there is a problem
 *      Sendmail now uses To: not command line for destination.
 *
 *      (c) Copyright 1995 by Lance Cottrell. All right reserved.
 *      The author assumes no liability for damages resulting from the
 *      use of this software, even if the damage results from defects in
 *      this software. No warranty is expressed or implied.
 *
 *      This software is being distributed under the GNU Public Licence,
 *      see the file GNU.license for more details.
 *
 *	This software is slightly modified from Matt Ghio's "stats.c"
 *	distributed as part of his anonymous remailer.
 *
 *                      - Lance Cottrell (loki@obscura.com) 4/23/95
 *
 */

#include <stdio.h>
#include <time.h>
#include "crypt.h"
#include "mixmaster.h"

#ifndef LOCK_SH
#define LOCK_SH 1    /* shared lock */
#define LOCK_EX 2    /* exclusive lock */
#define LOCK_NB 4    /* don't block when locking */
#define LOCK_UN 8    /* unlock */
#endif


/* this creates an empty stats file */
void rebuild_stats(datafile)
FILE *datafile;
{
  int x;

  if(datafile != NULL) fclose(datafile);
  if((datafile=open_mix_file(STATS,"w"))==NULL) {
    fprintf(stderr,"Big problem! I can't create stats file!\n");
  }
  fprintf(datafile,"0\n"); /*dafault to zero hours */
  fprintf(datafile,"0 0 0\n"); /* default no messages ever */
  for(x=0;x<24;x++) {
    fprintf(datafile,"tmp 1 0 0 0\n"); /* tmp for month. First day, no messages */
  }
  fclose(datafile);
}


void stats(int flag, char *address)
{

  int m[24];
  int ccm;
  int p[24];
  int ccpgp;
  int l[24];
  int ccl;
  char month[24][80];
  int date[24];
  int hour;
  int currenthour;
  FILE *datafile,*pp,*statlock;
  int x;
  int y;
  int problem;
  char	line[256];

  struct tm *curtime;
  time_t now;

  now = time(NULL);
  curtime = localtime(&now);

  mix_lock("stats",&statlock);
  if((datafile=open_mix_file(STATS,"r"))==NULL) {
    rebuild_stats(datafile);
    mix_unlock("stats",statlock);
    return;
  }

  problem = 0;
  fgets(line,80,datafile);
  sscanf(line,"%d",&hour);
  fgets(line,80,datafile);
  sscanf(line,"%d %d %d",&ccm,&ccpgp,&ccl);
  if(hour > 24 || hour < 0) problem = 1;
  if(ccm < 0 || ccpgp < 0 || ccl < 0) problem = 1;
  if(ccm > 10000 || ccpgp > 10000 || ccl > 10000) problem = 1;
  for(x=0;x<24;x++) {
    if(fgets(line,80,datafile) == NULL) {
       problem = 1;
       break;
    }
    sscanf(line,"%s %d %d %d %d",month[x],&date[x],&m[x],&p[x],&l[x]);
    if(strlen(month[x]) > 5) problem = 1;
    if(date[x] < 1 || date[x] > 31) problem = 1;
    if(m[x] < 0 || p[x] < 0 || l[x] < 0) problem = 1;
    if(m[x] > 10000 || p[x] > 10000 || l[x] > 10000) problem = 1;
  }

  if(problem) {
     rebuild_stats(datafile);
     mix_unlock("stats",statlock);
     return;
  }
  /*
  fscanf(datafile,"%d",&hour);
  fscanf(datafile,"%d %d %d",&ccm,&ccpgp,&ccl);
  for(x=0;x<24;x++) {
    fscanf(datafile,"%s %d %d %d %d",month[x],&date[x],&m[x],&p[x],&l[x]); }
  */
  fclose(datafile);
  mix_unlock("stats",statlock);

  currenthour=curtime->tm_hour;

  x=hour;
  while (x!=currenthour) {
    if (x>0) {
      strcpy(month[x],month[x-1]);
      date[x]=date[x-1];
    }else{
      strftime(month[0],5,"%b",curtime);
      date[0] = curtime->tm_mday;
    }
    m[x]=0;
    p[x]=0;
    l[x]=0;
    x++;if (x>23) x=0;
  }

  if (hour!=currenthour) {
    m[hour]=ccm;
    p[hour]=ccpgp;
    l[hour]=ccl;
    ccm=0;
    ccpgp=0;
    ccl=0;
  }

  if (flag & FL_MESSAGE) ccm++;
  if (flag & FL_OLD) ccpgp++;
  if (flag & FL_NEW) ccl++;

  mix_lock("stats",&statlock);
  if((datafile=open_mix_file(STATS,"w"))==NULL) {
    mix_unlock("stats",statlock);
    return;
  }

  fprintf(datafile,"%d\n",currenthour);
  fprintf(datafile,"%d %d %d\n",ccm,ccpgp,ccl);
  for(x=0;x<24;x++) {
    fprintf(datafile,"%s %d %d %d %d\n",month[x],date[x],m[x],p[x],l[x]);
  }

  fclose(datafile);
  mix_unlock("stats",statlock);

  if (flag & FL_STATS) {
    strcpy(line,SENDMAIL);
/*  strcat(line,address); */ /* Address now in headers not cmd line */
    if((pp = popen(line,"w"))==NULL) return;
    fprintf(pp,"From: Remailer-Stats (%s)",REMAILERNAME);
    fprintf(pp," (via automated remailer software)\n");
    fprintf(pp,"Subject: Re: Remailer Statistics\n");
    fprintf(pp,"To: %s\n",address); /* Here is the address now */
    fprintf(pp,"\n");
    fprintf(pp,"Statistics for last 24 hours from anonymous remailer \n");
    fprintf(pp,"%s\n",REMAILERNAME);
    fprintf(pp,"\n");
    fprintf(pp,"Number of messages per hour from %s %d %d:00 to %s %d %d:59\n",
     month[23],date[23],currenthour,month[0],date[0],(currenthour+23)%24);
    fprintf(pp,"\n");
    /*ccm=0;ccpgp=0;ccl=0;*/
    for(x=0;x<24;x++) {
      fprintf(pp," %2d:00 (%2d) ",x,m[x]);
      if (m[x]>0) {
        y=0;while((y<m[x])&&(y<67)) {
          fprintf(pp,"*");
          y++;
        }
        ccm+=m[x];
        ccpgp+=p[x];
        ccl+=l[x];
      }
      fprintf(pp,"\n");
    }
    fprintf(pp,"\n");
    if(strlen(TYPE1) > 1) {	/* We support type 1 messages */
       fprintf(pp,"Total messages remailed in last 24 hours: %d\n",ccm);
       fprintf(pp,"Number of Mixmaster messages : %d\n",ccl);
       fprintf(pp,"Number of cypherpunk remailer messages: %d\n",ccpgp);
    } else { 	/* Mixmaster only */
       fprintf(pp,"Number of messages remailed in last 24 hours: %d\n",ccm);
    }
    fprintf(pp,"Current message reordering pool size: %d\n",POOLSIZE);

    /* Report on this remailer's ability to post to news */
    if (strlen(NEWS) > 1) {
      if(strstr(NEWS,"mail-to-news")) {
	fprintf(pp,"This remailer supports posting to news through the\n");
	fprintf(pp,"%s mail-to-news gateway.\n",MAILtoNEWS);
	fprintf(pp,"These are not entirely reliable, you should test to be\n");
	fprintf(pp,"sure that you can reach the groups you want\n");
      } else {
	fprintf(pp,"This remailer supports direct posting to news.\n");
	fprintf(pp,"Remember that not all news servers support all groups.\n");
      }
    } else {
      fprintf(pp,"This remailer does not support posting to news.\n");
    }
    pclose(pp);
  }
}
