/*
 * keymgt.c        1.5 11/5/95
 *	Key files created if they don't exist already.
 *
 * keymgt.c        1.4 9/10/95
 *	Minor bux fix to error messages
 *
 * keymgt.c        1.3 4/27/95
 *
 *      (c) Copyright 1995 by Lance Cottrell. All right reserved.
 *      The author assumes no liability for damages resulting from the
 *      use of this software, even if the damage results from defects in
 *      this software. No warranty is expressed or implied.
 *
 *      This software is being distributed under the GNU Public Licence,
 *      see the file GNU.license for more details.
 *
 *                      - Lance Cottrell (loki@obscura.com) 4/23/95
 *
 */

#include "mixmaster.h"
#include "crypt.h"
#include <stdio.h>
#include <stdlib.h>

#define MIX_RSA_MOD 1024
#define MIX_DH_PRIME 1024
#define MIX_DH_SUB 700



int	generate_DH()
{
	R_DH_PARAMS	DH_parms;
	unsigned int	primelen=MIX_DH_PRIME,sublen=MIX_DH_SUB;
	unsigned char	*byteptr,tmp,*temp, ID[16];
	unsigned char	prime[DH_PRIME_LEN(1024)],generator[DH_PRIME_LEN(1024)];
	int		len,i,err;
	BUFFER		*buff;
        R_DIGEST_CTX    context;
	FILE		*dhfile,*dhlock;

	printf("Now making the DH key. This may take a while.\n");

	mix_lock("DH",&dhlock);
	if((dhfile = open_mix_file("DH.mix","w"))==NULL) {
	   fprintf(stderr,"Error: Could not open DH.mix\n");
	   mix_unlock("DH",dhlock);
	   return(-1);
	}

	DH_parms.prime = prime;
	DH_parms.generator = generator;

	err = R_GenerateDHParams(&DH_parms,primelen,sublen,rand_struct());
	if(err!=0) {
	   fprintf(stderr,"Error: DH param generator error.\n");
	   fprintf(stderr,"err = %d, modlen = %d, randerr = %d\n",
	   	err,RE_MODULUS_LEN, RE_NEED_RANDOM);
	   return(-1);
	}

	/* Make Key ID */
	R_DigestInit(&context,DA_MD5);
	R_DigestUpdate(&context,DH_parms.prime,DH_PRIME_LEN(1024));
	R_DigestUpdate(&context,DH_parms.generator,DH_PRIME_LEN(1024));
	R_DigestFinal(&context,ID,&i);


	buff = new_buffer();
	tmp = DH_parms.primeLen;
	add_to_buffer(buff,&tmp,1);
	add_to_buffer(buff,DH_parms.prime,DH_PRIME_LEN(1024));
	tmp = DH_parms.generatorLen;
	add_to_buffer(buff,&tmp,1);
	add_to_buffer(buff,DH_parms.generator,DH_PRIME_LEN(1024));
	fwrite(begin_key,1,strlen(begin_key),dhfile);
	fprintf(dhfile,"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\n",
	   ID[0],ID[1],ID[2],ID[3],ID[4],ID[5],ID[6],ID[7],ID[8],ID[9],
	   ID[10],ID[11],ID[12],ID[13],ID[14],ID[15]);
	fprintf(dhfile,"%d\n",buff->length);

	/* Armor DH_parms */
	temp = malloc(((buff->length)*4/3)+1);
	R_EncodePEMBlock(temp,&i,buff->message,buff->length);
	R_memset((void *)(buff->message),0,buff->length);
	free_buffer(buff);
	byteptr = temp;
	while(i>40) {
	   fwrite(byteptr,1,40,dhfile);
	   fprintf(dhfile,"\n");
	   i -= 40;
	   byteptr += 40;
	}
	fwrite(byteptr,1,i,dhfile);
	fprintf(dhfile,"\n");
	fwrite(end_key,1,strlen(end_key),dhfile);
	fprintf(dhfile,"\n");
	fclose(dhfile);
	mix_unlock("DH",dhlock);
}


int	get_DH(DH_parms)
R_DH_PARAMS	*DH_parms;
{
        unsigned char           line[1024],IDstr[80],line2[1024];
        unsigned char           ID[16];
        int     i,j,k,err,len,length,found=0;
        DES3_CBC_CTX    context;
        unsigned char   *temp;
        FILE    *dhfile;
        FILE    *dhlock;
        R_DIGEST_CTX    digest_context;
        byte    digest[16],*byteptr;
        BUFFER  *buff;

        mix_lock("DH",&dhlock);
        if((dhfile = open_mix_file("DH.mix","r"))==NULL) {
           fprintf(stderr,"Error: Could not open DH.mix\n");
           mix_unlock("DH",dhlock);
           return(-1);
        }

        while(!found) {
           fgets(line,1024,dhfile);
           while(!strstr(line,begin_key)) {
              if(fgets(line,1024,dhfile)==NULL) {
                 fprintf(stderr,"End of file DH.mix\n");
                 fclose(dhfile);
                 mix_unlock("DH",dhlock);
                 return(-1);
              }
           }
           fgets(line2,1024,dhfile);
           buff = new_buffer();
           /* read in the length */
           if((temp=fgets(line,1024,dhfile))==NULL) break;
           sscanf(line,"%d",&length);

           if((temp=fgets(line,1024,dhfile))==NULL) break;
           while(temp!=NULL && !strstr(line,end_key)) {
              add_to_buffer(buff,line,strlen(line)-1);
              temp=fgets(line,1024,dhfile);
           }
           temp = malloc(buff->length); /* Longer than we need */
           R_DecodePEMBlock(temp,&len,buff->message,buff->length);
           free_buffer(buff);
           if(len < length) {
             fprintf(stderr,"Error: recovered DH key is too small!\n");
             fclose(dhfile);
             mix_unlock("DH",dhlock);
             return(-2);
           }

	   /* Rebuild the DH_parms struct */
           byteptr = temp;
           i = *byteptr;
           (*DH_parms).primeLen = i;
           byteptr++;
           for(i=0;i<DH_PRIME_LEN(1024);i++) {
              (*DH_parms).prime[i] = *byteptr;
              byteptr++;
           }
           i = *byteptr;
           (*DH_parms).generatorLen = i;
           byteptr++;
           for(i=0;i<DH_PRIME_LEN(1024);i++) {
              (*DH_parms).generator[i] = *byteptr;
              byteptr++;
           }
           free(temp);

	   /* Make Key ID */
	   R_DigestInit(&digest_context,DA_MD5);
	   R_DigestUpdate(&digest_context,(*DH_parms).prime,DH_PRIME_LEN(1024));
	   R_DigestUpdate(&digest_context,(*DH_parms).generator,DH_PRIME_LEN(1024));
	   R_DigestFinal(&digest_context,ID,&i);

           sprintf(IDstr,"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
              ID[0],ID[1],ID[2],ID[3],ID[4],ID[5],ID[6],ID[7],ID[8],ID[9],
              ID[10],ID[11],ID[12],ID[13],ID[14],ID[15]);

           /* compare new ID with saved ID */
           if(R_memcmp(IDstr,line2,32)!=0) {
             fprintf(stderr,"Error: DH Parameter IDs do not match!\n");
             fclose(dhfile);
             mix_unlock("DH",dhlock);
             return(-3);
           }
           found = 1; /* this will end the loop */
        }
        fclose(dhfile);
        mix_unlock("DH",dhlock);
        if(found) return(0);
        return(1);
}


int	generate_keys()
{
	R_RSA_PUBLIC_KEY	pubkey,pubkey2;
	R_RSA_PRIVATE_KEY	privkey,privkey2;
	R_RSA_PROTO_KEY		protokey;
	unsigned char		line[1024];
        int     i,j,k,err,len;
        DES3_CBC_CTX    context;
        unsigned char	key[24], iv[8], *encrypted_key;
        unsigned char	*temp,*temp2;
	FILE	*pubring, *privring, *keyfile, *fptr,*fptr2;
	FILE	*publock, *privlock, *keylock;
	char	tempfilename[80],tempfilename2[80];
	R_DIGEST_CTX	digest_context;
	byte	digest[16],ID[16],*byteptr,tmpbyte;
	byte	des3key[24];
	BUFFER	*b1,b2;

	fprintf(stderr,"Enter a bunch of characters then return:\n");
	fgets(line,256,stdin);
	add_to_random(line,256);
	fprintf(stderr,"Thanks. Now making the key. This may take a while.\n");

	/* Generate a 1024 bit key with pub exponent = 65537 */
	protokey.bits = MIX_RSA_MOD;
	protokey.useFermat4 = 1;
	err = R_GeneratePEMKeys(&pubkey, &privkey, &protokey, rand_struct());
	if(err!=0) {
	   fprintf(stderr,"Error: RSA key generator error.\n");
	   fprintf(stderr,"err = %d, modlen = %d, randerr = %d\n",
	   	err,RE_MODULUS_LEN, RE_NEED_RANDOM);
	   return(-1);
	}

	/* put private key in a buffer */
	b1 = new_buffer();
	/* Convert pubkey.bits to two bytes */
	i = privkey.bits;
	tmpbyte = i & 0xFF;
	add_to_buffer(b1,&tmpbyte,1); /* low byte of bits */
	i = i / 256;
	tmpbyte = i & 0xFF;
	add_to_buffer(b1,&tmpbyte,1); /* high byte of bits */

	for(i=0;i<MAX_RSA_MODULUS_LEN;i++) {
	   add_to_buffer(b1,&(privkey.modulus[i]),1);
	}
	for(i=0;i<MAX_RSA_MODULUS_LEN;i++) {
	   add_to_buffer(b1,&(privkey.publicExponent[i]),1);
	}
	for(i=0;i<MAX_RSA_MODULUS_LEN;i++) {
	   add_to_buffer(b1,&(privkey.exponent[i]),1);
	}
	for(i=0;i<MAX_RSA_PRIME_LEN;i++) {
	   add_to_buffer(b1,&(privkey.prime[0][i]),1);
	}
	for(i=0;i<MAX_RSA_PRIME_LEN;i++) {
	   add_to_buffer(b1,&(privkey.prime[1][i]),1);
	}
	for(i=0;i<MAX_RSA_PRIME_LEN;i++) {
	   add_to_buffer(b1,&(privkey.primeExponent[0][i]),1);
	}
	for(i=0;i<MAX_RSA_PRIME_LEN;i++) {
	   add_to_buffer(b1,&(privkey.primeExponent[1][i]),1);
	}
	for(i=0;i<MAX_RSA_PRIME_LEN;i++) {
	   add_to_buffer(b1,&(privkey.coefficient[i]),1);
	}


	/* Encrypt the secret key */
	len = b1->length;
	while(len % 8 != 0) len++; /* ensure length is mult of 8 */
	encrypted_key = malloc(len);
	for(i=0;i<8;i++) {
	   iv[i] = our_randombyte();
	}
	R_DigestInit(&digest_context,DA_MD5);
	R_DigestUpdate(&digest_context,PASSPHRASE,strlen(PASSPHRASE));
	R_DigestFinal(&digest_context,digest,&i);
	R_memcpy(des3key,digest,16); /* set first 2 keys */
	R_memcpy(des3key+16,digest,8); /* third key = first key */
	DES3_CBCInit(&context, des3key, iv, 1);
	if(DES3_CBCUpdate(&context,encrypted_key,b1->message,len)) {
	   printf("Error: Problem encrypting key\n");
	   return(-1);
	}

	R_memset((void *)&digest,0,16); /* zero password */

	/* Make Key ID */
	R_DigestInit(&digest_context,DA_MD5);
	R_DigestUpdate(&digest_context,pubkey.modulus,MAX_RSA_MODULUS_LEN);
	R_DigestUpdate(&digest_context,pubkey.exponent,MAX_RSA_MODULUS_LEN);
	R_DigestFinal(&digest_context,ID,&i);
	
	mix_lock("pubring",&publock);
	if((pubring = open_mix_file("pubring.mix","r+"))==NULL) {
	  fprintf(stderr,"Notice: creating pubring.mix\n");
	  if((pubring = open_mix_file("pubring.mix","w"))==NULL) {
	     fprintf(stderr,"Error: Could not open pubring.mix\n");
	     mix_unlock("pubring",publock);
	     return(-1);
	  }
	}
	mix_lock("secring",&privlock);
	if((privring = open_mix_file("secring.mix","r+"))==NULL) {
	  fprintf(stderr,"Notice: creating secring.mix\n");
	  if((privring = open_mix_file("secring.mix","w"))==NULL) {
	     fprintf(stderr,"Error: Could not open secring.mix\n");
	     mix_unlock("pubring",publock);
	     mix_unlock("secring",privlock);
	     return(-1);
	  }
	}
	mix_lock("key",&keylock);
	if((keyfile = open_mix_file(KEYFILE,"w"))==NULL) {
	   fprintf(stderr,"Error: Could not open %s\n",KEYFILE);
	   mix_unlock("pubring",publock);
	   mix_unlock("secring",privlock);
	   mix_unlock("key",keylock);
	   return(-1);
	}
	strcpy(tempfilename,"keytemp");
	if((fptr = tempfile(tempfilename))==NULL) {
	   fprintf(stderr,"Error: Could not open tempfile\n");
	   mix_unlock("pubring",publock);
	   mix_unlock("secring",privlock);
	   mix_unlock("key",keylock);
	   return(-1);
	}
	strcpy(tempfilename2,"keytemp2");
	if((fptr2 = tempfile(tempfilename2))==NULL) {
	   fprintf(stderr,"Error: Could not open tempfile\n");
	   mix_unlock("pubring",publock);
	   mix_unlock("secring",privlock);
	   mix_unlock("key",keylock);
	   return(-1);
	}

	/* dump privring into temp */
	while (fgets(line,1024,privring) != NULL){
	   fprintf(fptr,"%s",line);
	}
	rewind(fptr);
	rewind(privring);
	fwrite(begin_key,1,strlen(begin_key),privring);
	fprintf(privring,"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\n",
	   ID[0],ID[1],ID[2],ID[3],ID[4],ID[5],ID[6],ID[7],ID[8],ID[9],
	   ID[10],ID[11],ID[12],ID[13],ID[14],ID[15]);
	fprintf(privring,"%d\n",len);
	R_EncodePEMBlock(line,&i,iv,8);
	fwrite(line,1,i,privring);
	fprintf(privring,"\n");

	/* Armor privkey */
	temp = malloc(len*2);
	while(len % 3 != 0) len++;
	R_EncodePEMBlock(temp,&i,encrypted_key,len);
	byteptr = temp;
	while(i>40) {
	   fwrite(byteptr,1,40,privring);
	   fprintf(privring,"\n");
	   i -= 40;
	   byteptr += 40;
	}
	fwrite(byteptr,1,i,privring);
	fprintf(privring,"\n");
	fwrite(end_key,1,strlen(end_key),privring);
	fprintf(privring,"\n");
	/* dump temp back into privring */
	while (fgets(line,1024,fptr) != NULL){
	   fprintf(privring,"%s",line);
	}
	fclose(privring);
	fclose(fptr);
	unlink(tempfilename);


	/* Write text into mix.key */
	fprintf(keyfile,"From: %s (%s)\n",REMAILERADDR,REMAILERNAME);
	fprintf(keyfile,"Subject: Mixmaster key for %s\n",REMAILERNAME);
	fprintf(keyfile,"\nHere is the public key for %s\n\n",REMAILERNAME);
	fprintf(keyfile,"=-=-=-=-=-=-=-=-=-=-=-=\n");
	fprintf(keyfile,"%s %s ",SHORTNAME,REMAILERADDR);
	fprintf(keyfile,"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
	   ID[0],ID[1],ID[2],ID[3],ID[4],ID[5],ID[6],ID[7],ID[8],ID[9],
	   ID[10],ID[11],ID[12],ID[13],ID[14],ID[15]);
	fprintf(keyfile," %s\n\n",VERSION);



	/* dump pubring into temp */
	while (fgets(line,1024,pubring) != NULL){
	   fprintf(fptr2,"%s",line);
	}
	rewind(fptr2);
	rewind(pubring);
	fwrite(begin_key,1,strlen(begin_key),pubring);
	fwrite(begin_key,1,strlen(begin_key),keyfile);
	fprintf(pubring,"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\n",
	   ID[0],ID[1],ID[2],ID[3],ID[4],ID[5],ID[6],ID[7],ID[8],ID[9],
	   ID[10],ID[11],ID[12],ID[13],ID[14],ID[15]);
	fprintf(keyfile,"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\n",
	   ID[0],ID[1],ID[2],ID[3],ID[4],ID[5],ID[6],ID[7],ID[8],ID[9],
	   ID[10],ID[11],ID[12],ID[13],ID[14],ID[15]);

	/* Armor pubkey */
	b1 = new_buffer();
	/* Convert pubkey.bits to two bytes */
	i = pubkey.bits;
	tmpbyte = i & 0xFF;
	add_to_buffer(b1,&tmpbyte,1); /* low byte of bits */
	i = i / 256;
	tmpbyte = i & 0xFF;
	add_to_buffer(b1,&tmpbyte,1); /* high byte of bits */

	for(i=0;i<MAX_RSA_MODULUS_LEN;i++) {
	   add_to_buffer(b1,&(pubkey.modulus[i]),1);
	}
	for(i=0;i<MAX_RSA_MODULUS_LEN;i++) {
	   add_to_buffer(b1,&(pubkey.exponent[i]),1);
	}
	len = b1->length;
	while((b1->length % 3) != 0) add_to_buffer(b1,"X",1);

	fprintf(pubring,"%d\n",len);
	fprintf(keyfile,"%d\n",len);

	temp = malloc(ENCODED_CONTENT_LEN(b1->length)+4);
	R_EncodePEMBlock(temp,&i,(unsigned char *)b1->message,b1->length);
	byteptr = temp;
	while(i>40) {
	   fwrite(byteptr,1,40,pubring);
	   fwrite(byteptr,1,40,keyfile);
	   fprintf(pubring,"\n");
	   fprintf(keyfile,"\n");
	   i -= 40;
	   byteptr += 40;
	}
	fwrite(byteptr,1,i,pubring);
	fwrite(byteptr,1,i,keyfile);
	fprintf(pubring,"\n");
	fprintf(keyfile,"\n");
	fwrite(end_key,1,strlen(end_key),pubring);
	fwrite(end_key,1,strlen(end_key),keyfile);
	fprintf(pubring,"\n");
	fprintf(keyfile,"\n");
	/* dump temp back into pubring */
	while (fgets(line,1024,fptr2) != NULL){
	   fprintf(pubring,"%s",line);
	}
	fclose(fptr2);
	unlink(tempfilename2);
	fclose(pubring);
	fclose(keyfile);

	/* Now unlock the files */
	mix_unlock("pubring",publock);
	mix_unlock("secring",privlock);
	mix_unlock("key",keylock);


	/* Check to see that the keys were saved correctly */
	get_rsa_key(ID,&pubkey2);
	get_rsa_priv_key(ID,&privkey2);
	if(R_memcmp((void *)&pubkey,(void *)&pubkey2,sizeof(pubkey))!=0) {
	   fprintf(stderr,"Saved public key does not match real key\n");
	}
	if(R_memcmp((void *)&privkey,(void *)&privkey2,sizeof(privkey))!=0) {
	   fprintf(stderr,"Saved secret key does not match real key\n");
	}

	R_memset((void *)&privkey,0,sizeof(privkey)); /* zero privkey */
}


int get_rsa_key(ID,pubkey)
unsigned char	*ID;
R_RSA_PUBLIC_KEY *pubkey;
{
	unsigned char		line[1024],IDstr[80],line2[1024];
	unsigned char		newID[16];
        int     i,j,k,err,len,length,found=0;
        DES3_CBC_CTX    context;
        unsigned char	key[24], iv[8], *encrypted_key;
        unsigned char	*temp;
	FILE	*pubring;
	FILE	*publock;
	R_DIGEST_CTX	digest_context;
	byte	digest[16],*byteptr;
	BUFFER	*buff;

	sprintf(IDstr,"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
	   ID[0],ID[1],ID[2],ID[3],ID[4],ID[5],ID[6],ID[7],ID[8],ID[9],
	   ID[10],ID[11],ID[12],ID[13],ID[14],ID[15]);
	mix_lock("pubring",&publock);
	if((pubring = open_mix_file("pubring.mix","r"))==NULL) {
	   fprintf(stderr,"Error: Could not open pubring.mix\n");
	   mix_unlock("pubring",publock);
	   return(-1);
	}

	while(!found) {
	   fgets(line,1024,pubring);
	   while(!strstr(line,begin_key)) {
	      if(fgets(line,1024,pubring)==NULL) {
	         fprintf(stderr,"End of file pubring.mix\n");
	         fclose(pubring);
	         mix_unlock("pubring",publock);
	         return(-1);
	      }
	   }
	   fgets(line,1024,pubring);
	   if(strstr(line,IDstr)) {
	      buff = new_buffer();
	      /* read in the length */
	      if((temp=fgets(line,1024,pubring))==NULL) break;
	      sscanf(line,"%d",&length);

	      if((temp=fgets(line,1024,pubring))==NULL) break;
	      while(temp!=NULL && !strstr(line,end_key)) {
	         add_to_buffer(buff,line,strlen(line)-1);
	         temp=fgets(line,1024,pubring);
	      }
	      temp = malloc(buff->length); /* Longer than we need */
	      R_DecodePEMBlock(temp,&len,buff->message,buff->length);
	      free_buffer(buff);
	      if(len < length) {
	        fprintf(stderr,"Error: recovered key is too small!\n");
	        fclose(pubring);
	        mix_unlock("pubring",publock);
	        return(-2);
	      }
	      byteptr = temp;
	      i = *byteptr;
	      byteptr ++;
	      i += (*byteptr * 256);
	      (*pubkey).bits = i;
	      byteptr++;
	      for(i=0;i<MAX_RSA_MODULUS_LEN;i++) {
		 (*pubkey).modulus[i] = *byteptr;
		 byteptr++;
	      }
	      for(i=0;i<MAX_RSA_MODULUS_LEN;i++) {
		 (*pubkey).exponent[i] = *byteptr;
		 byteptr++;
	      }
	      free(temp);

	      /* Make Key ID */
	      R_DigestInit(&digest_context,DA_MD5);
	      R_DigestUpdate(&digest_context,(*pubkey).modulus,MAX_RSA_MODULUS_LEN);
	      R_DigestUpdate(&digest_context,(*pubkey).exponent,MAX_RSA_MODULUS_LEN);
	      R_DigestFinal(&digest_context,newID,&i);

	      /* compare new ID with passed ID */
	      if(R_memcmp(ID,newID,16)!=0) {
	        fprintf(stderr,"Error: Public Key IDs do not match!\n");
	        fclose(pubring);
	        mix_unlock("pubring",publock);
	        return(-3);
	      }
	      found = 1; /* this will end the loop */
	   }
	}
	fclose(pubring);
	mix_unlock("pubring",publock);
	if(found) return(0);
	return(1);
}


int get_rsa_priv_key(ID,privkey)
unsigned char	*ID;
R_RSA_PRIVATE_KEY *privkey;
{
	unsigned char		line[1024],IDstr[80],line2[1024];
	unsigned char		newID[16];
        int     i,j,k,err,len,length,found=0;
        DES3_CBC_CTX    context;
        unsigned char	key[24], iv[20], *encrypted_key;
        unsigned char	*temp,*temp2;
	FILE	*privring;
	FILE	*privlock;
	R_DIGEST_CTX	digest_context;
	byte	digest[16],*byteptr;
	byte	des3key[24];
	BUFFER	*buff;
	R_RSA_PUBLIC_KEY pubkey;

	sprintf(IDstr,"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
	   ID[0],ID[1],ID[2],ID[3],ID[4],ID[5],ID[6],ID[7],ID[8],ID[9],
	   ID[10],ID[11],ID[12],ID[13],ID[14],ID[15]);
	mix_lock("secring",&privlock);
	if((privring = open_mix_file("secring.mix","r"))==NULL) {
	   fprintf(stderr,"Error: Could not open secring.mix\n");
	   mix_unlock("secring",privlock);
	   return(-1);
	}

	while(!found) {
	   fgets(line,1024,privring);
	   while(!strstr(line,begin_key)) {
	      if(fgets(line,1024,privring)==NULL) {
	         fprintf(stderr,"End of file secring.mix\n");
	         fclose(privring);
	         mix_unlock("secring",privlock);
	         return(-1);
	      }
	   }
	   fgets(line,1024,privring);
	   if(strstr(line,IDstr)) {
	      buff = new_buffer();
	      /* read in the length */
	      if((temp=fgets(line,1024,privring))==NULL) break;
	      sscanf(line,"%d",&length);

	      /* Read in iv */
	      if((temp=fgets(line,1024,privring))==NULL) break;
	      R_DecodePEMBlock(iv,&len,line,strlen(line)-1);

	      if((temp=fgets(line,1024,privring))==NULL) break;
	      while(temp!=NULL && !strstr(line,end_key)) {
	         add_to_buffer(buff,line,strlen(line)-1);
	         temp=fgets(line,1024,privring);
	      }
	      temp = malloc(buff->length);
	      temp2 = malloc(buff->length);
	      R_DecodePEMBlock(temp,&len,buff->message,buff->length);

	      if(len < length) {
	        fprintf(stderr,"Error: recovered key is too small!\n");
	        fclose(privring);
	        mix_unlock("secring",privlock);
	        return(-2);
	      }


	      /* decrypt key */
              R_DigestInit(&digest_context,DA_MD5);
              R_DigestUpdate(&digest_context,PASSPHRASE,strlen(PASSPHRASE));
              R_DigestFinal(&digest_context,digest,&i);
	      R_memcpy(des3key,digest,16); /* set first 2 keys */
	      R_memcpy(des3key+16,digest,8); /* third key = first key */
              DES3_CBCInit(&context, des3key, iv, 0);
	      while(len%8 != 0) len++; /* align on block boundry */
	      err = DES3_CBCUpdate(&context,temp2,temp,len);
              if(err) {
                 printf("Error: Problem decrypting key %x\n",err);
                 return(-1);
              }
              R_memset((void *)&digest,0,16); /* zero password */
	      free(temp);

	      /* Rebuild privkey */
	      byteptr = temp2;
	      i = *byteptr;
	      byteptr++;
	      i += (*byteptr * 256);
	      (*privkey).bits = i;
	      byteptr++;

              for(i=0;i<MAX_RSA_MODULUS_LEN;i++) {
                 (*privkey).modulus[i] = *byteptr;
	         byteptr++;
              }
              for(i=0;i<MAX_RSA_MODULUS_LEN;i++) {
                 (*privkey).publicExponent[i] = *byteptr;
	         byteptr++;
              }
              for(i=0;i<MAX_RSA_MODULUS_LEN;i++) {
                 (*privkey).exponent[i] = *byteptr;
	         byteptr++;
              }
              for(i=0;i<MAX_RSA_PRIME_LEN;i++) {
                 (*privkey).prime[0][i] = *byteptr;
	         byteptr++;
              }
              for(i=0;i<MAX_RSA_PRIME_LEN;i++) {
                 (*privkey).prime[1][i] = *byteptr;
	         byteptr++;
              }
              for(i=0;i<MAX_RSA_PRIME_LEN;i++) {
                 (*privkey).primeExponent[0][i] = *byteptr;
	         byteptr++;
              }
              for(i=0;i<MAX_RSA_PRIME_LEN;i++) {
                 (*privkey).primeExponent[1][i] = *byteptr;
	         byteptr++;
              }
              for(i=0;i<MAX_RSA_PRIME_LEN;i++) {
                 (*privkey).coefficient[i] = *byteptr;
	         byteptr++;
              }

	      free(temp2);


	      /* Make a pubkey to hash for ID */
	      pubkey.bits = privkey->bits;
	      R_memcpy(pubkey.modulus,privkey->modulus,MAX_RSA_MODULUS_LEN);
	      R_memcpy(pubkey.exponent,privkey->publicExponent,MAX_RSA_MODULUS_LEN);

	      /* Make Key ID */
	      R_DigestInit(&digest_context,DA_MD5);
	      R_DigestUpdate(&digest_context,pubkey.modulus,MAX_RSA_MODULUS_LEN);
	      R_DigestUpdate(&digest_context,pubkey.exponent,MAX_RSA_MODULUS_LEN);
	      R_DigestFinal(&digest_context,newID,&i);

	      /* compare new ID with passed ID */
	      if(R_memcmp(ID,newID,16)!=0) {
	        fprintf(stderr,"Error: Private Key IDs do not match!\n");
	        fclose(privring);
	        mix_unlock("secring",privlock);
	        return(-3);
	      }
	      found = 1; /* this will end the loop */
	   }
	}
	fclose(privring);
	mix_unlock("secring",privlock);
	if(found) return(0);
	fprintf(stderr,"Unable to find specified key ID\n");
	return(1);
}

