/* Generated By: Maker.jj,v 1.3 1997/11/22 07&JavaCC: Do not edit this line. Maker.java */
package cryptix.util.test;

import cryptix.test.BaseTest;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import cryptix.provider.key.RawSecretKey;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.security.Cipher;
import java.security.FeedbackCipher;
import java.security.MessageDigest;
import java.security.Mode;
import java.security.Parameterized;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;


public class Maker
extends BaseTest implements MakerConstants {
    /** current MessageDigest algorithm implementation being tested */
    private MessageDigest md;

    /** current cipher algorithm implementation being tested as a Cipher */
    private Cipher algc;

    /** current cipher algorithm implementation being tested as a Mode */
    private Mode algm;

    /** name of the class being tested. */
    private String implementation;

    /** name of the mode in which to run a cipher algorithm. */
    private String mode;

    /** padding scheme to use with the cipher algorithm. */
    private String padding;

    /** iv value for the current cipher. */
    private byte[] iv;

    /** algorithm specific property values for this round. */
    private Hashtable properties = new Hashtable();

    /** global counter for all test rounds. */
    private int gCount;

    /** counter for each individual test module. */
    private int count;

    private static final String HEADER =
        "Cryptix security provider algorithm implementation test interpreter\n" +
        "Version: $Revision: 1.6 $\n" +
        "Copyright (c) 1997, Systemics Ltd on behalf of the\n" +
        "Cryptix Development Team. All rights reserved.\n";

    private static final String USAGE =
        "Usage:\n" +
        "\tjava cryptix.util.test.Maker inputfile [ > outputfile ]\n" +
        "\tjava cryptix.util.test.Maker < inputfile [ > outputfile ]\n";

    private static final String SEPARATOR =
        "\n------------------------------------------------------------\n";


    public static void main (String[] args) {
        Maker parser;
        if (args.length == 0) {
            System.out.println(HEADER);
            System.out.println("Parsing standard input...\n");
            parser = new Maker(System.in);
        } else if (args.length == 1) {
            System.out.println(HEADER);
            System.out.println("Parsing " + args[0] + "...\n" );
            try { parser = new Maker(new FileInputStream(args[0])); }
            catch (FileNotFoundException e) {
                System.out.println("File '" + args[0] + "' not found.");
                return;
            }
        } else {
            System.out.println(USAGE);
            return;
        }
        parser.commandline(new String[0]);
/*
        try {
            parser.Specification();
            System.out.println("Done parsing :-)");
        } catch (ParseException e) {
            System.out.println("Failed parsing :-(");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
*/
    }

    protected void engineTest ()
    throws Exception {
        Specification();
    }

// FILE / MODULE SPECIFICATION ==============================================
  final public void Specification() throws ParseException {
    trace_call("Specification");
    try {
    disable_tracing();
    gCount = 0;
      label_1:
      while (true) {
        TestModule();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MESSAGE_DIGEST:
        case CIPHER:
        case INCLUDE:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
      }
      jj_consume_token(0);
    } finally {
      trace_return("Specification");
    }
  }

  final public void TestModule() throws ParseException {
    trace_call("TestModule");
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MESSAGE_DIGEST:
        MessageDigestTest();
        break;
      case CIPHER:
        CipherTest();
        break;
      case INCLUDE:
        IncludedTest();
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      trace_return("TestModule");
    }
  }

// Message Digest ===========================================================
  final public void MessageDigestTest() throws ParseException {
    trace_call("MessageDigestTest");
    try {
      jj_consume_token(MESSAGE_DIGEST);
      implementation = Identifier();
            // set default values and initialise various vars
            algc = null;
            algm = null;
            properties.clear();
            count = 0;
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PROPERTIES:
          MessageDigestProperties();
          break;
        default:
          jj_la1[2] = jj_gen;
          ;
        }
        jj_consume_token(DATA);
                String algorithm;
                System.out.println("\n" + (++gCount) + ". " + implementation +
                    " test round #" + (++count) + "...");

                // at this point we can instantiate an md
                try { md = MessageDigest.getInstance(implementation); }
                catch (Throwable e) {
                    e.printStackTrace();
                    {if (true) throw new Error(e.getMessage());}
                }
                // now set algorithm specific properties if any. For this we
                // have to implement a new interface for the MessageDigest
                // classes that offers set/getParameter() methods similar to
                // what java.security.Cipher does. For the time being cripple it
                //
                // as of 22.11.97 we now have java.security.Parameterized.
                // use it if properties is not empty.
                //
                if (properties.isEmpty()) {if (true) return;}
                if (md instanceof Parameterized) {
                    Enumeration keys = properties.keys();
                    String aProperty;
                    Object aValue;
                    while (keys.hasMoreElements()) {
                        aProperty = (String) keys.nextElement();
                        aValue = properties.get(aProperty);
                        System.out.println("  " + aProperty + ":\t" + aValue);
                        try { ((Parameterized) md).setParameter(aProperty, aValue); }
                        catch (Throwable e1) {
                            e1.printStackTrace();
                            {if (true) throw new Error(e1.getMessage());}
                        }
                    }
                } else
                    System.out.println("Message digest " + implementation +
                        " does not implement java.security.Parameterized.\n" +
                        "Will ignore requested property values...");
        label_3:
        while (true) {
          MessageDigestData();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NUMBER:
          case STRING_LITERAL:
            ;
            break;
          default:
            jj_la1[3] = jj_gen;
            break label_3;
          }
        }
                System.out.println(SEPARATOR);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PROPERTIES:
        case DATA:
          ;
          break;
        default:
          jj_la1[4] = jj_gen;
          break label_2;
        }
      }
    } finally {
      trace_return("MessageDigestTest");
    }
  }

  final public void MessageDigestProperties() throws ParseException {
    trace_call("MessageDigestProperties");
    try {
      jj_consume_token(PROPERTIES);
      label_4:
      while (true) {
        AlgorithmSpecificProperty();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PROPERTY:
          ;
          break;
        default:
          jj_la1[5] = jj_gen;
          break label_4;
        }
      }
    } finally {
      trace_return("MessageDigestProperties");
    }
  }

  final public void MessageDigestData() throws ParseException {
    trace_call("MessageDigestData");
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
        SingleIterationData();
        break;
      case NUMBER:
        MultiIterationData();
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      trace_return("MessageDigestData");
    }
  }

  final public void SingleIterationData() throws ParseException {
    trace_call("SingleIterationData");
    try {
    Token t;
    byte[] certified;
      t = jj_consume_token(STRING_LITERAL);
      certified = HexadecimalData();
            System.out.println("  input:  " + t.image);
            String message = t.image.substring(1, t.image.length() - 1);
            System.out.println(" digest:  " + Hex.toString(certified));

            byte[] computed = md.digest(message.getBytes());
            boolean ok = ArrayUtil.areEqual(certified, computed);
            passIf(ok, "\nDigest operation");
            if (! ok) {
//                System.out.print("\nDigest operation failed... Computed value is: ");
//                System.out.println(Hex.toString(computed));
                System.out.println("Computed value is: " + Hex.toString(computed));
            }
            System.out.println();
    } finally {
      trace_return("SingleIterationData");
    }
  }

  final public void MultiIterationData() throws ParseException {
    trace_call("MultiIterationData");
    try {
    Token n, t;
    long limit;
    byte[] certified;
      n = jj_consume_token(NUMBER);
      jj_consume_token(26);
      t = jj_consume_token(STRING_LITERAL);
      certified = HexadecimalData();
            limit = new Long(n.image).longValue();
            System.out.println("  input:  " + limit + " times " + t.image);
            String message = t.image.substring(1, t.image.length() - 1);
            System.out.println(" digest:  " + Hex.toString(certified));

            byte[] unit = message.getBytes();
            for (long i = 0; i < limit; i++) md.update(unit);
            byte[] computed = md.digest();
            boolean ok = ArrayUtil.areEqual(certified, computed);
            passIf(ok, "\nDigest operation");
            if (! ok) {
//                System.out.print("\nDigest operation failed... Computed digest is: ");
//                System.out.println(Hex.toString(computed));
                System.out.println("Computed digest is: " + Hex.toString(computed));
            }
            System.out.println();
    } finally {
      trace_return("MultiIterationData");
    }
  }

// Cipher ===================================================================
  final public void CipherTest() throws ParseException {
    trace_call("CipherTest");
    try {
      jj_consume_token(CIPHER);
      implementation = Identifier();
            // set default values for mode and padding
            mode = "ECB";
            padding = "NONE";
            iv = null;
            md = null;
            properties.clear();
            count = 0;
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PROPERTIES:
          CipherProperties();
          break;
        default:
          jj_la1[7] = jj_gen;
          ;
        }
        jj_consume_token(DATA);
                String algorithm;
                System.out.println("\n" + (++gCount) + ". " + implementation +
                    " test round #" + (++count) + "...");
                System.out.println("  mode:\t\t" + mode);
                if (padding != null) {
                    System.out.println("  padding:\t" + padding);
                    algorithm = implementation + "/" + mode + "/" + padding;
                } else
                    algorithm = implementation + "/" + mode;

                // at this point we can instantiate a cipher
                try { algm = (Mode) Cipher.getInstance(algorithm); }
                catch (ClassCastException e1) {
                    // we're running in ECB mode (assuming Cryptix provider)
                    algm = null;
                    try { algc = Cipher.getInstance(algorithm); }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                        {if (true) throw new Error(e2.getMessage());}
                    }
                }
                catch (Throwable e3) {
                    e3.printStackTrace();
                    {if (true) throw new Error(e3.getMessage());}
                }
                if (iv != null) {
                    System.out.println("  iv:\t\t" + Hex.toString(iv));
                    ((FeedbackCipher) algm).setInitializationVector(iv);
                }
                // at this point we won't need algm anymore
                if (algm != null) algc = algm;

                // now set algorithm specific properties if any
                Enumeration keys = properties.keys();
                String aProperty;
                Object aValue;
                while (keys.hasMoreElements()) {
                    aProperty = (String) keys.nextElement();
                    aValue = properties.get(aProperty);
                    System.out.println("  " + aProperty + ":\t" + aValue);
                    try { algc.setParameter(aProperty, aValue); }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                        {if (true) throw new Error(e1.getMessage());}
                    }
                }
        label_6:
        while (true) {
          CipherData();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case HEX_LITERAL:
            ;
            break;
          default:
            jj_la1[8] = jj_gen;
            break label_6;
          }
        }
                System.out.println(SEPARATOR);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PROPERTIES:
        case DATA:
          ;
          break;
        default:
          jj_la1[9] = jj_gen;
          break label_5;
        }
      }
    } finally {
      trace_return("CipherTest");
    }
  }

  final public void CipherProperties() throws ParseException {
    trace_call("CipherProperties");
    try {
      jj_consume_token(PROPERTIES);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MODE:
        jj_consume_token(MODE);
        mode = Identifier();
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PADDING:
        jj_consume_token(PADDING);
        padding = Identifier();
        break;
      default:
        jj_la1[11] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IV:
        jj_consume_token(IV);
        iv = HexadecimalData();
        break;
      default:
        jj_la1[12] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PROPERTY:
        label_7:
        while (true) {
          AlgorithmSpecificProperty();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PROPERTY:
            ;
            break;
          default:
            jj_la1[13] = jj_gen;
            break label_7;
          }
        }
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
    } finally {
      trace_return("CipherProperties");
    }
  }

  final public void CipherData() throws ParseException {
    trace_call("CipherData");
    try {
      if (jj_2_1(3)) {
        TwoWayTestData();
      } else if (jj_2_2(3)) {
        SymmetricTestData();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HEX_LITERAL:
          SpeedTestData();
          break;
        default:
          jj_la1[15] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } finally {
      trace_return("CipherData");
    }
  }

  final public void TwoWayTestData() throws ParseException {
    trace_call("TwoWayTestData");
    try {
    byte[] k, p, c;
      k = HexadecimalData();
      // the key
          p = HexadecimalData();
      // the plaintext
          c = HexadecimalData();
        try {
            System.out.print("  key:\t\t");
            System.out.println(Hex.dumpString(k));

            System.out.print("  input:\t");
            System.out.println(Hex.dumpString(p));

            System.out.print("  output:\t");
            System.out.println(Hex.dumpString(c));

            RawSecretKey key = new RawSecretKey(implementation, k);

            algc.initEncrypt(key);
            byte[] computed = algc.crypt(p);
            boolean ok = ArrayUtil.areEqual(c, computed);
            passIf(ok, "\nEncryption");
            if (! ok) {
//                System.out.print("\nEncryption failed... Computed output is: ");
//                System.out.println(Hex.dumpString(computed));
                System.out.println("Computed output is: " + Hex.dumpString(computed));
            }
            algc.initDecrypt(key);
            computed = algc.crypt(c);
            ok = ArrayUtil.areEqual(p, computed);
            passIf(ok, "\nDecryption");
            if (! ok) {
//                System.out.print("\nDecryption failed... Computed input is: ");
//                System.out.println(Hex.dumpString(computed));
                System.out.print("Computed input is: " + Hex.dumpString(computed));
            }
            System.out.println();
        }
        catch (Throwable e) {
            e.printStackTrace();
            {if (true) throw new Error(e.getMessage());}
        }
    } finally {
      trace_return("TwoWayTestData");
    }
  }

  final public void SymmetricTestData() throws ParseException {
    trace_call("SymmetricTestData");
    try {
    byte[] k, p;
      k = HexadecimalData();
      // the key
          p = HexadecimalData();
      jj_consume_token(AUTO);
        try {
            System.out.print("  key:\t\t");
            System.out.println(Hex.dumpString(k));

            System.out.print("  input:\t");
            System.out.println(Hex.dumpString(p));

            RawSecretKey key = new RawSecretKey(implementation, k);

            algc.initEncrypt(key);
            byte[] computed = algc.crypt(p);

            // now decrypt this result to check if we get the
            // original plaintext
            algc.initDecrypt(key);
            computed = algc.crypt(computed);
            boolean ok = ArrayUtil.areEqual(p, computed);
            passIf(ok, "\nSymmetric operation");
            if (! ok) {
//                System.out.print("\nSymmetric operation failed... Computed input is: ");
//                System.out.println(Hex.dumpString(computed));
                System.out.println("Computed input is: " + Hex.dumpString(computed));
            }
            System.out.println();
        }
        catch (Throwable e) {
            e.printStackTrace();
            {if (true) throw new Error(e.getMessage());}
        }
    } finally {
      trace_return("SymmetricTestData");
    }
  }

  final public void SpeedTestData() throws ParseException {
    trace_call("SpeedTestData");
    try {
    byte[] k, p;
      k = HexadecimalData();
      // the key
          p = HexadecimalData();
      jj_consume_token(SPEED);
        try {
            System.out.print("  key:\t\t");
            System.out.println(Hex.dumpString(k));

            System.out.print("  input:\t");
            System.out.println(Hex.dumpString(p));

            byte[] c = (byte[]) p.clone();
            int inLen = c.length;
            int i, j;

            RawSecretKey key = new RawSecretKey(implementation, k);

            System.out.println("\nSpeed tests over 100,000 * " + inLen + " bytes...\n");

            algc.initEncrypt(key);
            System.out.println("Encryption...");
            System.out.println("  start date/time:  " + new Date().toString());
            for (i = 0; i < 100; i++)
                for (j = 0; j < 1000; j++) algc.update(c, 0, inLen, c, 0);
            System.out.println("  finish date/time: " + new Date().toString());

            algc.initDecrypt(key);
            System.out.println("\nDecryption...");
            System.out.println("  start date/time:  " + new Date().toString());
            for (i = 0; i < 100; i++)
                for (j = 0; j < 1000; j++) algc.update(c, 0, inLen, c, 0);
            System.out.println("  finish date/time: " + new Date().toString());

            boolean ok = ArrayUtil.areEqual(p, c);
            passIf(ok, "\nSymmetric operation");
            if (! ok) {
//                System.out.print("\nSymmetric operation failed... Computed input is: ");
//                System.out.println(Hex.dumpString(c));
                System.out.println("Computed input is: " + Hex.dumpString(c));
            }
            System.out.println();
        }
        catch (Throwable e) {
            e.printStackTrace();
            {if (true) throw new Error(e.getMessage());}
        }
    } finally {
      trace_return("SpeedTestData");
    }
  }

// Algorithm specific properties ............................................
  final public void AlgorithmSpecificProperty() throws ParseException {
    trace_call("AlgorithmSpecificProperty");
    try {
    Token p, v;
    String property;
      p = jj_consume_token(PROPERTY);
      jj_consume_token(27);
            property = p.image;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        v = jj_consume_token(NUMBER);
                properties.put(property, new Integer(v.image));
        break;
      case STRING_LITERAL:
        v = jj_consume_token(STRING_LITERAL);
                // get rid of the surrounding double-quotes
                properties.put(property, v.image.substring(1, v.image.length() - 1));
        break;
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      trace_return("AlgorithmSpecificProperty");
    }
  }

// Special non-terminals ....................................................
  final public String Identifier() throws ParseException {
    trace_call("Identifier");
    try {
    Token t;
      t = jj_consume_token(ID);
            {if (true) return t.image;}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("Identifier");
    }
  }

  final public byte[] HexadecimalData() throws ParseException {
    trace_call("HexadecimalData");
    try {
    Token t;
      t = jj_consume_token(HEX_LITERAL);
            String s = t.image;
            // should get rid of delimiter characters in s before
            // passing it to Hex
            String news = "";
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreTokens()) news += st.nextToken();
            {if (true) return Hex.fromString(news);}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("HexadecimalData");
    }
  }

// Included test ============================================================
  final public void IncludedTest() throws ParseException {
    trace_call("IncludedTest");
    try {
    Token t;
      jj_consume_token(INCLUDE);
      t = jj_consume_token(STRING_LITERAL);
            Maker embedded = null;
            String f = t.image.substring(1, t.image.length() - 1);
            System.out.println("Begin included file " + f + "...\n" );
            try { embedded = new Maker(new FileInputStream(f)); }
            catch (FileNotFoundException e) {
                System.out.println("File '" + f + "' not found...\n");
                System.out.println("End included file " + f + "...\n");
                {if (true) return;}
            }
            try {
                embedded.Specification();
//                System.out.println("Done parsing included file " + f + "...\n");
                pass("Parsing included file " + f);
            } catch (ParseException e) {
//                System.out.println("Failed parsing included file " + f + "...\n");
                fail("Parsing included file " + f);
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
    } finally {
      trace_return("IncludedTest");
    }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_3R_8() {
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_9()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_10() {
    if (jj_scan_token(HEX_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_9() {
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(AUTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public MakerTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[17];
  final private int[] jj_la1_0 = {0x10180,0x10180,0x200,0x3000000,0x600,0x200000,0x3000000,0x200,0x40000,0x600,0x800,0x1000,0x2000,0x200000,0x200000,0x40000,0x3000000,};
  final private JJMakerCalls[] jj_2_rtns = new JJMakerCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public Maker(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new MakerTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 17; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJMakerCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 17; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJMakerCalls();
  }

  public Maker(MakerTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 17; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJMakerCalls();
  }

  public void ReInit(MakerTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 17; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJMakerCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJMakerCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      trace_token(token, "");
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
      trace_token(token, " (in getNextToken)");
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enum = jj_expentries.elements(); enum.hasMoreElements();) {
        int[] oldentry = (int[])(enum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[28];
    for (int i = 0; i < 28; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 17; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 28; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  private int trace_indent = 0;
  private boolean trace_enabled = true;

  final public void enable_tracing() {
    trace_enabled = true;
  }

  final public void disable_tracing() {
    trace_enabled = false;
  }

  final private void trace_call(String s) {
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.println("Call:   " + s);
    }
    trace_indent = trace_indent + 2;
  }

  final private void trace_return(String s) {
    trace_indent = trace_indent - 2;
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.println("Return: " + s);
    }
  }

  final private void trace_token(Token t, String where) {
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.print("Consumed token: <" + tokenImage[t.kind]);
      if (t.kind != 0 && !tokenImage[t.kind].equals("\"" + t.image + "\"")) {
        System.out.print(": \"" + t.image + "\"");
      }
      System.out.println(">" + where);
    }
  }

  final private void trace_scan(Token t1, int t2) {
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.print("Visited token: <" + tokenImage[t1.kind]);
      if (t1.kind != 0 && !tokenImage[t1.kind].equals("\"" + t1.image + "\"")) {
        System.out.print(": \"" + t1.image + "\"");
      }
      System.out.println(">; Expected token: <" + tokenImage[t2] + ">");
    }
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
      JJMakerCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJMakerCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJMakerCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

}

final class JJMakerCalls {
  int gen;
  Token first;
  int arg;
  JJMakerCalls next;
}
