
;;; d-movement-hooks.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-movement-hooks.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Hooks for d-movement--unpad-buffer and d-movement--pad-buffer
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

;;(setq find-file-hook nil)
(add-hook 'find-file-hook 'd-movement--find-file-hook)
;;(setq find-file-hook '(save-place-find-file-hook d-movement--find-file-hook))
;;(setq find-file-hook '(d-movement--find-file-hook))
;;(setq find-file-hook '(save-place-find-file-hook d-movement--find-file-hook))

(defun d-movement--find-file-hook ()
  (if (d-movement--is-correct-mode)
    (let (m)
      (setq m (point-marker))
      ;;(d-splat (make-string 1 ?\r) "")
      (set-buffer-modified-p nil)
      (d-movement--unpad-buffer)
      (d-movement--pad-buffer)
      ;;(error "smeg")
      (goto-char (marker-position m))
      (set-marker m nil)
      )))

;;(add-hook 'kill-buffer-hook 'd-movement--kill-buffer-hook) ;; save-place-to-alist
;;(add-hook 'kill-emacs-hook 'd-movement--unpad-buffers) ;; save-place-kill-emacs-hook

(defun d-movement--unpad-buffers ()
  (save-excursion
    (let* ((list (buffer-list))
           (ptr  list))
      (while ptr
        (set-buffer (car ptr))
        (if (d-movement--is-correct-mode)
            (d-movement--unpad-buffer))
        (setq ptr (cdr ptr))))))

;;
;; (setq kill-buffer-hook '(save-place-to-alist d-movement--kill-buffer-hook))
;; (add-hook 'kill-buffer-hook 'd-movement--kill-buffer-hook)

(defun d-movement--kill-buffer-hook ()
  (interactive)
  "Not called"
  (if (d-movement--is-correct-mode)
      (let ((m (point-marker)))
        ;;(d-beeps "bufname=%s" (buffer-file-name (current-buffer)))
        ;;(d-foo)
        (d-movement--unpad-buffer)
        (d-splat (make-string 1 ?\r) "")
        (goto-char (marker-position m))
        (set-marker m nil))))

;;(add-hook 'apropos-mode-hook 'd-movement--apropos-mode-hook)
;;(setq apropos-mode-hook 'd-movement--apropos-mode-hook)
;;
;;(defun d-movement--apropos-mode-hook ()
;;  ;;(d-foo)
;;  (message "major-mode=%s" major-mode)
;;  (d-movement--pad-buffer))
;;
(provide 'd-movement-hooks)
