//
// C++ Implementation: generatormap
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <assert.h>

#include "generatormap.h"
#include "textgen.h"
#include "mainoutputbuffer.h"

using namespace std;

GeneratorMap::GeneratorMap() :
  default_generator (0)
{
}

GeneratorMap::~GeneratorMap()
{
  delete default_generator;
}

void
GeneratorMap::setDefaultGenerator(TextGenerator *gen)
{
  assert (! default_generator);

  default_generator = gen;
}

void
GeneratorMap::addGenerator(const std::string &elem, TextGenerator *gen)
{
  generatormap[elem] = gen;
}

TextGenerator *
GeneratorMap::getGenerator(const string &elem)
{
  MapType::const_iterator it = generatormap.find(elem);
  if (it == generatormap.end())
    {
      TextGenerator *missing = missingGenerator(elem);

      generatormap[elem] = missing;
      return missing;
    }

  return it->second;
}

TextGenerator *
GeneratorMap::missingGenerator(const string &elem)
{
  if (! default_generator)
    default_generator = new TextGenerator;

  return default_generator;
}

void
GeneratorMap::generate( const std::string &elem, const std::string &s )
{
  outputbuffer->output(getGenerator(elem)->generate(s.c_str()));
}

void
GeneratorMap::generate( const std::string &elem, const std::string &s, int start, int end )
{
  outputbuffer->output(getGenerator(elem)->generate(s.c_str(), start, end));
}

void
GeneratorMap::generate_preproc(const std::string &elem, const std::string &s)
{
  outputbuffer->output(getGenerator(elem)->generate_preproc(s.c_str()));
}

void
GeneratorMap::generateln( const std::string &elem, const std::string &s )
{
  outputbuffer->output_ln(getGenerator(elem)->generateln(s.c_str()));
}

void
GeneratorMap::generateEntire( const std::string &elem, const std::string &s )
{
  outputbuffer->output(getGenerator(elem)->generateEntire(s.c_str()));
}

void
GeneratorMap::beginText( const std::string &elem, const std::string &s )
{
  outputbuffer->output(getGenerator(elem)->beginText(s.c_str()));
}

void
GeneratorMap::endText( const std::string &elem, const std::string &s )
{
  outputbuffer->output(getGenerator(elem)->endText(s.c_str()));
}

