/*
** Copyright (C) 1999, 2000, 2001 Lorenzo Bettini <bettini@gnu.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*/

// textgen.h : Text Generator class

#ifndef _TEXTGEN_H
#define _TEXTGEN_H

#include <string>
#include "my_sstream.h"

class TextGenerator
{
 private:
   std::ostringstream outstream;
   const std::string pre_tag;
   const std::string post_tag;

 protected:
  void output(const std::string &s);
  void output_ln(const std::string &s = "");
  void output(int i);

 public:
  TextGenerator();
  TextGenerator(const std::string &pre, const std::string &post);
  virtual ~TextGenerator() {}

  virtual std::string generate( const char *s );
  std::string generate( const std::string &s );
  virtual std::string generate( const std::string &s, int start, int end );

  virtual std::string generateln( const char *s );

  virtual std::string generateEntire( const char *s );
  std::string generateEntire( const std::string &s );

  virtual std::string beginText( const char *s );
  virtual std::string endText( const char *s );
  
  std::string beginText( const std::string &s );
  std::string endText( const std::string &s );

  virtual void startTextGeneration();
  virtual void endTextGeneration();

  std::string get_string();
  void reset();
} ;

#endif
