//
// residue.inl
//
// Copyright (C) 1996-7 by Leonard Janke (janke@unixg.ubc.ca)

#include <cassert>
 
ResidueClass ResidueClass::MultiplicativeIdentity() 
{ 
  return ResidueClass(LInteger::One); 
}

const LInteger& ResidueClass::Ring() 
{ 
  return ring; 
}

ResidueClass& ResidueClass::operator=(const ResidueClass& x) 
{
  _principalResidue=x._principalResidue;
}

LInteger ResidueClass::SetRing(const LInteger& newRing) 
{ 
  assert( newRing.IsPositive() );
  LInteger oldRing(ring);
  ring=newRing; 

  return oldRing;
}

ResidueClass& ResidueClass::operator*=(const ResidueClass& x)
{
  _principalResidue*=x._principalResidue;
  _principalResidue%=ring;
  return *this;
}

ResidueClass& ResidueClass::Square()
{
  _principalResidue.Square();
  _principalResidue%=ring;
  return *this;
}

LInteger ResidueClass::ToLInteger() const
{
  return _principalResidue;
}
