//
// sha1prng.cxx
//
// Copyright (C) 1997 by Leonard Janke (janke@unixg.ubc.ca)
//
// expected data generated as follows:
// SHA("abc")=0xA9993E364706816ABA3E25717850C26C9CD0D89D
// Compress(H0...H4,A9993E364706816ABA3E25717850C26C9CD0D89D|(88 zeros))=
// (1) 89D8070B9D9C773869350B180CEA1C231FF94DA4 (Wei Dai Crypto++ 2.0)
// A9993E364706816ABA3E25717850C26C9CD0D89D+
// 89D8070B9D9C773869350B180CEA1C231FF94DA4+1 mod 2^160 =
// 33714541E4A2F8A323733089853ADE8FBCCA2642 (GNU bc)
// Compress(H0...H4,33714541E4A2F8A323733089853ADE8FBCCA2642|(88 zeros))=
// (2) 8ECBAC99C2FDC73F5A86F1E197548427D7850A92 (Wei Dai Crypto++ 2.0)
// 33714541E4A2F8A323733089853ADE8FBCCA2642+
// 8ECBAC99C2FDC73F5A86F1E197548427D7850A92+1 mod 2^160=
// C23CF1DBA7A0BFE27DFA226B1C8F62B7944F30D5 (GNU bc)
// Compress(H0...H4,C23CF1DBA7A0BFE27DFA226B1C8F62B7944F30D5|(88 zeros))=
// (3) DBA46B28A940467549DED6812476CB974DDA0D3A (Wei Dai Crypto++ 2.0)
//
// so the first 60 bytes should be
// 89D8070B9D9C773869350B180CEA1C231FF94DA4
// 8ECBAC99C2FDC73F5A86F1E197548427D7850A92
// DBA46B28A940467549DED6812476CB974DDA0D3A


#include <prng/sha1prng.hxx>
#include <iostream.h>
#include <iomanip.h>
#include <cstring>

void main(int, char**)
{
  cout.setf(ios::uppercase);
  const char* seed="abc";
  u8 block[60];
  u8 exp[60]={
 0x89, 0xD8, 0x07, 0x0B, 0x9D, 0x9C, 0x77, 0x38, 0x69, 0x35, 
 0x0B, 0x18, 0x0C, 0xEA, 0x1C, 0x23, 0x1F, 0xF9, 0x4D, 0xA4,
 0x8E, 0xCB, 0xAC, 0x99, 0xC2, 0xFD, 0xC7, 0x3F, 0x5A, 0x86, 
 0xF1, 0xE1, 0x97, 0x54, 0x84, 0x27, 0xD7, 0x85, 0x0A, 0x92,
 0xDB, 0xA4, 0x6B, 0x28, 0xA9, 0x40, 0x46, 0x75, 0x49, 0xDE, 
 0xD6, 0x81, 0x24, 0x76, 0xCB, 0x97, 0x4D, 0xDA, 0x0D, 0x3A };

  SHA1PRNG prng(seed,strlen(seed));

  prng.NextQuantum(block,15);
  prng.NextQuantum(block+15,15);
  prng.NextQuantum(block+30,15);
  prng.NextQuantum(block+45,15);

  cout <<"first 60 bytes of stream:"<<endl;
  cout <<"0x";
  for (int i=0; i<20; i++)
    cout <<hex<<setw(2)<<setfill('0')<<int(block[i]);
  cout <<endl;

  cout <<"0x";
  for (int i=20; i<40; i++)
    cout <<hex<<setw(2)<<setfill('0')<<int(block[i]);
  cout <<endl;

  cout <<"0x";
  for (int i=40; i<60; i++)
    cout <<hex<<setw(2)<<setfill('0')<<int(block[i]);
  cout <<endl;
  if ( memcmp(exp,block,60) )
    cout <<"*****Failed!*****"<<endl;
  else
    cout <<"*****Passed!*****"<<endl;
}
