/* Diamond/Diamond Lite encryption DLL by Andy Brown 1994 */

#define DERR_ROUNDS    0x01
#define DERR_MEMORY    0x02

#define DIAMOND_FULL	 0x01
#define DIAMOND_LITE	 0x02 

typedef struct tagDIAMONDKEY
{
	int blocksize;     /* Number of bytes in a block. */
	WORD roundsize;		 /* Number of bytes in one round of substitution boxes. */
  WORD numrounds;
	LPBYTE s;          /* Substitution boxes. */
	LPBYTE si;         /* Inverse substitution boxes. */
} DIAMONDKEY;

typedef DIAMONDKEY FAR * LPDIAMONDKEY;

UINT FAR PASCAL set_diamond_key(LPBYTE external_key,WORD key_size,WORD rounds,BOOL invert,LPDIAMONDKEY dmkey,UINT type);
VOID FAR PASCAL diamond_encrypt_block(LPBYTE x,LPBYTE y,LPDIAMONDKEY dmkey);
VOID FAR PASCAL diamond_decrypt_block(LPBYTE x,LPBYTE y,LPDIAMONDKEY dmkey);
VOID FAR PASCAL lite_encrypt_block(LPBYTE x,LPBYTE y,LPDIAMONDKEY dmkey);
VOID FAR PASCAL lite_decrypt_block(LPBYTE x,LPBYTE y,LPDIAMONDKEY dmkey);
VOID FAR PASCAL diamond_done(LPDIAMONDKEY dmkey);
