/*
 * (C)opyright 1993,1994,1995 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 */
#include <stdio.h>
#include <string.h>
#if !defined(__SVR4) && !defined(__svr4__)
#include <strings.h>
#else
#include <sys/byteorder.h>
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <stdlib.h>
#include <unistd.h>
#include <stddef.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/nameser.h>
#include <arpa/inet.h>
#include <resolv.h>
#include <ctype.h>

#ifndef	lint
static	char	sccsid[] ="@(#)db.c	1.2 12/17/95 (C) 1995 Darren Reed";
#endif

extern	struct	ipopt_names	ionames[], secclass[];
extern	int	opts;


char	*hostnum();
u_short	portnum();

/*
 * returns an ip address as a long var as a result of either a DNS lookup or
 * straight inet_addr() call
 */
char	*hostnum(host)
char	*host;
{
	struct	hostent	*hp;
	struct	netent	*np;
	struct	in_addr	ip;

	if (!strcasecmp("any",host))
		return "0.0.0.0";
	if (isdigit(*host))
		return (host);

	if (!(hp = gethostbyname(host))) {
		if (!(np = getnetbyname(host)))
			return "0.0.0.0";
		memcpy((char *)&ip, (char *)np->n_net, sizeof(ip));
		return inet_ntoa(ip);
	}
	memcpy((char *)&ip, hp->h_addr, sizeof(ip));
	return inet_ntoa(ip);
}


/*
 * find the port number given by the name, either from getservbyname() or
 * straight atoi()
 */
u_short	portnum(name, proto)
char	*name;
char	*proto;
{
	struct	servent	*sp, *sp2;
	u_short	p1 = 0;

	if (isdigit(*name) || !proto)
		return htons((u_short)atoi(name));
	if (strcasecmp(proto, "tcp/udp")) {
		sp = getservbyname(name, proto);
		if (sp)
			return sp->s_port;
		(void) fprintf(stderr, "unknown service \"%s\".\n", name);
		return 0;
	}
	sp = getservbyname(name, "tcp");
	if (sp)
		p1 = sp->s_port;
	sp2 = getservbyname(name, "udp");
	if (!sp || !sp2) {
		(void) fprintf(stderr, "unknown tcp/udp service \"%s\".\n",
			name);
		return 0;
	}
	if (p1 != sp2->s_port) {
		(void) fprintf(stderr, "%s %d/tcp is a different port to ",
			name, p1);
		(void) fprintf(stderr, "%s %d/udp\n", name, sp->s_port);
		return 0;
	}
	return p1;
}
