%{
/*
 * (C)opyright 1995 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 */
#include <stdio.h>
#include <string.h>
#include <sys/param.h>
#include "y.tab.h"
#include "var.h"
#include "misc.h"

#ifndef	lint
static	char	sccsid[] = "@(#)lex.l	1.7 12/17/95 (C) 1995 Darren Reed";
#endif

extern  FILE    *yyin;
#if BSD < 199306
extern	int	yylineno;
extern	char	yytext[];
#else
extern	char	*yytext;
extern	int	lineNum;
#endif

int	state = 0, opened = 0, lineNum = 1;
int	actions = 0, direction = -1, inbrackets = 0;

#ifndef	FP_SEMI
#define	FP_SEMI ';'
#endif

void	synerr(fmt, p1, p2, p3, p4, p5, p6, p7)
char	*fmt, *p1, *p2, *p3, *p4, *p5, *p6, *p7;
{
	fprintf(stderr, "\tline %d: ", lineNum - 6);
	fprintf(stderr, fmt, p1, p2, p3, p4, p5, p6, p7);
}

void	add_state(which)
int	which;
{
	int	prevstate;

	prevstate = (state == FP_POLICY) ? state : 0;
	state = which;
	add_var(opened + inbrackets, direction, state, yytext);
	if (prevstate)
		state = setup_policy(prevstate, state);
}
%}
%%
[ \t]+	;
[\n]	{ lineNum++; }
policy	{ state = FP_POLICY; clear_var(state); return FP_POLICY; }
end-policy { emit_policy(); return FP_ENDPOLICY; }
if     { state = FP_IF; return FP_IF; }
\(      { if (state != FP_IF)
		synerr("missing if\n");
	  else {
		inbrackets = 1;
		state = FP_OPENBRACK;
	  }
	  return FP_OPENBRACK;
	}
\)      { if (state == FP_OPENBRACK)
		synerr("warning: empty expression\n");
	  state = FP_CLOSEBRACK;
	  inbrackets = 0;
	  return FP_CLOSEBRACK;
	}
\{      {
	  state = FP_OPENBRACE;
	  opened++;
	  return FP_OPENBRACE;
	}
\}      {
	  if (!opened)
		synerr("too many close braces\n");
	  else {
		printrule(opened);
		del_lvl(opened);
		opened--;
		if (!opened)
			state = 0;
	  }
	  return FP_CLOSEBRACE;
	}
then    { if (state != FP_CLOSEBRACK)
		synerr("missing close bracket\n");
	  else
		state = FP_THEN;
	  return FP_THEN;
	}
block |
deny |
reject |
drop	{ add_state(FP_BLOCK); return FP_BLOCK; }
pass |
accept |
permit	{ add_state(FP_PASS); return FP_PASS; }
body	{ add_state(FP_BODY); return FP_BODY; }
log	{ add_state(FP_LOG); return FP_LOG; }
netmask	{ state = FP_NETMASK; return FP_NETMASK; }
set	{ state = FP_SET; return FP_SET; }
all	{ if (state != FP_POLICY) state = FP_ALL; return FP_ALL; }
established { state = FP_ESTABLISHED;
		add_var(opened + inbrackets, direction, state, yytext);
	  return FP_ESTABLISHED;
	}
opening	{ state = FP_OPENING, state;
		add_var(opened + inbrackets, direction, state, yytext);
	  return FP_OPENING;
	}
flags	{ state = FP_FLAGS; return FP_FLAGS; }
protocol { state = FP_PROTOCOL; clear_var(state); return FP_PROTOCOL; }
interface { state = FP_INTERFACE; clear_var(state); return FP_INTERFACE; }
access-list { state = FP_ACCESSLIST; clear_var(state); return FP_ACCESSLIST; }
in	{ add_state(FP_IN); return FP_IN; }
out	{ add_state(FP_OUT); return FP_OUT; }
inbound	{ add_state(FP_INBOUND); return FP_INBOUND; }
outbound { add_state(FP_OUTBOUND); return FP_OUTBOUND; }
on	{ state = FP_ON; return FP_ON; }
proto	{ state = FP_PROTO; return FP_PROTO; }
from	{ direction = 1; state = FP_FROM; return FP_FROM; }
to	{ direction = 2; state = FP_TO; return FP_TO; }
port	{ state = FP_PORT; return FP_PORT; }
host	{ state = FP_HOST; return FP_HOST; }
net	{ state = FP_NET; return FP_NET; }
mask	{ state = FP_MASK; return FP_MASK; }
"&&" |
and	{ state = FP_AND; return FP_AND; }
opt	{ state = FP_OPT; return FP_OPT; }
frag	{ state = FP_FRAG;
	  add_var(opened + inbrackets, direction, state, yytext);
	  return FP_FRAG;
	}
short	{ state = FP_SHORT;
	  add_var(opened + inbrackets, direction, state, yytext);
	  return FP_SHORT;
	}
ipopts	{ state = FP_IPOPTS;
	  add_var(opened + inbrackets, direction, state, yytext);
	  return FP_SHORT;
	}
sec-level { state = FP_SECCLASS; return FP_SECCLASS; }
\;	{ state = FP_SEMI; return FP_SEMI; }
\.	{ state = FP_STOP; return FP_STOP; }
"<>"	{ state = FP_OUTSIDE; return FP_OUTSIDE; }
"><"	{ state = FP_INSIDE; return FP_INSIDE; }
"!=" |
">=" |
"<=" |
ne |
eq |
gt |
lt |
le |
ge	{ state = FP_PORTCMP;
	  add_var(opened + inbrackets, direction, state, yytext);
	  return FP_PORTCMP;
	}
[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+ |
[-a-zA-Z0-9_]+ {
	switch (state)
	{
	case FP_INTERFACE :
		add_var(opened, direction, state, yytext);
		state = FP_TOKEN;
		break;
	case FP_ACCESSLIST :
		add_var(opened, direction, state, yytext);
		state = FP_TOKEN;
		break;
	case FP_ON :
		printf("on interface %s\n", yytext);
		add_var(opened + inbrackets, direction, state, yytext);
		state = FP_TOKEN;
		break;
	case FP_PROTOCOL :
		state = setup_policy(FP_TOKEN, state);
		add_var(opened + inbrackets, direction, FP_PROTO, yytext);
		break;
	case FP_PROTO :
		add_var(opened + inbrackets, direction, state, yytext);
		state = FP_TOKEN;
		break;
	case FP_TO :
	case FP_FROM :
		state = FP_HOST;
	case FP_HOST :
		if (direction < 0) {
			printf("no direction given!\n");
			state = FP_TOKEN;
			break;
		}
		add_var(opened + inbrackets, direction, state, yytext);
		state = FP_TOKEN;
		break;
	case FP_NET :
		if (direction < 0) {
			printf("no direction given!\n");
			state = FP_TOKEN;
			break;
		}
		add_var(opened + inbrackets, direction, state, yytext);
		state = FP_TOKEN;
		break;
	case FP_MASK :
		if (direction < 0) {
			printf("no direction given!\n");
			state = FP_TOKEN;
			break;
		}
		add_var(opened + inbrackets, direction, state, yytext);
		state = FP_TOKEN;
		break;
	case FP_NETMASK :
		add_var(opened + inbrackets, direction, state, yytext);
		state = FP_TOKEN;
		break;
	case FP_PORT :
		if (direction < 0)
			direction = 0;
		add_var(opened + inbrackets, direction, state, yytext);
		state = FP_TOKEN;
		break;
	case FP_PORTCMP :
		if (direction < 0) {
			printf("no direction given!\n");
			state = FP_TOKEN;
			break;
		}
		add_var(opened + inbrackets, direction, FP_PORT, yytext);
		state = FP_TOKEN;
		break;
	case FP_OUTSIDE :
		if (direction < 0) {
			printf("no direction given!\n");
			state = FP_TOKEN;
			break;
		}
		direction = 2;
		add_var(opened + inbrackets, direction, state, yytext);
		state = FP_TOKEN;
		break;
	case FP_INSIDE :
		if (direction < 0) {
			printf("no direction given!\n");
			state = FP_TOKEN;
			break;
		}
		direction = 2;
		add_var(opened + inbrackets, direction, state, yytext);
		state = FP_TOKEN;
		break;
	case FP_FLAGS :
		add_var(opened + inbrackets, direction, state, yytext);
		state = FP_TOKEN;
		break;
	case FP_SECCLASS :
		add_var(opened + inbrackets, direction, state, yytext);
		state = FP_TOKEN;
	case FP_OPT :
		add_var(opened + inbrackets, direction, state, yytext);
		state = FP_TOKEN;
		break;
	default :
#if BSD < 199306
		printf("unrecognised token (%s@%d), line %d\n",
			yytext, state, yylineno - 6);
#else
		printf("unrecognised token (%s@%d), line %d\n",
			yytext, state, lineNum);
#endif
		return 0;
	}
	return FP_TOKEN;
}
