/*
     fc - Filter compiler software for the Drawbridge package
     Copyright (C) 1993 David K. Hess, Douglas Lee Schales, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.
*/
#include <sys/types.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/socket.h>
#include <errno.h>
#include "chario.h"
#include "services.h"
#include "hosts.h"
#include "groups.h"
#include "classes.h"

int parse_error = 0;

extern void perror(char *);
extern int yyparse(void);

void
showcopyright(void)
{
     fprintf(stdout, "\
Drawbridge Filter Compiler version 1.0 Beta,\n\
Copyright (C) 1993, David K. Hess, Douglas Lee Schales, David R. Safford\n\
Drawbridge Filter Compiler comes with ABSOLUTELY NO WARRANTY.\n\
");
}

extern int optind;
extern char *optarg;

int
main(int argc, char **argv)
{
     int status;
     int byteswap = 0;
     int c;

     while((c=getopt(argc, argv, "bc")) != -1)
	  switch(c){
	  case 'b':
	       byteswap = 1;
	       break;
	  case 'c':
	       showcopyright();
	       break;
	  default:
	       exit(1);
	  }

     if(!argv[optind]){
	  fprintf(stderr, "Usage: %s [-b] [-c] config-file\n", argv[0]);
	  exit(1);
     }

     if(addfile(argv[optind]) != NOERR){
	  perror(argv[optind]);
	  exit(1);
     }

     init_services();
     init_groups();
     init_hosts();

     yyparse();

     if(!parse_error){
	  writehosttables(byteswap);
	  writeclasses(byteswap);
	  status = 0;
     }
     else
	  status = 1;

     exit(status);

     return status;
}

int
yyerror(void)
{
     parse_error = 1;
}
