/* markList.c
   routines to manage the bookmark list of gopher items. */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.2     20 November 1991               */
     /*                version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#include <stdio.h>

#include "gopher.h"
#include "itemList.h"

static gopherItemList	bookmarks = {NULL, NULL};

/* These routines are simply an interface to the gopher item list
   management routines in itemList.c. */

/* bookmark list interface routines:

	markItem	Set a bookmark at an item.
	unmarkItem	Remove a bookmarked item.
	unmarkItemN	Remove the Nth bookmarked item.
	unmarkAllItems	Remove all bookmarks
	getMarkN 	Return a ptr to Nth bookmarked item 
	anyMarks	Report if the bookmark list is empty as T/F 
	firstMark	Return a pointer to the head of the bookmark list
	markListLength	return the number of items in the bookmark list

*/


/* markItem
	Set a bookmark at an item. */

void
markItem(gi)
gopherItemP	gi;
{
	if (gi == NULL) return;

	if (! itemInList(&bookmarks, gi)) appendItem(&bookmarks, gi);

	return;
}


/* getMarkN 
	return a pointer to the Nth item of the bookmark list
	starting with number 0 */

gopherItemP
getMarkN(n)
int		n;
{
	return getItemN(&bookmarks, n);
}


/* unmarkItem
	Remove a bookmarked item. */

void
unmarkItem(gi)
gopherItemP	gi;
{
	if (gi == NULL) return;

	removeItem(&bookmarks, gi);
}


/* unmarkItemN
	Remove the Nth bookmarked item. */

void
unmarkItemN(n)
int	n;
{
	if (n < 0) return;

	removeItemN(&bookmarks, n);
}


/* unmarkAllItems
	Remove all bookmarks */

void
unmarkAllItems()
{
	gopherItemP	p;

	while ((p = bookmarks.first) != NULL) {
		unmarkItem(p);
	}
}


/* anyMarks
	Report if the bookmark list is empty as T/F */

BOOLEAN
anyMarks()
{
	return (bookmarks.first != NULL);
}


/* firstMark
	Return a pointer to the head of the bookmark list */

gopherItemP
firstMark()
{
	return bookmarks.first;
}


/* markListLength
	return the number of items in the bookmark list */

int
markListLength()
{
	return itemListLength(&bookmarks);
}
