/*
     etherscan - A real time network security monitor
     Copyright (C) 1993 Douglas Lee Schales, David K. Hess, David R. Safford

     Please see the file `RESTRICTIONS' for the complete copyright notice.

rlogin.c - 05/23/93

*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <ctype.h>
#include <sys/time.h>
#include <math.h>

extern float microsec(struct timeval);
extern struct timeval subtime(struct timeval, struct timeval);
extern struct timeval addtime(struct timeval, struct timeval);

struct ipaddr {
     unsigned int addr:32;
};

struct rlogin_sess {
     struct rlogin_sess *next;
     struct rlogin_sess *prev;
     struct in_addr srcaddr;
     struct in_addr dstaddr;
     struct timeval tlp;
     unsigned short srcport;
     char buffer[1024];
     int bufptr;
     char remusername[80];
     char locusername[80];
     int state;
     int linecnt;
#define RLOGIN_INIT 0
#define RLOGIN_REMUSER 1
#define RLOGIN_LOCUSER 2
#define RLOGIN_ACTIVE 3
};

static void
checksession(struct rlogin_sess *sp)
{
#include "lognames.h"
     if(strcmp(sp->locusername, "root") == 0){
	  outtime(sp->tlp);
	  printf(" [rlogin] ");
	  outhost(sp->srcaddr);
	  printf(".%d", sp->srcport);
	  outhost(sp->dstaddr);
	  printf(" ROOT login (%s)\n", sp->remusername);
	  fflush(stdout);
     }
     else if(strcmp(sp->locusername, "bd") == 0){
	  outtime(sp->tlp);
	  printf(" [rlogin] ");
	  outhost(sp->srcaddr);
	  printf(".%d", sp->srcport);
	  outhost(sp->dstaddr);
	  printf(" Backdoor login (%s)\n", sp->remusername);
	  fflush(stdout);
     }
     else if(strcmp(sp->locusername, "me") == 0){
	  outtime(sp->tlp);
	  printf(" [rlogin] ");
	  outhost(sp->srcaddr);
	  printf(".%d", sp->srcport);
	  outhost(sp->dstaddr);
	  printf(" 'ME' login (%s)\n", sp->remusername);
	  fflush(stdout);
     }
     else {
	  int i;

	  for(i=0;names[i];i++)
	       if(strcasecmp(names[i], sp->locusername) == 0)
		    break;
	  if(names[i]){
	       outtime(sp->tlp);
	       printf(" [rlogin] ");
	       outhost(sp->srcaddr);
	       printf(".%d", sp->srcport);
	       outhost(sp->dstaddr);
	       printf(" attempted login as `%s' (from `%s')\n",
		      sp->locusername, sp->remusername);
	       fflush(stdout);
	  }
     }
}

static void
checkbuffer(struct rlogin_sess *sp)
{
     switch(sp->state){
     case RLOGIN_REMUSER:
	  strncpy(sp->remusername, sp->buffer, 16);
	  sp->state = RLOGIN_LOCUSER;
	  break;
     case RLOGIN_LOCUSER:
	  strncpy(sp->locusername, sp->buffer, 16);
	  checksession(sp);
	  sp->state = RLOGIN_ACTIVE;
	  break;
     case RLOGIN_ACTIVE:
	  sp->linecnt++;
	  break;
     default:
	  /* ehh?? */
	  break;
     }
}

static struct rlogin_sess *head = (struct rlogin_sess *)0;

rlogin_dump(struct ip *ip, struct tcphdr *tcp, struct timeval timebuf)
{
     struct rlogin_sess *rove;
     struct rlogin_sess *next, *prev;
     struct timeval delta;

     for(rove = head;rove;rove=rove->next){
	  if(memcmp((char *)&ip->ip_dst.s_addr,(char *)&rove->dstaddr,4)==0 &&
	     memcmp((char *)&ip->ip_src.s_addr,(char *)&rove->srcaddr,4)==0 &&
	     memcmp((char *)&tcp->th_sport,(char *)&rove->srcport,2) == 0){
	       break;
	  }
     }
     if(!rove && (tcp->th_flags & (TH_RST|TH_FIN)))
	  return;
     if(!rove && ((tcp->th_flags & (TH_SYN|TH_ACK)) == TH_SYN)){
	  rove = (struct rlogin_sess *)malloc(sizeof(struct rlogin_sess));
	  memcpy((char *)&rove->dstaddr.s_addr,(char *)&ip->ip_dst, 4);
	  memcpy((char *)&rove->srcaddr.s_addr,(char *)&ip->ip_src, 4);
	  memcpy((char *)&rove->srcport,(char *)&tcp->th_sport, 2);
	  rove->bufptr = 0;
	  rove->state = RLOGIN_INIT;
	  rove->linecnt = rove->bufptr = 0;
	  rove->remusername[0] = rove->locusername[0] = 0;
	  rove->next = head;
	  rove->prev = (struct rlogin_sess *)0;
	  if(head)
	       head->prev = rove;
	  head = rove;
     }

     if(!rove)
	  return;
     rove->tlp = timebuf;

     if(!(tcp->th_flags & ~(TH_PUSH|TH_ACK))){
	  unsigned char offset;
	  int len;
	  char *bp;
	  int i;
	  char *offp;
	  char off;

	  offp = ((char *)&tcp->th_ack)+4;
	  memcpy(&off, offp, 1);
          offset = (off & 0xf0) >> 2;

	  len = ip->ip_len - offset - sizeof(struct ip);
	  bp = ((char *)tcp)+offset;

	  for(i=0;i<len;i++){
	       if(rove->state == RLOGIN_INIT){
		    if(bp[i] == 0)
			 rove->state = RLOGIN_REMUSER;
	       }
	       else if(rove->state != RLOGIN_ACTIVE){
		    if(!bp[i]){
			 rove->buffer[rove->bufptr] = 0;
			 rove->tlp = timebuf;
			 checkbuffer(rove);
			 rove->bufptr = 0;
		    }
		    else if(rove->bufptr < 1023)
			 rove->buffer[rove->bufptr++] = bp[i];
	       }
	       else if(bp[i] == '\n' || bp[i] == '\r'){
		    if(i+1 != len && bp[i+1] == '\n' || bp[i+1] == '\r')
			 i++;
		    rove->buffer[rove->bufptr] = 0;
		    rove->tlp = timebuf;
		    checkbuffer(rove);
		    rove->bufptr = 0;
	       }
	       else if((rove->bufptr < 1023) && bp[i])
		    rove->buffer[rove->bufptr++] = bp[i];
	  }
     }
     else if(tcp->th_flags & TH_RST ||
	     tcp->th_flags & TH_FIN){

	  if(rove == head)
	       head = rove->next;
	  if(rove->prev)
	       rove->prev->next = rove->next;
	  if(rove->next)
	       rove->next->prev = rove->prev;
	  free(rove);
     }
     
     next = head;

     while(next){
	  if(timebuf.tv_sec - next->tlp.tv_sec > 60){
	       struct rlogin_sess *nextnext = next->next;
	       
	       if(next == head)
		    head = next->next;
	       if(next->prev)
		    next->prev->next = next->next;
	       if(next->next)
		    next->next->prev = next->prev;
	       free(next);
	       next = nextnext;
	  }
	  else {
	       next = next->next;
	  }
     }
}
