#define const
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <rpc/rpc.h>
#include <netinet/udp.h>
#include <ctype.h>
#include <sys/time.h>
#include <errno.h>
#include <rpc/pmap_prot.h>
#ifdef SOLARIS
#include <rpc/rpcent.h>
#endif

void
checkrpc(struct ip *ip, struct udphdr *udp, struct timeval timebuf)
{
     char *filename;
     unsigned long prog, vers, proc;
     unsigned long lookup;
     int i;
     struct in_addr addr;
     unsigned int length;
     char c;
     unsigned short port;
     struct rpcent *rpcp;
     char *name = (char *)0;


     char *data = (char *)udp + sizeof(struct udphdr);
     struct call_body *rpcbody = (struct call_body *)(data+8);
     char *msgdata = (char *)rpcbody + sizeof(struct call_body);

     msgdata -= 8;
     memcpy((char *)&port, (char *)&udp->uh_dport, 2);

     if(port == 111){

	  memcpy((char *)&prog, (char *)&rpcbody->cb_prog, 4);
	  memcpy((char *)&vers, (char *)&rpcbody->cb_vers, 4);
	  memcpy((char *)&proc, (char *)&rpcbody->cb_proc, 4);

	  switch(proc){
	  case PMAPPROC_GETPORT:
	       outtime(timebuf);
	       printf(" [rpc] ");
	       memcpy((char *)&addr.s_addr, (char *)&ip->ip_src, 4);
	       outhost(addr);
	       memcpy((char *)&port, (char *)&udp->uh_sport, 2);
	       printf(".%d", port);
	       memcpy((char *)&addr.s_addr, (char *)&ip->ip_dst, 4);
	       outhost(addr);
	       printf(" RPC lookup for: ");

	       memcpy((char *)&lookup, msgdata, 4);
	       if(rpcp = getrpcbynumber(lookup)){
		    printf("%s\n", rpcp->r_name);
	       }
	       else
		    printf("%06d\n", lookup);
	       fflush(stdout);
	       break;
	  case PMAPPROC_DUMP:
	       outtime(timebuf);
	       printf(" [rpc] ");
	       memcpy((char *)&addr.s_addr, (char *)&ip->ip_src, 4);
	       outhost(addr);
	       memcpy((char *)&port, (char *)&udp->uh_sport, 2);
	       printf(".%d", port);
	       memcpy((char *)&addr.s_addr, (char *)&ip->ip_dst, 4);
	       outhost(addr);
	       printf(" RPC info probe.\n");
	       fflush(stdout);
	       break;
	  }
     }
}
