%***************************************************************************
%  FILE = algebra.red 				Mon Nov  7 16:45:26 EST 1988
% 
%  Procedures in this file:
%  
%  EVALTNSR EVALTNSR1 PROCESSVALUE PREPROCESS UNSAVE MERGECMP 
%  CONTRACT MAPINDEX CONPROD GETCONSYM FCNV EVAL1 EVAL2
%  SIMPEVALC COLLECTERMS COLLECTERMS1 CHKCONCOV 
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);

FLUID '(ACONCOV FLGCON TNSR NOTCON VALUE BACKVALUE COORDS);
GLOBAL '(ALPHALIST!* !*REWRITE !*EXTENDEDSUM);
!*EXTENDEDSUM := 'NIL;
NOTCON := 'NIL;		% if contract is called from places not below evaltnsr1

% evaltnsr is called from equalparse to set up the evaluation of an
% indexed expression and its assignment to an indexed object.
% index will never be an integer index, this case is handled by calling
% evaltnsr1 directly from equalparse.

SYMBOLIC PROCEDURE EVALTNSR (TNSR, INDEX, VALUE);
BEGIN;
  SETK ('BACKVALUE, AEVAL (VALUE := REVAL (VALUE)));	% copy value to backup
  IF !*REWRITE THEN				% pretty-print input value
    <<
        TERPRI ();
        IF NOT INDEX THEN PRIN2!* (TNSR)		% lhs a scalar
        ELSE PRINTRDR (LIST (TNSR, INDEX));		% lhs an indexed object
        PRIN2!* (" = ");
        MAPRINT (VALUE, 0);				% rhs
        TERPRI!* ('T)
    >>;
  VALUE := EVALTNSR1 (TNSR, INDEX, VALUE, 'T);	% evaluate input
  CLEARTMP ();					% clean trash
  IF INDEX THEN RETURN (SIMP (LIST ('RDR, TNSR, INDEX))) % indexed obj output
  ELSE IF INDEXED (TNSR) THEN 
      RETURN (SIMP (MK!*SQ (WRITETNSR (TNSR, 'NIL, VALUE, 'NIL)))) % indexed scalar
  ELSE RETURN (SIMP (SETK (TNSR, MK!*SQ (VALUE))));	% scalar output
END;

GLOBAL '(BACKTNSR OUTPUT!* !*FLGDOT);
FLUID '(ALGLIST!*);
!*FLGDOT := 'NIL;		% user flag to print indices all the time

% evaltnsr1 is the primitive routine that processes the input value and
% evaluates it; assigning it to either a scalar or an indexed object as
% required. inputs are the output object name, its index ('nil for a 
% scalar), and a flag to indicate that the progress of the calculation
% is to be shown by printing indices as each element is computed.

SYMBOLIC PROCEDURE EVALTNSR1 (TNSR, INDEX, VALUE, FLGDOT);
BEGIN SCALAR NOTCON, INDEXOUT, CONCOV, ACONCOV, LEX, LEX1, LEX2, PINDEX,
             LINELNGTH;

  FLGDOT := FLGDOT OR !*FLGDOT;		% print indices ?
  IF INDEXED (TNSR) AND ISPROTECT (TNSR, 2) THEN <<
    MERROR (LIST (TNSR, "is write-protected"), 'NIL, 'EVALTNSR1);
    RETURN (TNSR)			% can't write to protected object
  >>;
  LEX1 := CONTRACT (INDEX, 'NIL);  % look for apparent contractions in output
  LEX := APPEND (MYCAR (LEX1), MYCADR (LEX1)); % these indicate diagonal writes
  NOTCON := MYCADR (LEX1);   % indices NOT involved in contractions if repeated
  SETLIS (ALPHALIST!*, ALPHALIST!*);	% clear the alphalist* and ..
	% set up the connections between its elements and the input index
  PINDEX := PAIR (LEX, LEX1 := HEAD (ALPHALIST!*, LENGTH (LEX)));
    		% call the preprocessor and the processor to format the value.
  VALUE := PROCESSVALUE (PREPROCESS (VALUE, INDEX), PINDEX, 'NIL);
  IF NOT INDEX THEN <<
    IF FLGDOT THEN <<PRINC ("*"); TERPRI()>>;	% show user we've begun.
    RETURN (SIMP (VALUE))	% scalar output
  >>;
  CONCOV := FOR EACH X IN INDEX
          COLLECT (MYCDR (ASSOC (X, ACONCOV)) OR -1);
  IF NOT ACONCOV THEN				% must make object accordingly
     CONCOV := GET (TNSR, 'CONCOV) OR CONCOV;
  IF NOT INDEXED (TNSR) THEN
     TNSR := MKTNSR!* (TNSR, CONCOV, GET (TNSR, 'SYMMETRY), 'NIL, 'NIL)
  ELSE IF NOT GET (TNSR, 'CONCOV) = CONCOV THEN % expression structure does ..
    MERROR ('("indices do not match"), 'NIL, 'EVALTNSR1)  % not match objects
  ELSE PUT ('BACKTNSR, 'TVALUE, GET (TNSR, 'TVALUE)); % save current value
					% write a single element of the object
  IF INTINDEX (LEX) THEN WRITETNSR (TNSR, LEX, SIMP (VALUE), 'NIL)
  ELSE <<			% arbitrary index, we are writing many elements
    IF VALUE = 0 AND FLGDOT THEN 	% we are writing zeroes, let user ..
        <<PRINC (0); TERPRI()>>;	% know the expression went to 0
    IF NOT MYCAR (GET (TNSR, 'MULTIPLIER)) = 1 THEN  % divide by multiplier
      VALUE := LIST ('QUOTIENT, VALUE, MK!*SQ (GET (TNSR, 'MULTIPLIER)));

       % output indices for the object, derived from its symmetries.
    INDEXOUT := IGEN (LEX, CONCOV, GET (TNSR, 'SYMMETRY));
    INDEX := MAPINDEX (INDEX, PINDEX, 'NIL);
    OUTPUT!* := 'NIL;		% global output list stores the elements
    LINELNGTH := LINELENGTH (100000);
    WHILE INDEXOUT DO <<	% for each element possible
      SETLIS (LEX1, MYCAR (INDEXOUT));	% link to integer index
      INDEXOUT := MYCDR (INDEXOUT);
      IF FLGDOT THEN <<
         PRIN2 ("
"); PRIN1 (MAPCAR (INDEX, 'EVAL));
                FLUSHSTDOUTPUTBUFFER ()>>;
      OUTPUT!* := (MAPCAR (INDEX, 'EVAL) . SIMP!* (VALUE)) . OUTPUT!*;
      UNSAVE() 		% delete saved expressions
    >>;
    LINELENGTH (LINELNGTH);
       % merge the above value list with one already there
    PUT (TNSR, 'TVALUE, MERGECMP (REVERSE (OUTPUT!*), TNSR))
  >>;
  SETLIS (ALPHALIST!*, ALPHALIST!*);	% clear
  RETURN (TNSR);
END;

FLUID '(NINDEX  NCONCOV);	% to store things in from below

% processvalue is the routine which translates an indexed expression into
% a form that can be evaluated easily. essentially, it replaces each indexed
% object with a similar form (the 'rdr becomes 'readtnsr)
% the actual algebraic evaluation is handled by the Reduce system.

SYMBOLIC PROCEDURE PROCESSVALUE (VALUE, INDEX, INDEXC);
BEGIN SCALAR LEX, LEX1, LEX2, NINDEX, NCONCOV, LEX4, INDEXO;
  IF ATOM (VALUE) OR CHECKTYPE (VALUE, '!*SQ) OR	% dont touch
     FREE1 (VALUE, 'RDR) THEN RETURN (VALUE)
  ELSE IF CHECKTYPE (VALUE, 'RDR) THEN <<	% indexed object
    IF (LEX := GET (MYCADR (VALUE), 'COORDS)) AND NOT COORDS = LEX THEN
      MERROR (LIST ("unmatched coordinates:", LEX, ",", VALUE),
              'NIL, 'PROCESSVALUE);	% warning error
					% look for internal contractions
    LEX := CONTRACT (MYCADDR (VALUE), GET (MYCADR (VALUE), 'CONCOV));
    CHKCONCOV (MYCAR (LEX), MYCADDR (LEX), INDEXC, VALUE);
    IF NOT GET (MYCADR (VALUE), 'TVALUE) AND NOT	% replace empty object by 0
       GET (MYCADR (VALUE), 'IMPLICIT) AND 	% (subject to constraints)
       NOT MYCDR (GET (MYCADR (VALUE), 'CONJUGATE)) AND 
       NOT INDEXED (MYCADR (VALUE)) EQ 'SCALAR THEN RETURN (0);
    IF MYCADR (LEX) THEN <<		% there is an internal contraction
      LEX4 := MAPINDEX (MYCADDR (VALUE), APPEND (INDEX, PAIR (MYCADR (LEX),
              (LEX2 := HEAD (PNTH (ALPHALIST!*, LENGTH (INDEX) 
                  + LENGTH (INDEXC) + 1), LENGTH (MYCADR (LEX)))))),
              VALUE);
      RETURN (CONPROD (LIST ('EVALC, MYCADR (VALUE), LEX4), LEX2,
                LIST (MYCADR (LEX), MYCADDDR (LEX))))
    >> ELSE <<				% no internal contraction
       					% map index and check for free indicies
      LEX4 := MAPINDEX (MYCADDR (VALUE), INDEX, VALUE);
      RETURN (LIST ('EVALC, MYCADR (VALUE), LEX4)) % replace 'rdr with 'evalc
    >>
  >>				% expression is either a product or a 'df form
  ELSE IF CHECKTYPE (VALUE, 'TIMES) OR CHECKTYPE (VALUE, 'DF)
%      AND INDEXED (MYCADR (MYCADDR (VALUE))) THEN <<
       THEN <<
    COLLECTERMS (MYCDR (VALUE));    % net index structure in nindex & nconcov
    LEX := CONTRACT (NINDEX, NCONCOV);		% contractions among objects
    CHKCONCOV (MYCAR (LEX), MYCADDR (LEX), INDEXC, VALUE);
    LEX4 := HEAD (PNTH (ALPHALIST!*, LENGTH (INDEX) + LENGTH (INDEXC) + 1),
                   LENGTH (MYCADR (LEX)));
    LEX1:= MYCADR (LEX);
    LEX2:='NIL;
    WHILE LEX1 DO <<
      IF NOT ASSOC (MYCAR (LEX1), INDEX) THEN <<
        INDEX := APPEND (INDEX, LIST (MYCAR (LEX1) . MYCAR (LEX4)));
        INDEXC := APPEND (INDEXC, LIST (MYCAR (LEX1)));
        LEX2 := MYCAR (LEX4) . LEX2
      >>;
      LEX4:= MYCDR (LEX4);
      LEX1:= MYCDR (LEX1)
    >>;
 				% recursively look into form
    VALUE := FOR EACH X IN VALUE COLLECT PROCESSVALUE (X, INDEX, INDEXC);
    IF LEX2 THEN
      RETURN (CONPROD (VALUE, REVERSE (LEX2),
                LIST (MYCADR (LEX), MYCADDDR (LEX))))
    ELSE RETURN (VALUE)
  >>
  ELSE RETURN (FOR EACH X IN VALUE COLLECT PROCESSVALUE (X, INDEX, INDEXC));
END;

% preprocess handles various unevaled functions and operators in an 
% expression. the required actions are taken and the results are placed
% into the expression. these operations include derivatives, shifts operators,
% and symmetrization operations. also, tracesym is called to try to find
% places where trace symmetries can be used to speed the evaluation.

SYMBOLIC PROCEDURE PREPROCESS (VALUE, INDEX);
BEGIN SCALAR LEX;
  IF ATOM (VALUE) OR CHECKTYPE (VALUE, '!*SQ) THEN RETURN (VALUE); % dont touch
  IF CHECKTYPE (VALUE, 'PDF) THEN <<    % partial derivative operator
    LEX := MKCOORDS (TMPNAMES (), 'NIL);
    PUT (LEX, 'CONCOV, '(-1));
    VALUE := APPEND (LIST ('DF, MYCADR (VALUE)),
                FOR EACH X IN MYCDR (MYCDADDR (VALUE)) 
                     COLLECT LIST ('RDR, LEX, LIST (X)))
  >>;
  IF CHECKTYPE (VALUE, 'RDR) THEN <<	% indexed object
    VALUE := MYCDR (VALUE);
    %    REMPROP (TNSR, 'AVALUE);   % do we want this???
    VALUE := SHIFT!* ('RDR . VALUE, 'NIL);	% any last shifts ..
    IF MYCADDDR (VALUE) THEN 
       RETURN (FOR EACH X IN SYMINDEX (VALUE) COLLECT PREPROCESS (X, INDEX));
    ELSE IF DERIV (MYCADDR (VALUE), 'NIL) THEN		% derivatives
      RETURN (IDIFF (MYCADR (VALUE), '!#BR . MYCADDR (VALUE)));
    ELSE RETURN (VALUE)
  >>
  ELSE IF NOT FREE1 (VALUE, 'RDR) THEN <<
    VALUE := FOR EACH X IN VALUE COLLECT PREPROCESS (X, INDEX);
    IF CHECKTYPE (VALUE, 'TIMES) OR CHECKTYPE (VALUE, 'DF) THEN <<
      IF MEMQ (0, VALUE) THEN RETURN (0)	% a zero inside ==> all 0
      ELSE RETURN (TRACESYM (VALUE))	% look for trace sym's
    >>
    ELSE RETURN (VALUE)
  >>
  ELSE RETURN (VALUE);
END;

% unsave removes expressions saved by simp* from the alglist* assoc
% list. only those expressions containing an 'evalc are removed.

SYMBOLIC PROCEDURE UNSAVE();
BEGIN SCALAR LEX, LIS;
  LEX := ALGLIST!*;		% assoc list of expressions and simp'ed forms
  WHILE LEX DO <<
    IF FREE1 (MYCAR (LEX), 'EVALC) THEN LIS := MYCAR (LEX) . LIS;  % keep it
    LEX := MYCDR (LEX)
  >>;
  ALGLIST!* := LIS;
END;

% mergecmp combines the 'tvalue assoc lists generated by evaltnsr1 and
% already on the object into a replacement 'tvalue list. elements of ex1
% will overwrite ones from ex2 if they have a common index.

SYMBOLIC PROCEDURE MERGECMP (EX1, TNSR);
BEGIN SCALAR EX2, LIS;
  EX2 := GET (TNSR, 'TVALUE);		% get current tvalue
  IF EX1 = EX2 THEN RETURN (EX1);	% no change
  WHILE EX1 DO <<			% new elements to be added
    IF MYCAAR (EX1) = MYCAAR (EX2) THEN <<	% same index, overwrite
      IF (MYCADAR (EX1) OR GET (TNSR, 'IMPLICIT)) THEN  % also write 0 if imp. 
        LIS := MYCAR (EX1) . LIS;
      EX1 := MYCDR (EX1);
      EX2 := MYCDR (EX2)
    >>  				% place elements in order
    ELSE IF ORDERINDEX (MYCAAR (EX1), MYCAAR (EX2)) THEN <<
      IF (MYCADAR (EX1) OR GET (TNSR, 'IMPLICIT)) THEN 
        LIS := MYCAR (EX1) . LIS;
      EX1 := MYCDR (EX1)
    >> ELSE <<
      LIS := MYCAR (EX2) . LIS;
      EX2 := MYCDR (EX2)
    >>
  >>;
  RETURN (APPEND (REVERSE (LIS), EX2));
END;

% contract recieves an index and a corresponding concov list and returns
% a list of four lists: uncontracted indices, contracted indices, an
% uncontracted concov list, and a contracted concov list. the contracted
% lists represent those indices and their concov values which are involved
% in a contraction operation, the other two lists contain everything but
% these. eg. ((a b a c)(1 1 -1 -1)) --> ((b c)(a)(1 -1)(1))
% note: the signs of the elements in the last list are irrelevant.

SYMBOLIC PROCEDURE CONTRACT (INDEX, CONCOV);
BEGIN SCALAR LEX1, LEX2, LEX3, LEX4, LEX5, I;

  IF INTINDEX (INDEX) THEN RETURN (LIST (INDEX, 'NIL, CONCOV, 'NIL));
  LEX5 := INDEX; 		% a copy of the index for error output

  WHILE INDEX DO <<		% look at every indice

   % indice is hidden for tracesyms or is already listed as a contraction indice
    IF MEMBER (MYCAR (INDEX), LEX2) OR NOT (ATOM (MYCAR (INDEX))) THEN <<
      INDEX := MYCDR (INDEX);
      CONCOV := MYCDR (CONCOV)
    >>   				% skip a deriv op
    ELSE IF MYCAR (FDERIV (INDEX)) = 1 THEN INDEX := MYCDR (INDEX)
   			% an integer indice cannot be a contraction indice.
    ELSE IF FIXP (MYCAR (INDEX)) THEN <<
      LEX1 := MYCAR (INDEX) . LEX1;
      INDEX := MYCDR (INDEX);
      LEX3 := (MYCAR (CONCOV) OR -1) . LEX3;
      CONCOV := MYCDR (CONCOV)
    >> 	% look for a repeat further down the index, if its there and not
        % in the notcon list (and not repeated yet again) its an almost valid
        % contraction (must check concov's too).
    ELSE IF (I := LOOK (MYCDR (INDEX), MYCAR (INDEX), 1)) AND
         NOT MEMBER (MYCAR (INDEX), NOTCON) THEN <<
      IF MEMBER (MYCAR (INDEX), PNTH (INDEX, I + 2)) THEN
        MERROR (LIST ("too many contraction indices", LEX5, MYCAR (INDEX)),
                        'T, 'CONTRACT)
      ELSE IF CONCOV AND (!*EXTENDEDSUM AND NOT (ABS (MYCAR (CONCOV)) =
          ABS (NTH (MYCDR (CONCOV), I))) OR NOT (MYCAR (CONCOV) =
          -NTH (MYCDR (CONCOV), I))) THEN  % bad concov pair
        MERROR (LIST ("improper contraction:", LEX5, MYCAR (INDEX)),
                        'T, 'CONTRACT);
      LEX2 := MYCAR (INDEX) . LEX2;	% save as contraction indice
      INDEX := MYCDR (INDEX);
      LEX4 := (MYCAR  (CONCOV) OR -1) . LEX4;
      CONCOV := MYCDR (CONCOV)
    >> ELSE <<				% a regular indice
      LEX1 := MYCAR (INDEX) . LEX1;
      LEX3 := (MYCAR (CONCOV) OR -1) . LEX3;
      INDEX := MYCDR (INDEX);
      CONCOV := MYCDR (CONCOV)
    >>
  >>;
  RETURN (LIST (REVERSE (LEX1), REVERSE (LEX2), REVERSE (LEX3),
                REVERSE (LEX4)));
END;

% mapindex replaces the user input indices with the corresponding ones
% from the association list AINDEX. The new indices are from the
% ALPHALIST!* are are not supposed to appear anywhere in the original value.

SYMBOLIC PROCEDURE MAPINDEX (INDEX, AINDEX, EXP);
BEGIN SCALAR LEX, LIS;
  INDEX := MAPCAR (INDEX, 'IND);	% must map tracesym'ed indices too
  WHILE INDEX DO <<
    IF NOT (LEX := MYCDR (ASSOC (MYCAR (INDEX), AINDEX))) AND
       NOT FIXP (MYCAR (INDEX)) THEN
      MERROR (LIST ("free indice:", MYCAR (INDEX), EXP), 'T, 'MAPINDEX);
    LIS := (LEX OR MYCAR (INDEX)) . LIS;
    INDEX := MYCDR (INDEX);
  >>;
  RETURN (REVERSE (LIS));
END;

SYMBOLIC !*USEGETCONSYM:= 'T;
% conprod CONstructs PRODucts of indexed objects, and expands any contraction
% operations that have been indicated. lis is a set of igen'ed indices to
% be used in expanding the contraction. index is a mapped index.

SYMBOLIC PROCEDURE CONPROD (VALUE, INDEXC, LIS);
BEGIN SCALAR LEX, LEX1, SYMLST, NIVALUE, MP;
  IF CHECKTYPE (VALUE, 'TIMES) THEN <<    % split up if a product
    LEX := MYCDR (VALUE);
    VALUE := 'NIL;
    WHILE LEX DO <<   % separate indexed stuff from scalar stuff
      IF FREE1 (MYCAR (LEX), 'EVALC) THEN NIVALUE := MYCAR (LEX) . NIVALUE
      ELSE VALUE := MYCAR (LEX) . VALUE;  % all things indexed
      LEX := MYCDR (LEX)
    >>;
    VALUE := 'TIMES . VALUE
  >>;
  SYMLST := !*USEGETCONSYM AND GETCONSYM (VALUE, INDEXC);   % determine common symmetry
  IF SYMLST = 0 THEN RETURN (0);        % found ident zero
% IF SYMLST THEN WRITE "Using this symmetry in contraction: ", SYMLST,!$EOL!$;
  NIVALUE := NIVALUE OR '(1);
  LIS := IGEN (MYCAR (LIS), MYCADR (LIS), SYMLST);
  LOOP:				%  must be done once, even if lis = 'nil
    SETLIS (INDEXC, MYCAR (LIS));	% first contraction index
    IF (LEX1 := EVAL1 (VALUE)) THEN <<
      MP := MULTIP (MYCAR (LIS), SYMLST);  % multiplicity of index
      IF MP = 1 THEN LEX := LEX1 . LEX
      ELSE LEX := LIST ('TIMES, MP, LEX1) . LEX  % nonzero value
    >>;
    LIS := MYCDR (LIS);
    IF NOT LIS THEN GO TO AFTERLOOP;
  GO TO LOOP;
  AFTERLOOP:
  SETLIS (INDEXC, INDEXC);	% clear indices
  IF NOT LEX THEN RETURN ('NIL)				% whole thing is 0
  ELSE IF NOT MYCDR (LEX) THEN   % only 1 term
          RETURN ('TIMES . APPEND (NIVALUE, LIST (MYCAR (LEX))))
  ELSE RETURN ('TIMES . APPEND (NIVALUE, LIST ('PLUS . LEX)));
END;

% getconsym looks at the value being contracted in order to determine what
% symmetry is common over the contraction and can be used when igen'ing the
% contraction indices.

SYMBOLIC PROCEDURE GETCONSYM (VALUE, INDEXC);
BEGIN SCALAR LEX, TNSR1, TNSR2, I1, I2, S1, S2;
  IF NOT MYCDR (INDEXC) THEN RETURN ('NIL);   % only 1 contraction index
  IF CHECKTYPE (VALUE, 'EVALC) THEN RETURN ('NIL);
  VALUE := MYCDR (VALUE);
  IF NOT CHECKTYPE (MYCAR (VALUE), 'EVALC) THEN RETURN ('NIL);
  TNSR1 := MYCADAR (VALUE);
  I1 := MYCADDAR (VALUE);
  VALUE := MYCDR (VALUE);
  IF NOT CHECKTYPE (MYCAR (VALUE), 'EVALC) THEN RETURN ('NIL);
  TNSR2 := MYCADAR (VALUE);
  I2 := MYCADDAR (VALUE);
  S1 := NEWSYM (GET (TNSR1, 'SYMMETRY), FCNV (I1, INDEXC));
  S2 := NEWSYM (GET (TNSR2, 'SYMMETRY), FCNV (I2, INDEXC));
  IF I1 = I2 AND S1 = S2 THEN RETURN (S1)
  ELSE RETURN ('NIL);
END;

% fcnv fakes up a concov list for the contraction indices by writing a
% 1 for every one of these and something distinct for all other indices.

SYMBOLIC PROCEDURE FCNV (INDEX, INDEXC);
BEGIN SCALAR LIS, I;
  I := 2;	% distinct concov value
  WHILE INDEX DO <<
    IF MEMQ (MYCAR (INDEX), INDEXC) THEN LIS := 1 . LIS
    ELSE <<
      LIS := I . LIS;
      I := I + 1
    >>;
    INDEX := MYCDR (INDEX)
  >>;
  RETURN (REVERSE (LIS));
END;

% eval1 partially evaluates products (and df's) by calling 'eval2 for
% each indexed object.

SYMBOLIC PROCEDURE EVAL1 (VALUE);
BEGIN SCALAR LEX, LEX1, LEX2;
  IF NOT CHECKTYPE (VALUE, 'TIMES) AND NOT CHECKTYPE (VALUE, 'DF) THEN
    RETURN (EVAL2 (VALUE));		% just an indexed object
  LEX2 := MYCAR (VALUE);			% operator for value
  VALUE := MYCDR (VALUE);			% operands of expression
  LOOP:					% for each object in product or sum
    IF NOT VALUE THEN RETURN (LEX2 . REVERSE (LEX));  % rebuild value
    IF NOT (LEX1 := EVAL2 (MYCAR (VALUE))) THEN RETURN ('NIL);
    VALUE := MYCDR (VALUE);
    LEX := LEX1 . LEX;			% operand list
  GO TO LOOP;
END;

FLUID '(SYMI!*);

% eval2 partially evaluates products and df's by evaling the index for
% an object which substitutes for the contraction indices. if the index
% becomes an integer index, the object value is read and replaces the
% indexed form. 

SYMBOLIC PROCEDURE EVAL2 (VALUE);
BEGIN SCALAR LEX, SYMI!*, TNSR, LEX1, LEX2;
  IF FREE1 (VALUE, 'EVALC) THEN RETURN (VALUE)  % no op
  ELSE IF CHECKTYPE (VALUE, 'EVALC) THEN <<	% an indexed form
    TNSR := MYCADR (VALUE);			% object name
    LEX := MAPCAR (MYCADDR (VALUE), 'EVAL);
    IF INTINDEX (LEX) THEN <<		% can read a value to replace object
      LEX2 := READTNSR (TNSR, LEX);
      IF MYCAR (LEX2) THEN RETURN (MK!*SQ (LEX2))  % so simp leaves it alone
      ELSE RETURN ('NIL)
    >>
        % symmetries say 0 for this subs of contraction indices
    ELSE IF MYCADR (SYMA (LEX, GET (TNSR, 'SYMMETRY), 'T)) = 0 THEN
      RETURN ('NIL)
    ELSE RETURN (LIST ('EVALC, TNSR, LEX))   	% return form
  >>;
  RETURN (MAPCAR (VALUE, 'EVAL2));  		% map it down
END;

PUT ('EVALC, 'SIMPFN, 'SIMPEVALC); 		% define simp property
FLAG ('(EVALC), 'FULL);

% EVALC replaces 'RDR as the operator of an indexed form in expressions
% being evaluated. when simp calls this function, it eval's the index to
% find which element is being referenced, and reads it. ('RDR would do
% all sorts of extra fancy stuff we dont need or want here.)

SYMBOLIC PROCEDURE SIMPEVALC (U);
  READTNSR (MYCADR (U), MAPCAR (MYCADDR (U), 'EVAL));

% collecterms looks down through an expression (a product or 'df) 
% to discover what the net index structure is. this can be tricky.

SYMBOLIC PROCEDURE COLLECTERMS (EX);
BEGIN SCALAR LEX1;
  WHILE EX DO <<				% all terms in expression
    IF CHECKTYPE (MYCAR (EX), 'RDR) THEN <<	% an indexed object
	 	% internal contractions don't contribute to the net structure
      LEX1 := CONTRACT (MYCADDAR (EX), GET (MYCADAR (EX), 'CONCOV)); 
      NINDEX := APPEND (NINDEX, MYCAR (LEX1));
      NCONCOV := APPEND (NCONCOV, MYCADDR (LEX1))
    >>		% is a sum with indexed objects in it
    ELSE IF CHECKTYPE (MYCAR (EX), 'PLUS) AND NOT FREE1 (MYCAR (EX), 'RDR) THEN <<
      LEX1 := COLLECTERMS1 (MYCDAR (EX));		% look into the sum
      NINDEX := APPEND (NINDEX, MYCAR (LEX1));
      NCONCOV := APPEND (NCONCOV, MYCADR (LEX1))
    >>
    ELSE IF CHECKTYPE (MYCAR (EX), 'TIMES) OR CHECKTYPE (MYCAR (EX), 'DF)
         OR CHECKTYPE (MYCAR (EX), 'MINUS)	% recurse down products
                THEN COLLECTERMS (MYCDAR (EX))
    ELSE IF NOT ATOM (MYCAR (EX)) THEN <<
      LEX1 := COLLECTERMS1 (MYCDAR (EX));		% look into other forms
      NINDEX := APPEND (NINDEX, MYCAR (LEX1));
      NCONCOV := APPEND (NCONCOV, MYCADR (LEX1))
    >>;
    EX := MYCDR (EX)
  >>;
END;

% collecterms1 looks through a sum to determine the index structure.
% it only looks at the first term, as the rest will be seen at some
% later recursion by processvalue (?).

SYMBOLIC PROCEDURE COLLECTERMS1 (EX);
BEGIN SCALAR LEX, LEX1, NINDEX, NCONCOV;
  IF CHECKTYPE (MYCAR (EX), 'RDR) THEN <<	
    LEX := CONTRACT (MYCADDAR (EX), GET (MYCADAR (EX), 'CONCOV));
    RETURN (LIST (MYCAR (LEX), MYCADDR (LEX)))
  >>
  ELSE IF CHECKTYPE (MYCAR (EX), 'TIMES) OR CHECKTYPE (MYCAR (EX), 'DF)
          OR CHECKTYPE (MYCAR (EX), 'MINUS)
            AND NOT (FREE1 (MYCAR (EX), 'RDR)) THEN <<
    COLLECTERMS (MYCDAR (EX));		% recurse down products
    RETURN (LIST (NINDEX, NCONCOV))
  >>;
END;

% chkconcov compares the current concov value associated with each input
% indice (in the global variable ACONCOV) with the value associated in the
% current index. If they are not the same, the expression has an inconsistent
% index structure.

SYMBOLIC PROCEDURE CHKCONCOV (INDEX, CONCOV, INDEXC, EXP);
BEGIN SCALAR LEX, LEX1;
  WHILE INDEX DO <<
    LEX1 := MYCAR (INDEX);
    INDEX := MYCDR (INDEX);
    IF (LEX := MYCDR (ASSOC (LEX1, ACONCOV))) AND NOT LEX = MYCAR (CONCOV) THEN
      MERROR (LIST ("inconsistent indices:", LEX1, EXP), 'T, 'CHKCONCOV);
    IF NOT LEX AND IDP (LEX1) AND NOT MEMQ (LEX1, INDEXC) THEN
      ACONCOV := (LEX1 . (MYCAR (CONCOV) OR -1)) . ACONCOV;
    CONCOV := MYCDR (CONCOV)
  >>;
END;

;END;
