.bp 1
.so include.n
.he ````
.fo ````
.po 
.nh
.ls 2
.sp 2
.ce
Appendix D
.ce
Examples
.sp 10
Following are several examples of metrics investigated with REDTEN. They
are the Schwarzschild metric, the Robertson-Walker metric, the Hauser metric,
the Harrison metric in natural basis and in frame, and the Kerr metric.
Each of these was run on an SUN 3/160 computer; the user input is italicised.
.fo ``-1.%-``
.bp 1
.ls 1
.nf
.cs 1 24
\fRExample 1

REDUCE 3.2 with tensor system, 15\-Apr\-85 ...

\fI.ne 2
COMMENT
.br
.fi
This  Reduce  script  computes   the   Ricci   tensor   for   the
Schwarzschild  metric  to show that it is a vacuum solution. Also
computed is the Kretschmann scalar. 
.br
Below is the line-element in the usual form.
.br
.nf
;

ds:\(eq(1\-2\(**m/r)\(**d(t)^2\-d(r)^2/(1\-2\(**m/r)\-r^2\(**d(th)^2\-r^2\(**sin(th)^2\(**d(ph)^2;
\fR
.(b M
            2  2         2  2         2           2  2          2    3
 ds :\(eq (d(r)  r  \- 4 d(t)  m  + 4 d(t)  m r \- d(t)  r  \- 2 d(th)  m r

                2  4          2        2    3        2        2  4
         + d(th)  r  \- 2 d(ph)  SIN(th)  m r  + d(ph)  SIN(th)  r )/(r

           (2 m \- r))
.)b
\fIon time;

.ne 2
COMMENT
.br
.fi
Compute the metric from the line-element, and compute  the  Ricci
tensor.
.br
.nf
;
.(b M
metric(ds);
\fR
computing g
INVERT finished.

 g

TIME: 272 MS
.)b
\fI
.(b M
ricci();
\fR
computing ric
computing ri
computing c1
CHRISTOFFEL1 finished.
computing c2
CHRISTOFFEL2 finished.
RIEMANN finished.
\(**\(** this metric is a vacuum solution.

 ric

TIME: 5100 MS
.)b
\fI.ne 2
COMMENT
.br
.fi
Display the  Riemann  curvature  tensor  and  the  (empty)  Ricci
tensor.
.br
.nf
;
\fR
.(b M
\fI
ri[];
\fR
PNAME:               ri
INDEXED:             TENSOR
COORDS:              (t r th ph)
INDICES:             (4 (0 0 0 0) (3 3 3 3))
CONCOV:              (\-1 \-1 \-1 \-1)
MULTIPLIER:          (1 . 1)
TYPE:                RIEMANN
SYMMETRY:            (((\-1) 1 2) ((\-1) 3 4) ((2) 1 3))
.)b
.(b M
                        4       3         2  2        3    4     3
 ri         \(eq (2 m (16 m  \- 32 m  r + 24 m  r  \- 8 m r  + r ))/(r  (16
   0 1 0 1 
                      4       3         2  2        3    4
                     m  \- 32 m  r + 24 m  r  \- 8 m r  + r ))
.)b
.(b M
                     2            2     2
 ri         \(eq (m (4 m  \- 4 m r + r ))/(r  (2 m \- r))
   0 2 0 2 

                      2       2            2     2
 ri         \(eq (SIN(th)  m (4 m  \- 4 m r + r ))/(r  (2 m \- r))
   0 3 0 3 
.)b
.(b M
 ri         \(eq ( \- m)/(2 m \- r)
   1 2 1 2 

                         2
 ri         \(eq ( \- SIN(th)  m)/(2 m \- r)
   1 3 1 3 
.)b

                          2
 ri         \(eq  \- 2 SIN(th)  m r
   2 3 2 3 


 ri

TIME: 510 MS
\fI
.(b M
ric[];
\fR
PNAME:               ric
INDEXED:             TENSOR
COORDS:              (t r th ph)
INDICES:             (2 (0 0) (3 3))
CONCOV:              (\-1 \-1)
MULTIPLIER:          (1 . 1)
TYPE:                RICCI
SYMMETRY:            (((1) 1 2))


 ric

TIME: 68 MS
.)b
\fI.ne 2
COMMENT
.br
.fi
Compute the Kretschmann scalar by fully contracting  the  Riemann
tensor.  An  @  symbol indicates that the attached index is to be
raised or lowered via a metric contraction. The resulting  object
is  stored  as  a  new  entity in the system, and attached to the
parent (ri#p seen in the directory below). 
.br
The  gcd  flag  allows  Reduce  to  cancel  common  factors  from
numerator and denominator which are not internally identical. 
.br
.nf
;

on gcd;

.(b M
kr \(eq\(eq ri[a,b,c,d] \(** ri[@a,@b,@c,@d];
\fR

        a b c d 
 kr \(eq ri         ri
                   a b c d 

computing ri#p
SHIFT finished.
\(** 

      2   6
 (48 m )/r

TIME: 1377 MS
.)b
\fIoff gcd;


TIME: 17 MS
.(b M
dir();
\fR
  name          type         elements prot  coordinates     concov
  ri#p          RIEMANN          6     W    (t r th ph)     (1 1 1 1)
  ric           RICCI            0     W    (t r th ph)     (\-1 \-1)
  ri            RIEMANN          6     W    (t r th ph)     (\-1 \-1 \-1 \-1)
  c2            CHRISTOFFEL2     9     W    (t r th ph)     (1 \-1 \-1)
  c1            CHRISTOFFEL1     9     W    (t r th ph)     (\-1 \-1 \-1)
  g#INV         METRIC           4     W    (t r th ph)     (1 1)
  g             METRIC           4     W    (t r th ph)     (\-1 \-1)

 7 object(s),     Total elements: 38


T
.)b
\fR
.fo ``-2.%-``
.bp 1
\fRExample 2

REDUCE 3.2 with tensor system, 15\-Apr\-85 ...

\fI.ne 2
COMMENT
.br
.fi
This Reduce script computes the Weyl conformal  curvature  tensor
for  the  Robertson\-Walker  metric  to  show that the solution is
conformally flat. 
.br
Below is the line-element in the usual form. We let the  function
s(om) remain general (k \(eq 0, \(+-\ 1).
.br
.nf
;

on time;


coords :\(eq '(t om th ph);
\fR

(t om th ph)

\fIds1 :\(eq d(t)^2\-rt^2\(**(d(om)^2+s^2\(**(d(th)^2+sin(th)^2\(**d(ph)^2));
\fR

            2        2  2   2        2        2  2   2        2   2
 ds1 :\(eq d(t)  \- d(th)  s  rt  \- d(ph)  SIN(th)  s  rt  \- d(om)  rt

TIME: 289 MS

\fIdepend rt, t;
\fR

\fIlet s \(eq sin(sqrt(k)\(**om)/sqrt(k);

.ne 2
COMMENT
.br
.fi
Compute the metric tensor from the line-element and  compute  the
Weyl tensor. 
.br
.nf
;
.(b M
metric(ds1);
\fR
computing g
INVERT finished.

 g

TIME: 340 MS
.)b
\fI
.(b M
weyl();
\fR
computing c
computing ric
computing ri
computing c1
CHRISTOFFEL1 finished.
computing c2
CHRISTOFFEL2 finished.
RIEMANN finished.
RICCI finished.
computing ricsc
RICCISC finished.
\(**\(** this space is conformally flat

 c

TIME: 9622 MS
.)b
\fI.ne 2
COMMENT
.br
.fi
Compute the Einstein tensor and raise its first index to form the 
object called 'ei#b'. Note the two independent field equations of 
an isotropic fluid.
.br
.nf
;
.(b M
einstein();
\fR
computing ei

 ei

TIME: 425 MS
.)b

\fI
.(b M
shift(ei[@a,b]);
\fR
computing ei#b

   a 
 ei
     b 

TIME: 289 MS
.)b
\fR

.(b M
\fI
ei#b[];
\fR
PNAME:               ei
INDEXED:             TENSOR
COORDS:              (t om th ph)
INDICES:             (2 (0 0) (3 3))
CONCOV:              (1 \-1)
MULTIPLIER:          (1 . 1)
TYPE:                EINSTEIN
.)b

   0                2         2
 ei     \(eq ( \- 3 (rt   + k))/rt
     0             t

   1                          2        2
 ei     \(eq ( \- 2 rt    rt \- rt   \- k)/rt
     1            t,2        t

   2                          2        2
 ei     \(eq ( \- 2 rt    rt \- rt   \- k)/rt
     2            t,2        t

   3                          2        2
 ei     \(eq ( \- 2 rt    rt \- rt   \- k)/rt
     3            t,2        t


 ei#b

TIME: 238 MS
\fR
.(b M
\fI
dir();
\fR
  name          type         elements prot  coordinates     concov
  ei#b          EINSTEIN         4     W    (t om th ph)    (1 \-1)
  ei            EINSTEIN         4     W    (t om th ph)    (\-1 \-1)
  c             WEYL             0     W    (t om th ph)    (\-1 \-1 \-1 \-1)
  ric           RICCI            4     W    (t om th ph)    (\-1 \-1)
  ri            RIEMANN          6     W    (t om th ph)    (\-1 \-1 \-1 \-1)
  c2            CHRISTOFFEL2     12    W    (t om th ph)    (1 \-1 \-1)
  c1            CHRISTOFFEL1     12    W    (t om th ph)    (\-1 \-1 \-1)
  g#INV         METRIC           4     W    (t om th ph)    (1 1)
  g             METRIC           4     W    (t om th ph)    (\-1 \-1)

 9 object(s),     Total elements: 50


T
.)b
\fR
.fo ``-3.%-``
.bp 1
\fRExample 3

REDUCE 3.2 with tensor system, 15\-Apr\-85 ...
\fI
.ne 2
COMMENT
.br
.fi
This Reduce script computes the Ricci  tensor  for  the  Harrison
II-A-7  metric to show that it is a vacuum solution. This example
is  from  d'Inverno,  R.A.,  (1980).  "General   Relativity   and
Gravitation", vol 1., 493. 
The total cpu running-time on a SUN 3/160 is about 30 sec.
.br
Below is the line-element in a slightly modified form  from  that
in  the  reference  above. In particular, w \(eq x/l, where x is the
original coordinate and l is a constant. 
.br
.nf
;

coords :\(eq '(t x y w);
\fR

(t x y w)
\fI
ds :\(eq \-p^(1+a)\(**q^(1+2/a)\(**w^(\-1\-1/a)\(**d(t)^2
      +p^(2+a)\(**q^(1+2/a)\(**w^(\-1/a)\(**d(x)^2
      +p^(\-a)\(**q^(\-1)\(**w^(1/a)\(**d(y)^2
      +l^2\(**p^(3+a)\(**q^(1+2/a)\(**w^(\-2\-1/a)\(**(v^2\-1)/(w\-1)\(**d(w)^2;
\fR
.(b M
            (2/a)  (2 a)     2    2  2    (2/a)  (2 a)     2    2
 ds :\(eq ( \- q      p      d(t)  p q  w  + q      p      d(t)  p q  w + 

         (2/a)  (2 a)     2  2  3  2  2    (2/a)  (2 a)     2  2  3  2
        q      p      d(w)  l  p  q  v  \- q      p      d(w)  l  p  q

            (2/a)  (2 a)     2  2  2  3    (2/a)  (2 a)     2  2  2  2
         + q      p      d(x)  p  q  w  \- q      p      d(x)  p  q  w

            (2/a)     2  3    (2/a)     2  2    (1/a)  a    2
         + w      d(y)  w  \- w      d(y)  w )/(w      p  q w  (w \- 1))
.)b

\fIlet a^2 \(eq 3;


.ne 2
COMMENT
.br
.fi
Define the derivatives of p(x,t) and q(w). We will not  need  the
explicit form of p or q. 
.br
.nf
;

depend p,x,t;

depend q,w;

let df(p,x) \(eq x/(6\(**l^2);

let df(p,t) \(eq 1/(a\(**l);

let df(q,w) \(eq q\(**v/w;

let df(v,w) \(eq (v^2\-1)/(4\(**w)\(**(2\(**v/(w\-1)+4/a);

on time;
\fR
TIME: 1615 MS
\fI

.ne 2
COMMENT
.br
.fi
Compute the metric from the line-element, the Christoffel symbols 
and the Riemann curvature tensor. 
.br
.nf
;
.(b M
metric (ds);
\fR
computing g
INVERT finished.

 g

TIME: 510 MS
.)b
\fI
.(b M
christoffel2();

computing c2
computing c1
CHRISTOFFEL1 finished.
\fR
 c2

TIME: 7446 MS
.)b
\fI
.(b M
riemann();

\fR
computing ri
 ri

TIME: 11339 MS
.)b
\fI
.ne 2
COMMENT
.br
.fi
We substitute f and  h  as  place-holders  for  q^(2/a)  and  p^a
respectively.  f and h have no properties whatsoever, that we can
do this is  a  consequence  of  the  fact  mentioned  above:  the
explicit form of p and q is not required. 
.br
.nf
;

let q^(2/a) \(eq f;


let p^a \(eq h;

.ne 2
COMMENT
.br
.fi
Apply these substitutions to the Riemann tensor  and  the  metric
inverse before computing the Ricci tensor. 
.br
.nf
;
.(b M
mapfi(ri);
\fR
(2 3 2 3)
 ri

TIME: 2431 MS
.)b
\fI
.(b M
mapfi(g#INV);
\fR
(3 3)
 g#INV

TIME: 238 MS
.)b
\fI
.(b M
ricci();
\fR
computing ric
\(**\(** this metric is a vacuum solution.

 ric

TIME: 1564 MS
.)b
\fR
.(b M
\fI
ri[];
\fR
PNAME:               ri
INDEXED:             TENSOR
COORDS:              (t x y w)
INDICES:             (4 (0 0 0 0) (3 3 3 3))
CONCOV:              (\-1 \-1 \-1 \-1)
MULTIPLIER:          (1 . 1)
TYPE:                RIEMANN
SYMMETRY:            (((\-1) 1 2) ((\-1) 3 4) ((2) 1 3))
.)b
.(b M
                            2    2           2    2         2
 ri         \(eq (f h q (20 a l  p v  w \- 12 a l  p v  \- 16 a l  p v w + 
   0 1 0 1 

                        2            2        2  2      2       2    2
                  16 a l  p v \- 8 a l  p \- a v  x  + a x  + 36 l  p v

                           2    2       2             2          2
                   w \- 24 l  p v  \- 28 l  p v w + 28 l  p v \- 4 l  p w

                        2      2  2    2        (1/a)  4       2
                   \- 8 l  p \- v  x  + x ))/(48 w      l  p w (v  \- 1))
.)b
.(b M
                                                        (1/a)    2  2
 ri         \(eq (f h q x ( \- 5 a v + 3 a \- 9 v + 3))/(24 w      a l  w )
   0 1 0 3 
.)b
.(b M
                                                        (1/a)
 ri         \(eq (f h p q ( \- 5 a v + 3 a \- 9 v + 6))/(12 w      l w)
   0 1 1 3 
.)b
.(b M
                (1/a)           2    2           2    2         2
 ri         \(eq (w      ( \- 60 a l  p v  w + 24 a l  p v  + 24 a l  p v 
   0 2 0 2 

                            2             2             2        2  2
                  w \- 24 a l  p v + 24 a l  p w + 12 a l  p \- a v  x

                        2        2    2         2    2       2
                   + a x  \- 108 l  p v  w + 36 l  p v  + 60 l  p v w

                         2           2           2        2  2      2
                   \- 60 l  p v + 60 l  p w + 12 l  p \- 3 v  x  + 3 x )

                         4  3       2
               )/(144 h l  p  q w (v  \- 1))
.)b
.(b M
                (1/a)                        3  2
 ri         \(eq (w      x ( \- 3 a \- 5))/(24 h l  p  q)
   0 2 1 2 
.)b
.(b M
                (1/a)
 ri         \(eq (w      (5 a v \- 3 a + 9 v \- 6))/(12 h l p q w)
   0 2 2 3 
.)b
.(b M
                           2    2         2               2
 ri         \(eq (f h q (6 a l  p v  + 12 a l  p v w \- 12 a l  p v \- 12 a
   0 3 0 3 

                    2            2          2  2        2       2    2
                   l  p w + 6 a l  p + 2 a v  x  \- 2 a x  + 18 l  p v

                         2             2           2          2
                   + 12 l  p v w \- 12 l  p v \- 24 l  p w + 6 l  p + 3 

                   2  2      2        (1/a)  2  3
                  v  x  \- 3 x ))/(72 w      l  w  (w \- 1))
.)b
.(b M
                               2            2            (1/a)      2
 ri         \(eq (f h p q x (5 a v  \- 5 a + 9 v  \- 9))/(24 w      a l w  
   0 3 1 3 

                 (w \- 1))
.)b
.(b M
                (1/a)          2    2         2               2
 ri         \(eq (w      ( \- 6 a l  p v  \- 12 a l  p v w + 12 a l  p v + 
   1 2 1 2 

                        2            2          2  2        2       2
                  12 a l  p w \- 6 a l  p \- 2 a v  x  + 2 a x  \- 18 l  

                     2       2             2           2          2
                  p v  \- 12 l  p v w + 12 l  p v + 24 l  p w \- 6 l  p

                        2  2      2          4  2     2
                   \- 3 v  x  + 3 x ))/(72 h l  p  q (v  \- 1))
.)b
.(b M
                (1/a)         3        2                    3      2
 ri         \(eq (w      x (5 a v  \- 3 a v  \- 5 a v + 3 a + 9 v  \- 3 v
   1 2 2 3 

                                        2         2
                   \- 9 v + 3))/(24 a h l  p q w (v  \- 1))
.)b
.(b M
                              2    2           2    2         2
 ri         \(eq (f h p q (60 a l  p v  w \- 24 a l  p v  \- 24 a l  p v w
   1 3 1 3 

                           2             2             2        2  2
                   + 24 a l  p v \- 24 a l  p w \- 12 a l  p + a v  x

                        2        2    2         2    2       2
                   \- a x  + 108 l  p v  w \- 36 l  p v  \- 60 l  p v w

                         2           2           2        2  2      2
                   + 60 l  p v \- 60 l  p w \- 12 l  p + 3 v  x  \- 3 x )

                       (1/a)  2  2
               )/(144 w      l  w  (w \- 1))
.)b
.(b M
                (1/a)           2    2           2    2         2
 ri         \(eq (w      ( \- 20 a l  p v  w + 12 a l  p v  + 16 a l  p v 
   2 3 2 3 

                            2            2        2  2      2       2
                  w \- 16 a l  p v + 8 a l  p + a v  x  \- a x  \- 36 l  

                     2         2    2       2             2          2
                  p v  w + 24 l  p v  + 28 l  p v w \- 28 l  p v + 4 l

                            2      2  2    2          2      2
                   p w + 8 l  p + v  x  \- x ))/(48 h l  p q w  (w \- 1)

                 )


 ri

TIME: 4454 MS
.)b
\fI
.(b M
ric[];
\fR
PNAME:               ric
INDEXED:             TENSOR
COORDS:              (t x y w)
INDICES:             (2 (0 0) (3 3))
CONCOV:              (\-1 \-1)
MULTIPLIER:          (1 . 1)
TYPE:                RICCI
SYMMETRY:            (((1) 1 2))


 ric

TIME: 34 MS
.)b
\fI
.(b M
dir();
\fR
  name          type         elements prot  coordinates     concov
  ric           RICCI            0     W    (t x y w)       (\-1 \-1)
  ri            RIEMANN          12    W    (t x y w)       (\-1 \-1 \-1 \-1)
  c2            CHRISTOFFEL2     21    W    (t x y w)       (1 \-1 \-1)
  c1            CHRISTOFFEL1     21    W    (t x y w)       (\-1 \-1 \-1)
  g#INV         METRIC           4     W    (t x y w)       (1 1)
  g             METRIC           4     W    (t x y w)       (\-1 \-1)

 6 object(s),     Total elements: 62


T
.)b
\fR
.fo ``-4a.%-``
.bp 1
\fRExample 4a

REDUCE 3.2 with tensor system, 15\-Apr\-85 ...
\fI
.ne 2
COMMENT
.br
.fi
This Reduce script evaluates the  Ricci  tensor  for  the  Hauser
metric  to show that the metric is indeed a vacuum solution. This
example is from d'Inverno, R.A.,  Frick,  I.  (1982).  Gen.  Rel.
Grav., 10, 835. 
The total cpu running-time on a SUN 3/160 is about 49 sec.
.br
Below is the line-element for the metric. The explicit  form  for
the functions b(x,u), c(x,u) and p(x,u) will be substituted after 
the  metric  is  computed.  The  function  f(x,u)  is  not  given
explicitly, only side relations for its partial  derivatives  are
provided. 
.br
.nf
;

on time;

\fR
TIME: 136 MS
\fI
coords :\(eq'(u r x y);

\fR
(u r x y)

\fI
ds:\(eq\-2\(**p^2\(**(b^2+c^2)\(**d(u)^2+2\(**p\(**d(u)\(**d(r)\-4\(**p\(**(r\(**b+2\(**c\(**p)\(**d(u)\(**d(x)
 +(16\(**x\(**p^2\(**(b^2+c^2)+4\(**p\(**(2\(**b\(**p\-r\(**c))\(**d(u)\(**d(y)\-8\(**x\(**p\(**d(r)\(**d(y)
 \-2\(**(r^2+p^2)\(**d(x)^2+16\(**x\(**p\(**(r\(**b+2\(**c\(**p)\(**d(x)\(**d(y)
 \-2\(**(r^2+p^2+8\(**x\(**p\(**(2\(**b\(**p\-r\(**c)+16\(**x^2\(**p^2\(**(b^2+c^2))\(**d(y)^2;

\fR
                                              2  2  2       2  2  2
 ds :\(eq 2 (d(r) d(u) p \- 4 d(r) d(y) p x \- d(u)  b  p  \- d(u)  c  p  \- 

                                             2                2  2
          2 d(u) d(x) b p r \- 4 d(u) d(x) c p  + 8 d(u) d(y) b  p  x

                            2                2  2
           + 4 d(u) d(y) b p  + 8 d(u) d(y) c  p  x \- 2 d(u) d(y) c p 

                  2  2       2  2
          r \- d(x)  p  \- d(x)  r  + 8 d(x) d(y) b p r x + 16 d(x) d(y)

              2            2  2  2  2          2    2            2  2
           c p  x \- 16 d(y)  b  p  x  \- 16 d(y)  b p  x \- 16 d(y)  c  

           2  2         2               2  2       2  2
          p  x  + 8 d(y)  c p r x \- d(y)  p  \- d(y)  r )

TIME: 918 MS
\fI
.ne 2
COMMENT
.br
.fi
Define the side relations for the partial derivatives of f(x,u). 
.br
.nf
;

depend f,x,u;


let df(f,x) \(eq \-2\(**u/x\(**df(f,u);


let df(f,u,2) \(eq \-3\(**f/(16\(**k);


let df(f,u,x) \(eq df(f,x,u);


.ne 2
COMMENT
.br
.fi
Define the partial derivativs for k(u,x).
.br
.nf
;

depend k,u,x;


let df(k,u) \(eq 2\(**u;


let df(k,x) \(eq 16\(**x^3;


.ne 2
COMMENT
.br
.fi
When  r^2  is  replaced  below,  Reduce  assumes   a   functional
dependence of r on x,u. 
.br
.nf
;

let df(r,x) \(eq 0;


let df(r,u) \(eq 0;


let df(u,x) \(eq 0;


.ne 2
COMMENT
.br
.fi
Replace all  occurrences  of  r^2  with  s\-p^2,  where  s  is  an
undefined  function of u,x,r. The actual form of s is not needed.
This substitution causes the determinant of the metric  to  be  a
simple product, simplifying the form of the inverse metric. 
.br
.nf
;

let r^2 \(eq s \- p^2;


depend s,u,x,r;


.ne 2
COMMENT
.br
.fi
Define the partial derivatives of s(u,x,r).
.br
.nf
;

let df(s,u) \(eq 4\(**a^2\(**x^3\(**f\(**df(f,u);


let df(s,r) \(eq 2\(**r;


let df(s,x) \(eq 4\(**a^2\(**x^3\(**f\(**df(f,x)+3\(**2\(**a^2\(**x^2\(**f^2;


.ne 2
COMMENT
.br
.fi
Compute the metric tensor from the line-element.
.br
.nf
;
.(b M
metric (ds);
\fR
computing g
COFACTOR finished.
DETERM finished.
INVERT finished.

 g

TIME: 1224 MS
.)b
\fI
.ne 2
COMMENT
.br
.fi
Define the functions b(u,x), c(u,x), p(u,x). (These are defined in
terms of f(u,x)).
.br
.nf
;

let b \(eq u \(** df(f,u)/(x\(**f) \- 3/(4\(**x);


let c \(eq \-2\(**x\(**df(f,u)/f;


let p \(eq a^3\(**x^(3/2)\(**f;


.ne 2
COMMENT
.br
.fi
Replace all occurances of u^2 with k \- 4 x^4, where k is  defined
above. (k is actually defined as u^2 + 4 x^4). 
.br
Also replace a^4 with 2. This is an artifice to  avoid  a  Reduce
bug.
.br
.nf
;

let u^2\(eqk\-4\(**x^4;


let a^4 \(eq 2;           % a \(eq 2^(1/4)


.ne 2
COMMENT
.br
.fi
Apply the above definitions and substitutions to the metric and
its inverse.
.br
.nf
;
.(b M
mapfi(g#INV);
\fR
(3 3)
 g#INV

TIME: 3043 MS
.)b
\fI
.(b M
mapfi(g);
\fR
(3 3)
 g

TIME: 1088 MS
.)b
\fI
.ne 2
COMMENT
.br
.fi
Compute the Christoffel symbols and the Riemann curvature tensor.
.br
.nf
;
.(b M
christoffel1();
\fR
computing c1

 c1

TIME: 7038 MS
.)b
\fI
.(b M
christoffel2();
\fR
computing c2

 c2

TIME: 11934 MS
.)b
\fI
.(b M
riemann();
\fR
computing ri

 ri

TIME: 20043 MS
.)b
\fR
.(b M
\fI
ri[];
\fR
PNAME:               ri
INDEXED:             TENSOR
COORDS:              (u r x y)
INDICES:             (4 (0 0 0 0) (3 3 3 3))
CONCOV:              (\-1 \-1 \-1 \-1)
MULTIPLIER:          (1 . 1)
TYPE:                RIEMANN
SYMMETRY:            (((\-1) 1 2) ((\-1) 3 4) ((2) 1 3))
.)b
.(b M
                    3           3                  3    4
 ri         \(eq (3 f x  (SQRT(x) a  f k \- 8 SQRT(x) a  f x  \- 4 r u x))/
   0 2 0 2 

                          2
              (SQRT(x) a k )
.)b
.(b M
                  2                                        4
 ri         \(eq (3 a  f x ( \- SQRT(x) a k r + 8 SQRT(x) a r x  \- 8 f u 
   0 2 0 3 

                   4       2
                  x ))/(2 k )
.)b
                   2    4                                  4    2
 ri         \(eq (12 a  f x  ( \- 2 SQRT(x) a r u + f k \- 8 f x ))/k
   0 2 2 3 

                    3              3                  3    4
 ri         \(eq (3 f x  ( \- SQRT(x) a  f k + 8 SQRT(x) a  f x  + 4 r u x
   0 3 0 3 

                                 2
                  ))/(SQRT(x) a k )

.(b M
                     3                3      3              4
 ri         \(eq (12 f x  ( \- 4 SQRT(x) a  f u x  \- k r + 8 r x ))/(SQRT(
   0 3 2 3 

                       2
                 x) a k )

                     5           3                  3    4
 ri         \(eq (48 f x  (SQRT(x) a  f k \- 8 SQRT(x) a  f x  \- 4 r u x))
   2 3 2 3 

                           2
              /(SQRT(x) a k )


 ri
.)b
TIME: 646 MS
\fI
.ne 2
COMMENT
.br
.fi
Compute the Ricci tensor.
.br
.nf
;
.(b M
ricci();
\fR
computing ric
\(**\(** this metric is a vacuum solution.

 ric

TIME: 1700 MS
.)b
\fI
.(b M
dir();
\fR
  name          type         elements prot  coordinates     concov
  ric           RICCI            0     W    (u r x y)       (\-1 \-1)
  ri            RIEMANN          6     W    (u r x y)       (\-1 \-1 \-1 \-1)
  c2            CHRISTOFFEL2     32    W    (u r x y)       (1 \-1 \-1)
  c1            CHRISTOFFEL1     26    W    (u r x y)       (\-1 \-1 \-1)
  g#INV         METRIC           8     W    (u r x y)       (1 1)
  g             METRIC           8     W    (u r x y)       (\-1 \-1)

 6 object(s),     Total elements: 80


T
.)b
\fR
.fo ``-4b.%-``
.bp 1
\fRExample 4b

REDUCE 3.2 with tensor system, 15\-Apr\-85 ...
\fI
.ne 2
COMMENT
.br
.fi
This Reduce script evaluates the  Ricci  tensor  for  the  Hauser
metric in a null-tetrad frame to show that the metric is indeed a 
vacuum  solution, and also show that the metric is Petrov type N,
shear  free,  twisting  and  expanding.  This  example  is   from
d'Inverno, R.A., Frick, I. (1982). Gen. Rel. Grav., 10, 835. 
The total cpu running-time on a SUN 3/160 is about 2 min 7 sec.
.br
.nf
;

coords :\(eq'(u r x y);
\fR

(u r x y)
	
\fI
.ne 2
COMMENT
.br
.fi
Define the side relations for the partial derivatives of f(x,u).
.br
.nf
;

depend f,x,u;


let df(f,x) \(eq \-2\(**u/x\(**df(f,u);


let df(f,u,2) \(eq \-3\(**f/(16\(**k);


let df(f,u,x) \(eq df(f,x,u);


.ne 2
COMMENT
.br
.fi
Define the partial derivativs for k(u,x).
.br
.nf
;

depend k,u,x;


let df(k,u) \(eq 2\(**u;


let df(k,x) \(eq 16\(**x^3;


.ne 2
COMMENT
.br
.fi
When r^2 is replaced below, Reduce assumes a functional 
dependence of r on x,u.
.br
.nf
;

let df(r,x) \(eq 0;


let df(r,u) \(eq 0;


let df(u,x) \(eq 0;


.ne 2
COMMENT
.br
.fi
Replace all occurances of r^2 with s\-p^2, where s is an undefined
function of u,x,r. The actual form of s is not needed. This 
substitution causes the determinant of the metric to be a simple
product, simplifying the form of the inverse metric.
.br
.nf
;

let r^2 \(eq s \- p^2;


depend s,u,x,r;


.ne 2
COMMENT
.br
.fi
Define the partial derivatives of s(u,x,r).
.br
.nf
;

let df(s,u) \(eq 4\(**a^2\(**x^3\(**f\(**df(f,u);


let df(s,r) \(eq 2\(**r;


let df(s,x) \(eq 4\(**a^2\(**x^3\(**f\(**df(f,x)+3\(**2\(**a^2\(**x^2\(**f^2;


.ne 2
COMMENT
.br
.fi
Define the functions b(u,x), c(u,x), p(u,x). (These are defined in
terms of f(u,x)).
.br
.nf
;

let b \(eq u \(** df(f,u)/(x\(**f) \- 3/(4\(**x);


let c \(eq \-2\(**x\(**df(f,u)/f;


let p \(eq a^3\(**x^(3/2)\(**f;


.ne 2
COMMENT
.br
.fi
Replace all occurances of u^2 with k \- 4 x^4, where k is defined
above. (k is actually defined as u^2 + 4 x^4).
Also replace a^4 with 2. This is an artifice to avoid a Reduce bug.
.br
.nf
;

let u^2\(eqk\-4\(**x^4;


let a^4 \(eq 2;    % a \(eq 2^(1/4)


on time;

.ne 2
COMMENT
.br
.fi
Compute and display the null\-tetrad frame metric.
.br
.nf
;
.(b M
frmetric();
\fR
computing eta
COFACTOR finished.
DETERM finished.
INVERT finished.

 eta

TIME: 238 MS
.)b
\fI
.(b M
eta[];
\fR
PNAME:               eta
INDEXED:             FRAME
INDICES:             (2 (0 0) (3 3))
CONCOV:              (\-2 \-2)
MULTIPLIER:          (1 . 1)
TYPE:                METRIC
SYMMETRY:            (((1) 1 2))
\(**AT\(**:                (NIL eta eta#INV d2)
#DBR:                0

 eta         \(eq 1
    (0) (1) 

 eta         \(eq (\-1)
    (2) (3) 


 eta

TIME: 119 MS
.)b

\fI
.ne 2
COMMENT
.br
.fi
Create a connection coefficient for the tetrad.
.br
.nf
;
.(b M
mktnsr ('z,'(\-2 \-1),'(),'(),'CONNECTION);
\fR
 z
  (A) b 


TIME: 85 MS
.)b

\fI
.ne 2
COMMENT
.br
.fi
Ias is used to assign values to an entire object. User input follows
the equal sign.
.br
.nf
;
.(b M
ias(z);
\fR
z[0,0] \(eq \fIp;    \fR
z[0,1] \(eq \fI0;    \fR
z[0,2] \(eq \fI0;    \fR
z[0,3] \(eq \fI\-4\(**x\(**p; \fR
z[1,0] \(eq \fI0;      \fR
z[1,1] \(eq \fI1;      \fR
z[1,2] \(eq \fI\-6\(**p\(**c; \fR
z[1,3] \(eq \fI6\(**p\(**b;  \fR
z[2,0] \(eq \fIp\(**(b+i\(**c);\fR
z[2,1] \(eq \fI0;        \fR
z[2,2] \(eq \fIr\-i\(**p;    \fR
z[2,3] \(eq \fIp\(**(1\-4\(**b\(**x)+i\(**(r\-4\(**p\(**c\(**x);    \fR
z[3,0] \(eq \fIp\(**(b\-i\(**c);                    \fR
z[3,1] \(eq \fI0;                            \fR
z[3,2] \(eq \fIr+i\(**p;                        \fR
z[3,3] \(eq \fIp\(**(1\-4\(**b\(**x)\-i\(**(r\-4\(**p\(**c\(**x);    \fR

 z

TIME: 476 MS
.)b

\fI
.ne 2
COMMENT
.br
.fi
Tell the system that z is the frame connection.
.br
.nf
;

setcon (z,1);

\fR
 z

TIME: 51 MS

\fI
.ne 2
COMMENT
.br
.fi
Compute the metric tensor from the frame connection z and the frame
metric eta.
.br
.nf
;
.(b M
metric();
\fR
computing g
COFACTOR finished.
DETERM finished.
INVERT finished.

 g

TIME: 2108 MS
.)b

\fI
.ne 2
COMMENT
.br
.fi
Compute the spin coefficients.
.br
.nf
;
.(b M
gamma();
\fR
computing gam
computing z#c
SHIFT finished.

 gam

TIME: 46563 MS
.)b
\fI
.ne 2
COMMENT
.br
.fi
Compute and display the frame Riemann tensor and frame Ricci tensor.
.br
.nf
;
.(b M
frriemann();
\fR
computing frri
computing gam#b
SHIFT finished.

 frri

TIME: 76670 MS
.)b
\fI
.ne 2
COMMENT
.br
.fi
The two components indicate that this metric is Petrov type N.
.br
.nf
;
\fR
.(b M
\fI
frri[];
\fR
PNAME:               frri
INDEXED:             FRAME
COORDS:              (u r x y)
INDICES:             (4 (0 0 0 0) (3 3 3 3))
CONCOV:              (\-2 \-2 \-2 \-2)
MULTIPLIER:          (1 . 1)
TYPE:                FRRIEMANN
SYMMETRY:            (((\-1) 1 2) ((\-1) 3 4) ((2) 1 3))
.)b
.(b M
                                             3
 frri                 \(eq (3 (8 SQRT(x) I f u x  \- 2 SQRT(x) f k x + 16 
     (1) (2) (1) (2) 

                  5                      4            2
       SQRT(x) f x  \- I a k r + 8 I a r x  \- 4 a r u x ))/(8 SQRT(x) f

      2
     k  s x)
.)b

                                                3
 frri                 \(eq (3 ( \- 8 SQRT(x) I f u x  \- 2 SQRT(x) f k x + 
     (1) (3) (1) (3) 

                     5                      4            2
       16 SQRT(x) f x  + I a k r \- 8 I a r x  \- 4 a r u x ))/(8 SQRT(x

         2
    ) f k  s x)


 frri

TIME: 425 MS
\fI
.(b M
frricci();
\fR
computing frric
\(**\(** this metric is a vacuum solution.

 frric

TIME: 561 MS
.)b
\fI
.(b M
frric[];
\fR
PNAME:               frric
INDEXED:             FRAME
COORDS:              (u r x y)
INDICES:             (2 (0 0) (3 3))
CONCOV:              (\-2 \-2)
MULTIPLIER:          (1 . 1)
TYPE:                FRRICCI
SYMMETRY:            (((1) 1 2))


 frric

TIME: 68 MS
.)b
\fI
.ne 2
COMMENT
.br
.fi
Display the appropriate spin coefficients. gam[0,2,2] \(eq 0 implies
shear-free, gam[0,2,3]\ \(!\(eq\ 0 implies twisting and expanding.
.br
.nf
;
.(b M
gam[0,2,2];
\fR

 0

TIME: 34 MS
.)b
\fI
.(b M
gam[0,2,3];
\fR

             3
 (SQRT(x) I a  f x + r)/s

TIME: 51 MS
.)b
\fI
.(b M
dir();
\fR
  name          type         elements prot  coordinates     concov
  frric         FRRICCI          0     W    (u r x y)       (\-2 \-2)
  frri          FRRIEMANN        2     W    (u r x y)       (\-2 \-2 \-2 \-2)
  gam#b         GAMMA            16    W    (u r x y)       (2 \-2 \-2)
  gam           GAMMA            8     W    (u r x y)       (\-2 \-2 \-2)
  z#c           CONNECTION       13    W    (u r x y)       (\-2 1)
  g#INV         METRIC           8     W    (u r x y)       (1 1)
  g             METRIC           8     W    (u r x y)       (\-1 \-1)
  z             CONNECTION       11    W    (u r x y)       (\-2 \-1)
  eta           METRIC           2     W    NIL             (\-2 \-2)

 10 object(s),     Total elements: 70


T
.)b
\fR
.fo ``-5.%-``
.bp 1
\fRExample 5

REDUCE 3.2 with tensor system, 15\-Apr\-85 ...
\fI
.ne 2
COMMENT
.br
.fi
This Reduce script evaluates the Ricci tensor for the Kerr metric 
in Boyer-Lindquist coordinates to show that the metric is  indeed
a  vacuum  solution.  The  total cpu running-time on a SUN 3/160 
is about 22 sec. 
.br
Below is the line-element for the metric. The functions  delta(r)
and  rho2(r,th) will remain unevaluated until the Ricci tensor is
computed, however, the derivatives of  these  functions  will  be
evaluated. 
.br
.nf
;

ds :\(eq \- delta/rho2\(**(d(t)\-a\(**sin(th)^2\(**d(ph))^2
   + sin(th)^2/rho2\(**((r^2+a^2)\(**d(ph)\-a \(** d(t))^2
   + rho2/delta \(** d(r)^2+rho2\(**d(th)^2;
\fR

            2     2       2        2  2             2      2
 ds :\(eq (d(r)  rho2  + d(t)  SIN(th)  a  delta \- d(t)  delta  \- 2 d(t) 

                     2  3                             2    2
        d(ph) SIN(th)  a  delta \- 2 d(t) d(ph) SIN(th)  a r  delta + 2

                           2        2        2           2        2
         d(t) d(ph) SIN(th)  a delta  + d(th)  delta rho2  \- d(ph)  

               4  2      2        2        2  4                2
        SIN(th)  a  delta  + d(ph)  SIN(th)  a  delta + 2 d(ph)  

               2  2  2              2        2  4
        SIN(th)  a  r  delta + d(ph)  SIN(th)  r  delta)/(delta rho2)

\fI.ne 2
COMMENT
.br
.fi
Define the  general  functions  delta(r),  rho2(r,th)  and  their
derivatives.
.br
.nf
;

depend delta,r;


depend rho2,r,th;


let df(rho2,r) \(eq 2\(**r;


let df(delta,r) \(eq 2\(**r\-2\(**m;


let df(rho2,th) \(eq \-2\(**a^2\(**sin(th)\(**cos(th);

.ne 2
COMMENT
.br
.fi
The let rule below is vitally important.  It allows considerable
simplification of expressions and prevents intermediate expression
swell.  Without this rule, this demo take more than twice as long to
run.
.br
.nf
;

let r^2\(eqsin(th)^2\(**a^2\-a^2+rho2;


on time, flgdot;

\fR
TIME: 1156 MS
\fI
.ne 2
COMMENT
.br
.fi
Compute the metric tensor from the line-element, and simplify the 
inverse metric. 
.br
.nf
;
.(b M
metric (ds);
\fR
computing g
COFACTOR finished.
DETERM finished.
INVERT finished.

 g

TIME: 816 MS
.)b
\fI
.(b M
mapfi(g#INV);
\fR
(3 3)
 g#INV

TIME: 459 MS
.)b
\fI.ne 2
COMMENT
.br
.fi
Compute the first  and  second  Christoffel  symbols.  The  first
Christoffel  symbols  are  symmetric  in  their  first and second
indices, the second Christoffel symbols are  symmetric  in  their
second and third indices, and have a contravariant first index. 
.br
.nf
;
.(b M
christoffel2();
\fR
computing c2
computing c1
(3 3 3)
CHRISTOFFEL1 finished.
(3 3 3)
 c2

TIME: 6698 MS
.)b
\fI
.ne 2
COMMENT
.br
.fi
Compute the fully covariant Riemann curvature tensor. This object 
has the full Riemann symmetry. 
.br
.nf
;
.(b M
riemann();
\fR
computing ri
(2 3 2 3)
 ri

TIME: 7803 MS
.)b
\fI
.ne 2
COMMENT
.br
.fi
Compute  the  fully  covariant  Ricci  tensor.  This  object   is
symmetric in its two indices. 
.br
.nf
;
.(b M
ricci();
\fR
computing ric
(3 3)
 ric

TIME: 2635 MS
.)b
\fI
.ne 2
COMMENT
.br
.fi
Display the (unsimplified) components of the  Ricci tensor. 
.br
.nf
;
\fR
.(b M
\fI
ric[];
\fR
PNAME:               ric
INDEXED:             TENSOR
COORDS:              (t r th ph)
INDICES:             (2 (0 0) (3 3))
CONCOV:              (\-1 \-1)
MULTIPLIER:          (1 . 1)
TYPE:                RICCI
SYMMETRY:            (((1) 1 2))
.)b
.(b M
                   4  4            2  2              2  2
 ric     \(eq (SIN(th)  a  \- 2 SIN(th)  a  m r + SIN(th)  a  rho2 \- 2 m r
    0 0 

                          2                   3
             delta \- delta  + delta rho2)/rho2
.)b
.(b M
                   2              4  4            2  2
 ric     \(eq (SIN(th)  a ( \- SIN(th)  a  + 2 SIN(th)  a  m r \- 2 
    0 3 

                      2  2                                        2
               SIN(th)  a  rho2 + 2 m r delta + 2 m r rho2 + delta  \- 

                   2       3
               rho2 ))/rho2
.)b
.(b M
                      2  2
 ric     \(eq ( \- SIN(th)  a  + 2 m r + delta \- rho2)/(delta rho2)
    1 1 
.)b
.(b M
                        6  6            4  4                  4  4
 ric     \(eq (r   (SIN(th)  a  \- 2 SIN(th)  a  delta + 2 SIN(th)  a  
    1 2      th

                               2  2      2            2  2
                 rho2 + SIN(th)  a  delta  \- 2 SIN(th)  a  delta rho2

                           2  2     2       3              3
                  + SIN(th)  a  rho2  + rho2 ))/(delta rho2 )

.)b
.(b M
                   2  2
 ric     \(eq (SIN(th)  a  \- 2 m r \- delta + rho2)/rho2
    2 2 
.)b
.(b M
                   2         6  6            4  4                4  4
 ric     \(eq (SIN(th)  (SIN(th)  a  \- 2 SIN(th)  a  m r + 3 SIN(th)  a  
    3 3 

                               2  2                      2  2
               rho2 \- 2 SIN(th)  a  m r delta \- 4 SIN(th)  a  m r rho2

                         2  2      2          2  2
                \- SIN(th)  a  delta  \- SIN(th)  a  delta rho2 + 3 

                      2  2     2             2             2       3
               SIN(th)  a  rho2  \- 2 m r rho2  \- delta rho2  + rho2 ))

                3
           /rho2


 ric

TIME: 867 MS
.)b
\fI
.ne 2
COMMENT
.br
.fi
Now define the functions delta(r) and rho2(r,th).
.br
.nf
;

clear r^2;

let delta \(eq r^2 \- 2\(**m\(**r + a^2;


let rho2 \(eq r^2 + a^2\(**cos (th)^2;


.ne 2
COMMENT
.br
.fi
Simplify the Ricci tensor with the above definitions.
.br
.nf
;
.(b M
mapfi(ric);
\fR
(3 3)
 ric

TIME: 1020 MS
.)b
\fI.ne 2
COMMENT
.br
.fi
Display the entire Ricci tensor. No values imply that it is zero.
.br
.nf
;
.(b M
ric[];
\fR
PNAME:               ric
INDEXED:             TENSOR
COORDS:              (t r th ph)
INDICES:             (2 (0 0) (3 3))
CONCOV:              (\-1 \-1)
MULTIPLIER:          (1 . 1)
TYPE:                RICCI
SYMMETRY:            (((1) 1 2))


 ric

TIME: 85 MS
.)b
\fI
.ne 2
COMMENT
.br
.fi
Display a directory of all objects defined in the system.
.br
.nf
;
.(b M
dir();
\fR
  name          type         elements prot  coordinates     concov
  ric           RICCI            0     W    (t r th ph)     (\-1 \-1)
  ri            RIEMANN          13    W    (t r th ph)     (\-1 \-1 \-1 \-1)
  c2            CHRISTOFFEL2     20    W    (t r th ph)     (1 \-1 \-1)
  c1            CHRISTOFFEL1     20    W    (t r th ph)     (\-1 \-1 \-1)
  g#INV         METRIC           5     W    (t r th ph)     (1 1)
  g             METRIC           5     W    (t r th ph)     (\-1 \-1)

 6 object(s),     Total elements: 63


T
.)b
