%******************************************************************************
%  FILE = shift.red 				Tue May 19 15:31:41 EDT 1987
% 
%  Procedures in this file:
%  
%  SHIFT SHIFT* PARSEAT MKSHFT SHFTC SHFTFND CMPCONCOV 
%  GENSHFT MKSHFTNME NEWSYM NEWSYM1
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);

FLAG ('(SHIFT), 'OPFN);     % parsing declaration.

SYMBOLIC PROCEDURE SHIFT (U);  % user interface to shift routine.
  SHIFT!* (U, 'NIL);    % flag is off, dont make a new object.

% shift* is the routine which computes or finds the shifted objects
% generated from a parent indexed object.
% if flg is on and the requested object does not exist, it will be
% created, otherwise shift* returns an unevaluated form.

SYMBOLIC PROCEDURE SHIFT!* (INP, FLG);
BEGIN SCALAR TNSR, INDEX, LEX, CONCOV, LIS, TNSR1, TNSR2, TNSRP;
  IF FREE1 (MYCADDR (INP), '!*AT!*) THEN RETURN (INP); % no shifts
  TNSR := MYCADR (INP);
    % conjugate shift of parent of conjugate object.
  IF MYCDR (LEX := GET (TNSR, 'CONJUGATE)) THEN 
    RETURN (CONJRDR (SHIFT!* (LIST ('RDR, MYCAR (LEX), 
                MYCADDR (INP), MYCADDDR (INP)), FLG)));
  TNSRP := GET (TNSR, 'PNAME);   		% parent name of the object.
  INDEX := MYCADDR (INP);
  IF NOT INDEX THEN RETURN ('NIL);
  FLG := MYCAR (GET (TNSRP, '!*AT!*)) OR FLG; % cant shift if car of *at* is 't
  LEX := SHFTC (INDEX, GET (TNSR, 'CONCOV)); % generate a new concov, 
                                               % and clear the index of shifts.
  INDEX := MYCAR (LEX);
  CONCOV := MYCADR (LEX);
      % look for an object that matches, or the nearest.
  LEX := SHFTFND (TNSRP, CONCOV);
  IF NOT MYCADR (LEX) THEN RETURN (LIST ('RDR, MYCAR (LEX), INDEX, MYCADDDR (INP)))
  ELSE IF FLG THEN RETURN (INP);   % found it, or cant make it.
  TNSR1 := MYCAR (LEX);
  LEX := MKSHFT (TNSR1, MYCADR (LEX)); % generate metric contractions.
  TNSR2 := MKSHFTNME (TNSRP, CONCOV, GET (TNSRP, 'CONCOV)); % new name
  WRITE ("computing ", TNSR2);
  TERPRI (); 
  
  PUT (TNSR2, 'SYMMETRY, NEWSYM (GET (TNSRP, 'SYMMETRY), CONCOV));
  EVALTNSR1 (TNSR2, MYCAR (LEX), MYCADR (LEX), 'NIL); % generate elements
  PUT (TNSR2, 'CONCOV, CONCOV);
  PUT (TNSR2, 'PNAME, TNSRP);     % give it a parent
  PROTECT!* (TNSR2, 'W);            % protect it and the parent
  PROTECT!* (TNSR, 'W);
  PUT (TNSR2, 'TYPE, GET (TNSRP, 'TYPE));
  PUT (TNSRP, '!*AT!*, APPEND (APPEND (LIST ('NIL, TNSRP), % add offspring to the
         MYCDDR (GET (TNSRP, '!*AT!*))), LIST (TNSR2))); % parent list
  CLEANER ('SHIFT);
  RETURN (LIST ('RDR, TNSR2, INDEX, MYCADDDR (INP)));
END; 

PUT('!@, 'STAT, 'PARSEAT);    % parsing function for @
% parseat is the parsing routine for shift operations (@).
 
SYMBOLIC PROCEDURE PARSEAT;
BEGIN SCALAR LEX;
  LEX := XREAD ('T);     % read following form
  IF LEX EQ '!# THEN RETURN (LEX)   % can't shift Bach brackets 
  ELSE IF NOT ATOM (LEX) AND CHECKTYPE (MYCAR (LEX), '!*AT!*) THEN
    RETURN (MYCADAR (LEX))    % was @@a --> a
  ELSE RETURN (LIST (LIST ('!*AT!*, LEX)));
END;

% mkshft generates a times list of the given object and metric contractions
% in the slots indicated.

SYMBOLIC PROCEDURE MKSHFT (TNSR, SLOT);
BEGIN SCALAR INDEX, INDEXO, CONCOV, I, K, INDICE, LEX, LEX1,
                VALUE;
  CONCOV := GET (TNSR, 'CONCOV);
  INDEXO := INDEX := HEAD (ALPHALIST!*, 
                     I := MYCAR (GET (TNSR, 'INDICES)));
  VALUE := LIST ('RDR, TNSR, INDEX) . VALUE;
  I := I + 1;
  WHILE SLOT DO <<
    K := MYCAR (SLOT);
    SLOT := MYCDR (SLOT);
    LEX := GETMET (NTH (CONCOV, K));   % get appropriate metric
    INDICE := NTH (ALPHALIST!*, I);    % get contraction indice
    VALUE := LIST ('RDR, LEX, 
               LIST (NTH (INDEX, K), INDICE)) . VALUE;
    INDEXO := INSERT (INDEXO, INDICE, K, 'T);  % replace output indice
    I := I + 1
  >>;
  RETURN (LIST (INDEXO, 'TIMES . REVERSE (VALUE)));
END;

% shftc takes an index with shift operators and a concov list and
% return a list of the clean index and the concov list generated by
% the shifts.

SYMBOLIC PROCEDURE SHFTC (INDEX, CONCOV);
BEGIN SCALAR LEX, LEX1;
  WHILE INDEX AND CONCOV DO <<
    IF MYCAR (FDERIV (INDEX)) = 1 THEN << % skip deriv ops. (?)
      LEX1 := MYCAR (INDEX) . LEX1;
      INDEX := MYCDR (INDEX)
    >>
    ELSE IF CHECKTYPE (MYCAR (INDEX), '!*AT!*) THEN <<  % shift op
      LEX := (-MYCAR (CONCOV)) . LEX;            % shift indice
      LEX1 := MYCADAR (INDEX) . LEX1;	       % remove op
      INDEX := MYCDR (INDEX);
      CONCOV := MYCDR (CONCOV)
    >> ELSE <<			% normal indice
      LEX := MYCAR (CONCOV) . LEX;
      LEX1 := MYCAR (INDEX) . LEX1;
      INDEX := MYCDR (INDEX);
      CONCOV := MYCDR (CONCOV)
    >>
  >>;
  RETURN (LIST (APPEND (REVERSE (LEX1), INDEX), REVERSE (LEX)));
END;

% shftfnd locates an object which most nearly matches the one we
% are looking for by searching through the *at* property list on
% the parent. it returns the name of the closest relative and a list
% of pointers to where metric contractions must be made to get to the
% object we want. if the pointer list is empty, the object we want
% already exists.

SYMBOLIC PROCEDURE SHFTFND (TNSR, CONCOV);
BEGIN SCALAR LEX, LEX1, LEX2, LEX3, LIS, FLG;
  LEX := GET (TNSR, '!*AT!*);% list of all existing offspring, parent name 1st
  FLG := MYCAR (LEX); 
  LEX := MYCDDR (LEX);
  LEX1 := TNSR;
  LEX2 := CMPCONCOV (CONCOV, GET (TNSR, 'CONCOV)); % compare concov lists
  WHILE LEX DO <<  % check all remaining objects in list.
    IF NOT INDEXED (MYCAR (LEX)) THEN LEX := MYCDR (LEX) % drop deleted object names
    ELSE IF LENGTH (LEX2) > LENGTH (LEX3 :=  % found a closer match
                CMPCONCOV (CONCOV, GET (MYCAR (LEX), 'CONCOV))) THEN <<
      LEX1 := MYCAR (LEX);
      LEX2 := LEX3;
      LIS := MYCAR (LEX) . LIS;
      LEX := MYCDR (LEX)
    >> ELSE <<
      LIS := MYCAR (LEX) . LIS;
      LEX := MYCDR (LEX)
    >>
  >>;
  PUT (TNSR, '!*AT!*, APPEND (LIST (FLG, TNSR), LIS)); % reset offsping list
  RETURN (LIST (LEX1, LEX2));  % name and pointers
END;

% cmpconcov compares concov list element by element and returns a list
% of pointers to where they differ.

SYMBOLIC PROCEDURE CMPCONCOV (EX, EX1);
BEGIN SCALAR K, LEX2;
  K := 1;
  WHILE EX DO <<
    IF NOT MYCAR (EX) = MYCAR (EX1) THEN LEX2 := K . LEX2;
    EX := MYCDR (EX);
    EX1 := MYCDR (EX1);
    K := K + 1
  >>;
  RETURN (REVERSE (LEX2));
END;

% genshft takes and index and 2 concov list and returns an index
% with shift ops written in where the concov lists differ.
% its like shftc in reverse.

SYMBOLIC PROCEDURE GENSHFT (INDEX, CONCOV1, CONCOV2);
BEGIN SCALAR LIS;
  WHILE INDEX DO <<
    IF MYCAR (CONCOV1) = MYCAR (CONCOV2) THEN LIS := MYCAR (INDEX) . LIS
    ELSE LIS := LIST ('!*AT!*, MYCAR (INDEX)) . LIS;
    CONCOV1 := MYCDR (CONCOV1);
    CONCOV2 := MYCDR (CONCOV2);
    INDEX := MYCDR (INDEX)
  >>;
  RETURN (APPEND (REVERSE (LIS), INDEX));
END;

% mkshftnme generates a unique name based on the parent name and
% the difference between the parent concov list and the offspring
% concov list expressed as a base 16 number. its kinda complex to
% explain here.

SYMBOLIC PROCEDURE MKSHFTNME (TNSR, CONCOV1, CONCOV2);
BEGIN SCALAR LIS, LEX;
  LIS := CMPCONCOV (CONCOV1, CONCOV2);
  IF NOT LIS THEN RETURN (TNSR);
  LEX := 0;
  WHILE LIS DO <<  % build a number to rep tail of name.
    LEX := LEX + EXPT (2, MYCAR (LIS) - 1);
    LIS := MYCDR (LIS)
  >>;
  WHILE NOT LEX = 0 DO <<  % convert above number to chars.
    LIS := MASCII (REMAINDER (LEX, 16) + 97) . LIS;
    LEX := QUOTIENT (LEX, 16)
  >>;
  RETURN (MAKENAME (APPEND (APPEND (EXPLODE (TNSR), '(!#)), LIS)));
END;

% newsym construct the symmetry list for the new object from the
% parent symmetry. 

SYMBOLIC PROCEDURE NEWSYM (SYM, CONCOV);
BEGIN SCALAR EX1;
  WHILE SYM DO <<
    EX1 := APPEND (EX1, NEWSYM1 (MYCAR (SYM), CONCOV));
    SYM := MYCDR (SYM)
  >>;
  RETURN (EX1);
END;

% newsym1 looks at each independent symmetry and sees if any part of it
% survives having indices shifted.

SYMBOLIC PROCEDURE NEWSYM1 (SYM, CONCOV);
BEGIN SCALAR LEN, LEX, SZE, CBLK, LEX1, CFLG, EX1, HERM;
  IF ATOM (MYCAR (SYM)) THEN <<
    HERM := 'T;
    SZE := 2
  >> ELSE <<
    SZE := MYCAAR (SYM);    	% size of block (plus sign)
    CFLG := MYCDAR (SYM)           % conjugate flag
  >>;
  SYM := MYCDR (SYM); 		% pointer list
  LEN := MAX (ABS (SZE), 1);    % real block size; 0 --> 1
    % for each pointer, create an assoc pair with the appropriate sublist
    % of the concov as the key, and the pointer as the value. if a pair
    % with the same key exists, append the pointer to those already there.
    % note we dont delete the old pair, hence the member test below.
  WHILE SYM DO <<
    LEX := MAP43 (SUBLIST (CONCOV, MYCAR (SYM), LEN));
    CBLK := (LEX . APPEND (MYCDR (ASSOC (LEX, CBLK)), LIST (MYCAR (SYM))))
                        . CBLK;
    SYM := MYCDR (SYM)
  >>;
  % all pairs with 2 or more pointers are valid independent symmetry lists
  WHILE CBLK DO <<
    IF NOT MEMBER (MYCAAR (CBLK), LEX1) AND MYCDDAR (CBLK) THEN
      IF HERM THEN EX1 := ('H . MYCDAR (CBLK)) . EX1
      ELSE EX1 := ((SZE . CFLG) . MYCDAR (CBLK)) . EX1;
    LEX1 := MYCAAR (CBLK) . LEX1;
    CBLK := MYCDR (CBLK);
  >>;
  RETURN (EX1);
END;

;END;
