/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: animSupport.c,v 1.2 1993/04/13 17:42:37 gbourhis Exp $";
#endif


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>

#ifdef HDF32
#include <hdf/hdf.h>
#else
#include "hdf/df.h"
#endif

#include "list.h"
#include "net.h"
#include "netdata.h"
#include "animUI.h"


#ifndef MALLOC
#  define MALLOC  malloc
#  define FREE    free
#endif /* ! MALLOC */

extern void NewAnimation();
extern void ChangeAnimation();
extern void AnimNewPalette();

AnimationSetup(rootWidget,appContext)
Widget rootWidget;
XtAppContext appContext;
{
	NetRegisterModule(ANIM_MODULE_NAME,NETANIM,
			NewAnimation,0,ChangeAnimation,0,0,0);
	NetRegisterModule(ANIM_MODULE_NAME,NETPAL,
			AnimNewPalette,0,AnimNewPalette,0,0,0);
	AnimationInit(rootWidget,appContext);
}

AnimationExit()
/* call me so I can free all the pixmaps  before program exit()*/
{
	AnimExit();
}
