/**************************************************
 * call.c: main for testing X HDF Browser
 **************************************************/

#include "hbox.h"
#include <Xm/MainW.h>

void CBExitMain();
void CallHDFBrowser(); 
void load();
void quit();
void send_call();
void CBVoid();

Widget   W;
char file_name[100];

main (argc, argv)
     int   argc;
     char *argv[];
{
  Arg      wargs[10];
  Widget   menuBar;
  Widget   exitButton;
  Widget   hdfButton;
  Widget   mainWin0;         /* window ID of calling application */
  XmString label;
  Cardinal n = 0;

  if(argc < 2) {
    printf("Usage:\n");
    printf("\t%s hdf-file\n", argv[0]);
    exit(1);
  }

  W = XtInitialize(argv[0], "Xhdf", NULL, 0, &argc, argv);
  strcpy(file_name, argv[1]);

  n = 0;
  XtSetArg(wargs[n], XmNheight, 70); n++;
  XtSetArg(wargs[n], XmNwidth, 150); n++;
  XtSetArg(wargs[n], XmNtitle, "HBoX"); n++;
  mainWin0 = XmCreateMainWindow(W, "mainWin0", wargs, n);
  XtManageChild (mainWin0);

  n = 0;
  menuBar = XmCreateMenuBar(mainWin0, "Menubar", wargs, n);
  XtManageChild (menuBar);

  n = 0;
  label = XmStringCreateLtoR("Exit", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  exitButton = XmCreateCascadeButton(menuBar, "exitButton", wargs, n);
  XtAddCallback(exitButton, XmNactivateCallback, CBExitMain, W);
  XtManageChild (exitButton);

  n = 0;
  label = XmStringCreateLtoR("XHDF Browser", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  hdfButton = XmCreateCascadeButton(menuBar, "HDFButton", wargs, n);
  XtAddCallback(hdfButton, XmNactivateCallback, CallHDFBrowser, mainWin0);
  XtManageChild (hdfButton);

  XtRealizeWidget (W);

  XtMainLoop ();
}

/*
**
*/
void CallHDFBrowser(w, client_data, call_data)
     Widget   w;
     Widget   client_data;
     caddr_t  call_data;
{
  int hb_status;

  hb_status = hbMain(W, file_name, NULL, send_call, CBVoid);

  if (hb_status == FAIL)
    printf("failed after hbMain in main()\n\n");

}

/*
**
*/
void load(browseShell)
     Widget browseShell;
{

#if DEBUG 
  printf ("in load of call.c\n");   /* */
#endif


#if DEBUG
  printf ("done in load\n"); /* */
#endif
} /* load */

/*
**
*/
void send_call(num, tr)
     int num;
     uint16 tr[][2];
{
  int i;

#if DEBUG 
  printf ("in send of call.c got %d values\n", num); 
#endif

  for(i = 0; i < num; i++) {
    printf("Value #%d:  tag %d  ref %d\n", i, tr[i][0], tr[i][1]);
  }

#if DEBUG
  printf ("done in send\n"); /* */
#endif
} /* send */

void CBExitMain(w, client_data, call_data)
     Widget   w;
     caddr_t  client_data;
     caddr_t  call_data;
{
#if DEBUG
  printf("in CBExitMain\n");
#endif

  XtCloseDisplay(XtDisplay(w));
  exit (0);
}

void CBVoid() 
{
#if DEBUG 
printf("in void\n");
#endif
}
