/************************************************************************
vpc_plan.c    planetary functions
************************************************************************/


#include <stdio.h>
#include <math.h>
#include <time.h>
#include <stdlib.h>
#include <assert.h>
#include "vpc_play.h"


//THIS ROUTINE DETERMINES SPEED OF COMPUTER PLAYER (majority of time spent here)
int find_nearest_planets(SHIPTYPE *me_too, int nearM[6], long nearD[6], int mission_mode)
{  // sorts planet listing by distance weighting by mission mode
//drawback:  algorithm is SLOW.... can be sped up if i feel like it
//but too lazy right now   no need to sort all planets+use qsort not bubble
  int i; long dist=2147483647L;
  int array_closest_ID[500];
  long array_closest_d[500];
  //int array_closest_pointer=1;
  int back_tracker=1;
  long tempd; int tempID;
  int x,y;
  int run_factor;
  int defender;
  //PLANTYPE ball;
  HULLSPEC hullv;
  //now global arrays are intelligence reports (may or may not be accurate)
  //colonists natives money defenses mines factories <--- are the arrays

  assert(me_too);
  LHull( &hullv, me_too->hull );

  x=me_too->xShip;
  y=me_too->yShip;
  for(i=1;i<=500;i++) {
    array_closest_d[i-1]=2147483647L;  //note minor bug in far-space greater
    //than 2147483647 light years cant find planets at all causality protects
    //us fearless computer players... 2 billion ly is approx 1/5-1/10 universe
    array_closest_ID[i-1]=0;
  }

  for(i=1;i<=500;i++) {
    dist=(ABS(x-xPlanet[i-1])+ABS(y-yPlanet[i-1]));
    //insertion sort it here into array

    //HACK ALERT HACK ALERT HACK ALERT
    //if(CLIP_CHEAT(4)) {
  switch(mission_mode) {
    case 4: //warship mode
      //only consider enemy planets
      run_factor = 300;
      if(strategy_option & STRATEGY_AGGRESSIVE) run_factor *= 2.0;
      if(strategy_option & STRATEGY_DEFENSIVE) run_factor *= .5 ;

      if((rPlanet[i-1]!=0&&rPlanet[i-1]!=race)
	||(abrain[i-1]==ABRAIN_ATTACK) ) { //enemy planet or request attack
	dist -= run_factor;
	if(abrain[i-1]==ABRAIN_ATTACK) dist -= run_factor; //again to concentrate
	if(rBase[i-1]!=race) {
	  dist -= run_factor; //concentrate on enemy bases
	}
	if(factories[i-1]>=100&&colonists[i-1]>=factories[i-1]) dist -= run_factor;//industrial planets
	//note how pop centers cumulative effect
	if(colonists[i-1]>=10000) dist -= run_factor; //population centers
	if(colonists[i-1]>=1000) dist -= run_factor/2;//med pop centers
	if(colonists[i-1]>=100) dist -= run_factor/2; //small pop centers
	if(mines[i-1]>=100&&colonists[i-1]>=mines[i-1]) dist -= run_factor; //mines
	//how about attacking planets with many defences?  they must be
	//important or the enemy wouldnt put defences there!
	if(defenses[i-1]>50) dist -= run_factor/3;
	if(defenses[i-1]>300) dist += run_factor/2; //getting scary defenses
      }
      //shouldnt prefer own planets to neutrals now with pickup logic
      if(rPlanet[i-1]==0) {
	if(dominion[i-1] && me_too->col )
		dist -= run_factor;
	//if(dominion[i-1]==0)
	//	dist += run_factor; //weak repulsion (turned out bad)
      }
    break;
    case 74: //crystal minelayer mode
      run_factor = 300;
      if(strategy_option & STRATEGY_AGGRESSIVE) run_factor *= 2.0;
      if(strategy_option & STRATEGY_DEFENSIVE) run_factor *= .5 ;

      if(rPlanet[i-1]==0) {  //neutral planets
	if(is_planet_in_a_friendly_minefield(i)==0)
		dist -= run_factor/4;
      } else if(rPlanet[i-1]==race) { //own planets
	if(is_planet_in_a_friendly_minefield(i)==0)
		dist -= run_factor/2;
      } else if(rPlanet[i-1]!=race) { //enemy planet
	if(is_planet_in_a_friendly_minefield(i)==0)
		dist -= run_factor;
      }
      if(planet_in_a_minefield[i-1]) {  //in enemy minefield stay away maybe
	if(wmine[planet_in_a_minefield[i-1]-1]==0)
		dist += run_factor/2;
	if(wmine[planet_in_a_minefield[i-1]-1])  //unecessary since only
		dist += run_factor*2;  //tholians have web mines but just in case
      }
      //i cant handle enemy minefields ill blow up im so shrimpy
    break;
    case 75: //robot minelayer mode
      run_factor = 300;
      if(strategy_option & STRATEGY_AGGRESSIVE) run_factor *= 2.0;
      if(strategy_option & STRATEGY_DEFENSIVE) run_factor *= .5 ;

      if(rPlanet[i-1]==0) {  //neutral planets
	if(is_planet_in_a_friendly_minefield(i)==0)
		dist -= run_factor/4;
      } else if(rPlanet[i-1]==race) { //own planets
	if(is_planet_in_a_friendly_minefield(i)==0)
		dist -= run_factor/2;
      } else if(rPlanet[i-1]!=race) { //enemy planet
	if(is_planet_in_a_friendly_minefield(i)==0)
		dist -= run_factor;
      }
      if(planet_in_a_minefield[i-1]) {  //in enemy minefield stay away maybe
	if(wmine[planet_in_a_minefield[i-1]-1]==0)
		dist += run_factor/2;
	if(wmine[planet_in_a_minefield[i-1]-1])  //unecessary since only
		dist += run_factor*2;  //tholians have web mines but just in case
      }
      //i cant handle enemy minefields ill blow up im so shrimpy
    break;
    case 104: //warship mode lizard special ship drop mode
      //only consider enemy planets
      run_factor = 300;
      if(strategy_option & STRATEGY_AGGRESSIVE) run_factor *= 2.0;
      if(strategy_option & STRATEGY_DEFENSIVE) run_factor *= .5 ;

      if((rPlanet[i-1]!=0&&rPlanet[i-1]!=race)
	||(abrain[i-1]==ABRAIN_ATTACK) ) { //enemy planet or request attack
	dist -= run_factor;

	if(factories[i-1]>=100&&colonists[i-1]>=factories[i-1])
		dist -= run_factor/3;//industrial planets

	//note how pop centers cumulative effect
	if(colonists[i-1]>=10000) dist -= run_factor/3; //population centers
	if(colonists[i-1]>=1000) dist -= run_factor/3;//med pop centers
	if(colonists[i-1]>=100) dist -= run_factor/3; //small pop centers

	if(mines[i-1]>=100&&colonists[i-1]>=mines[i-1])
		dist -= run_factor/3; //mines

	//defences reduce ground ratio so avoid
	if(defenses[i-1]>100) dist += run_factor/2;
	if(defenses[i-1]>200) dist += run_factor/2;
	if(defenses[i-1]>300) dist += run_factor/2; //getting scary defenses
      }
      //shouldnt prefer own planets to neutrals now with pickup logic
      if(rPlanet[i-1]==0) {
	if(dominion[i-1] && me_too->col )
		dist -= run_factor;
	//if(dominion[i-1]==0)
	//	dist += run_factor; //weak repulsion (turned out bad)
      }
    break;
    case 124:  //lizard special ship pick up mode
      if(rPlanet[i-1]==race&&pbrain[i-1]>500) { //not a crapper planet
	if(colonists[i-1] > hullv.cargo * 10) {
		defender=has_a_defender(i);
		dist -= 250;
		if(defender) dist -= 50;//and its safe too
		if(factories[i-1]>50) dist -= 150; //industrial good
	}
      } else {
	dist += 2000;
      }
      //if(planet_in_a_minefield[i-1]) dist += 300;
    break;
    case 92: //egg pickup??
      if(rPlanet[i-1]==race&&pbrain[i-1]>500) { //not a crapper planet
	if(colonists[i-1] > hullv.cargo * 10) {
		defender=has_a_defender(i);
		dist -= 250;
		if(defender) dist -= 50;//and its safe too
		if(factories[i-1]>50) dist -= 150; //industrial good
	}
      } else {
	dist += 2000;
      }
      if(planet_in_a_minefield[i-1]) dist += 300;
    break;
    case 102: //egg dropoff??
      //should assert carrying colonists etc
      //bulk freighters  maybe should check for pure supply ship?
      //assert(me_too->col);
      if(planet_in_a_minefield[i-1]) dist += 300;
      if(rPlanet[i-1]==race) {
	if(colonists[i-1] < me_too->col/6 ) {
		defender=has_a_defender(i);
		dist -= 100;
		if(defender) dist -= 15;//and its safe too
		//if(abrain[i-1]==ABRAIN_DROP_SOME) dist -= 50;
		//if(abrain[i-1]==ABRAIN_DROP_MANY) dist -= 100;
		if(natives[i-1]) dist -= 200;
		if(factories[i-1]==0&&me_too->eleS) dist -= 20;
	}
	if(colonists[i-1] < me_too->col ) {
		defender=has_a_defender(i);
		dist -= 100;
		if(defender) dist -= 15;//and its safe too
		//if(abrain[i-1]==ABRAIN_DROP_SOME) dist -= 50;
		//if(abrain[i-1]==ABRAIN_DROP_MANY) dist -= 100;
		if(natives[i-1]) dist -= 200;
		if(factories[i-1]==0&&me_too->eleS) dist -= 20;
	}
	if(colonists[i-1] < me_too->col * 3 ) {
		defender=has_a_defender(i);
		dist -= 100;
		if(defender) dist -= 15;//and its safe too
		//if(abrain[i-1]==ABRAIN_DROP_SOME) dist -= 50;
		//if(abrain[i-1]==ABRAIN_DROP_MANY) dist -= 100;
		if(natives[i-1]) dist -= 200;
		if(factories[i-1]==0&&me_too->eleS) dist -= 20;
	}
	if(colonists[i-1] > me_too->col * 4 ) {
		dist += 400;
		//if(abrain[i-1]==ABRAIN_DROP_SOME) dist -= 50;
		//if(abrain[i-1]==ABRAIN_DROP_MANY) dist -= 100;
		if(factories[i-1]==0&&me_too->eleS) dist -= 50;
	}
	if(colonists[i-1] > 10000 && factories[i-1]) dist += 1000;
	if(rBase[i-1]==race && colonists[i-1] < 100) dist -= 500;

      } else if(rPlanet[i-1]!=0) { //enemy planet
	if(is_armed(me_too)==0) dist += 200;
	dist += 100;
      } else if(rPlanet[i-1]==0) { //neutral planet
	//do nothing for now
	dist -= 25; //curiosity factor
      }
      if(pcount>3 && dominion[i-1]==0) dist += 100;

    break;
    case 2: //egg explore mode?
      run_factor = 200;
      if(strategy_option & STRATEGY_AGGRESSIVE) run_factor *= 2.0;
      if(strategy_option & STRATEGY_DEFENSIVE) run_factor *= .5 ;

      if(rPlanet[i-1]!=0&&rPlanet[i-1]!=race) { //enemy planet stay away
	dist+=run_factor*2;
      }
      if(rPlanet[i-1]==race) { //my planet not interesting
	dist+=run_factor;
      }
    break;
    //} //clip cheat
    case 1:
      run_factor = 200;
      if(strategy_option & STRATEGY_AGGRESSIVE) run_factor *= .5;
      if(strategy_option & STRATEGY_DEFENSIVE) run_factor *= 2.0;


      if(rPlanet[i-1]!=race) {  //not own world, need to explore
	if(me_too->unplanet==i) {
	  dist += 200;  //unloading on this planet already dont stick around
	}
	if(dominion[i-1]) {
	  if(strategy_option & STRATEGY_DEFENSIVE) dist -= run_factor;
	  // stay in own regions
	}
	if(CHEAT_CLIP(4))
	  if(rPlanet[i-1]!=0 && is_armed(me_too)==0) {
	    dist += run_factor;  //only if i have weapons if its enemy
	  }
      } else { //rPlanet is mine avoid it
	 //unless it doesnt have supplies in which case go there again!!!
	 //LPlanet( &ball, i );
	 if(factories[i-1]) {
		dist += 600;
	 }
	 if(me_too->eleS && factories[i-1]==0) {
		dist -= 400; //better go there and factory it up
	 }
	 dist += 300;
      }
    break;
    case 99: //sentinel mode
      if(rPlanet[i-1]==race) { //my planet
		if(rBase[i-1]==race) dist += 1000; //away from own bases
		defender=has_a_defender(i);
		if(defender==0||defender==me_too->ID)
			dist -= MIN(300,pbrain[i-1]); //no sentinel
      } else if(rPlanet[i-1]==0) { //neutral planet
		if(dominion[i-1]==0) dist += 1000; //not in dominion ignore
		if(dominion[i-1]) {
			defender=has_a_defender(i);
			if(defender!=me_too->ID||defender==0) dist += 200;
		}
      } else if(rPlanet[i-1]!=race) { //enemy planet
		//already an attack ship there?
		if(dominion[i-1]) {
		  defender=has_a_defender(i);
		  if(defender==0&&defender!=me_too->ID)
			dist -= 300;  //let me take em out!!!
		}
      }
    break;
    default:
	printf("unknown mission mode %d\n", mission_mode);
	exit(1);
	break;
  } //end switch
    //HACK ALERT ENDS HACK ALERT ENDS

    if(i==1) { //special case first
      array_closest_ID[i-1]=i;
      array_closest_d[i-1]=dist;
    } else {
      array_closest_ID[i-1]=i;
      array_closest_d[i-1]=dist;
      back_tracker=i;
      assert(back_tracker>1);
      while(back_tracker>1&&array_closest_d[back_tracker-1]<array_closest_d[back_tracker-2])
      {	//switch them
	tempd=array_closest_d[back_tracker-1];
	tempID=array_closest_ID[back_tracker-1];
	array_closest_d[back_tracker-1]=array_closest_d[back_tracker-2];
	array_closest_ID[back_tracker-1]=array_closest_ID[back_tracker-2];
	array_closest_d[back_tracker-2]=tempd;
	array_closest_ID[back_tracker-2]=tempID;
	back_tracker--;
      }
    }
  }
  if(INFO_CLIP(5)) {
	  printf("Class %d Ship %d weighted closest planet listing:\n",
	  classlist[me_too->hull-1],me_too->ID);
  }
  for(i=1;i<=6;i++) {    //copy into arrays
	nearM[i-1]=array_closest_ID[i-1];
	nearD[i-1]=array_closest_d[i-1];
	if(INFO_CLIP(5)) {
	    printf("planet ID %d weighted distance %ld\n",
	    (int)nearM[i-1],(long)nearD[i-1]);
	}
  }
  return(array_closest_ID[0]); // returns ID of closest planet
}



// this is one gigantic cheater, computer does not use ships to move
// minerals, they just spontaneously beam around
void MoveMinerals () { //MoveMinerals  translated
//long x1=0 ;//AS LONG
//long size=0 ;//AS LONG
long p=0 ;//AS LONG
long nl=0 ;//AS LONG
long ml=0 ;//AS LONG
long tl=0 ;//AS LONG
long dl=0 ;//AS LONG
long mcl=0 ;//AS LONG
long sl=0; //added supplies Miikka
long v=0;//AS LONG
long count=0 ;//AS LONG
long top=0 ;//AS LONG
long topP=0 ;//AS LONG
int sw=0;
PLANTYPE plan;

   printf( "Beaming up minerals\n");
   count = 0;
   for( p = 1 ; p<=500;p++){// 500
      if(CLIP_CHEAT(2)) {
       if( rBase[p-1] ) {
	 abrain[p-1] = ABRAIN_ATTACK;  //note before abrain base
       }
      } //clip cheat
      if( rBase[p-1] == race ) {
	 count = count + 1;
	 abrain[p-1] = ABRAIN_STARBASE;//6
      } //If
      if( abrain[p-1] == 6 && rBase[p-1] != race ) { abrain[p-1] = 5;}//oops no base after all
      if( abrain[p-1] == 7 ) { abrain[p-1] = 5;}  //build base failed
      if( rPlanet[p-1] == race ) {
	 // maybe it means was base you destroyed it
	 if( rBase[p-1] != race ) {
	    if( abrain[p-1] == 5 || abrain[p-1] == 7 ) { // mine or buildbase
	       if( pbrain[p-1] > topP ) {
		  topP = pbrain[p-1];
		  top = p;
	       } //If
	    } //If
	 } //If

      } //If
   } //NEXT p

   if(pcount>9 || sbcount==0)  //must have at least 10 planets to do this
   if( top > 0 && topP > 500 ) {
      count = count + 1;
      abrain[top-1] = ABRAIN_BUILD_BASE; //7
   } //If

   if( count < 1 ) {
      printf( "No planets found\n");
      return;//EXIT int name_ () {
   } //If

   if(INFO_CLIP(1)) printf( "I have %d good planets\n",count);
   if(CLIP_CHEAT(1)) {
#ifdef COMPUTER_CHEATS
      for( p = 1 ; p<=500;p++){// 500
	 if( rPlanet[p-1] == race ) {
	    switch( abrain[p-1] ){
	       case 5: case 6: case 7:     //mine, base, buildbase
		  sw = 1;
		  break;
	       default:
		  sw = 0;
		  break;
	    }// SELECT
	    if( sw == 1 ) {
	       LPlanet(&plan, p);
	       if( plan.pNum == race && rBase[p-1] != race ) {
		  //REM
		  v = plan.eleM / 4;
		  if( v > 50 ) { v = 50;}
		  if( pbrain[p-1] < 500 ) { v = plan.eleM;}
		  ml = ml + v;
		  plan.eleM = plan.eleM - v;
		  //REM
		  v = plan.eleD / 4;
		  if( v > 50 ) { v = 50;}
		  if( pbrain[p-1] < 500 ) { v = plan.eleD ;}
		  dl = dl + v;
		  plan.eleD = plan.eleD - v;
		  //REM
		  v = plan.eleT / 4;
		  if( v > 50 ) { v = 50;}
		  if( pbrain[p-1] < 500 ) { v = plan.eleT;}
		  tl = tl + v;
		  plan.eleT = plan.eleT - v;
		  //REM
		  v = MAX(0, (plan.eleN-300) ) / 4;
		  if( v > 200 ) { v = 200;}
		  nl = nl + v;
		  plan.eleN = plan.eleN - v;
		  //REM
		  v = MAX(0, (plan.money-50)) / 3;
		  if( v > 1000 ) { v = 1000;}
		  mcl = mcl + v;
		  plan.money = plan.money - v;
		  v = MAX(0, (plan.eleS-100)) / 3;
		  if( v > 300 ) { v = 300; }
		  sl = sl + v;
		  plan.eleS = plan.eleS - v;
		  //REM
	       } //If
	       //DEBUG_MACRO;
	       SPlanet(&plan, p);
	    } //If
	 } //If
      } //NEXT p

      total_eleN_production += nl;
      total_eleM_production += ml;
      total_eleT_production += tl;
      total_eleD_production += dl;
      total_cash_production += mcl;
      total_eleS_production += sl;

      nl = nl / count;
      ml = ml / count;
      tl = tl / count;
      dl = dl / count;
      mcl = mcl / count;
      sl = sl / count;
      for( p = 1 ; p<=500;p++){// 500
	 if( rPlanet[p-1] == race ) {
	    sw = 0;
	    switch( abrain[p-1] ){
	       case 6: case 7:     // transfers metals to these planets
		  sw = 1;
		  break;
	       default:
		  break;
	    }// SELECT
	    if( sw == 1 ) {
	       LPlanet(&plan, p);
	       if( plan.pNum == race ) {
		  plan.eleN = plan.eleN + nl;
		  plan.eleT = plan.eleT + tl;
		  plan.eleD = plan.eleD + dl;
		  plan.eleM = plan.eleM + ml;
		  plan.money = plan.money + mcl;
		  plan.eleS = plan.eleS + sl;
		  if(plan.eleC > 200000L) {  //over twenty million
		    if(CHEAT_CLIP(2)) { //computer cant handle this adding
		      //eject cheat -Miikka
		      //note crappy planets dont get eject cheat, they just
		      //starve and riot
		      if(INFO_CLIP(3)) {
			printf("Ejecting colonists into space!!!\n");
		      }
		      plan.eleC *= .6;
		    } else {
		      printf("WARNING: non cheating handling of overpop not ready\n");
		    }
		  } else {  //no overpop probably, account for factories
		    //and income for economic modeling
		    total_eleS_production += plan.factories;
		  }
		  if(plan.happynessC>60) {
		    total_cash_production += plan.eleC * plan.taxC / 1000;
		  }
		  if(plan.native) {
		    if(plan.happynessN>60) {
		      total_cash_production += MIN(plan.eleC,plan.native * plan.taxN / 1000);
		    }
		  }
		  if(plan.resM) total_eleM_production += plan.mines * plan.easyM / 100;
		  if(plan.resD) total_eleD_production += plan.mines * plan.easyD / 100;
		  if(plan.resT) total_eleT_production += plan.mines * plan.easyT / 100;
		  if(plan.resN) total_eleN_production += plan.mines * plan.easyN / 100;
	       } //If
	       //DEBUG_MACRO;
	       SPlanet( &plan, p );
	    } //If
	 } //If
      } //NEXT p
#endif COMPUTER_CHEATS
   } //clip cheat
} //EnD sUb

int PCheck (PLANTYPE *plan) { //PCheck (v%)
//PLANTYPE plan;
   int v;
   float weighting_factor;


   assert(plan);
   v = 0;
   //short term properties
   if( plan->eleN > 500 ) { v = v + 150; } //fuel depot
   if( plan->eleM > 500 ) { v = v + 200; } //moly valuable
   if( plan->eleD > 500 ) { v = v + 100; }
   if( plan->eleT > 500 ) { v = v + 50; }  //tritanium worthless

   //medium term properties
   if( plan->resN > 1000 ) { v = v + 300; }
   if( plan->resM > 1000 ) { v = v + 400; }
   if( plan->resT > 1000 ) { v = v + 100; }
   if( plan->resD > 1000 ) { v = v + 200; }

   //man made properties
   if( plan->money > 2000 ) { v = v + 400; }
   if( plan->money > 550 ) { v = v + 50; }
   if( plan->eleS > 2000 ) { v = v + 200; }  //supplies in bulk only
   if( plan->eleS > 100 ) { v = v + 30; }
   if( plan->factories > 100 ) { v = v + 30; }
   if( plan->factories > 200 ) { v = v + 30; }
   if( plan->factories > 300 ) { v = v + 30; }
   if( plan->factories > 400 ) { v = v + 30; }
   if( plan->SDI > 100 ) { v = v + 30; }
   if( plan->SDI > 200 ) { v = v + 30; }
   if( plan->SDI > 300 ) { v = v + 30; }


   //now put in some CDR related code
   if(fig.cdeathrate) {  //calculate value of planet
     if(race==RACE_CRY && fig.crysclim) {
       //dont care about bad weather here actually, I like it!
     } else {
       if( plan->climate < 25 || plan->climate > 75 ) v -= 5 * fig.cdeathrate;
       if( plan->climate < 15 || plan->climate > 85 ) v -= 20 * fig.cdeathrate;
     }
   }

   if(race==RACE_CRY && fig.crysclim) {
       //dont care about bad weather here actually, I like it!
       if( plan->climate > 70 ) v += 75;

   } else {
       //prefer temperate warm
       if( plan->climate > 35 && plan->climate < 65 ) v += 75;
   }


   weighting_factor = plan->native/20000.0; //counts twos of millions
   weighting_factor = MAX(0.5, weighting_factor);//from population
   weighting_factor *= MAX(0.5,((1.2*plan->SPI)/4.0));

   weighting_factor = MIN(10.0,MAX(0.5,weighting_factor));

   if(race==RACE_BOR) weighting_factor *= 0.1;

   //this should check if money, metal, supplies, tech etc is your problem
   //and decide bonuses from that
   if( plan->native > 500 ) {
      switch( plan->species ) {
	 case 1:
	    v = v + 200 * weighting_factor;  //_humanoid_  gives tech 10 hull
	    if(lowtech) v += 1000;
	    break;
	 case 2:
	    v = v + 900 * weighting_factor; //_bovinoid_  makes supplies
	    if(race==RACE_CRY) v += 700 * weighting_factor;
	    break;
	 case 3:
	    v = v + 200 * weighting_factor;  //_reptian_  2x mining
	    if(race!=RACE_LIZ)
	      if(plan->resN + plan->resD + plan->resT + plan->resM > 10000)
		v += 300 * weighting_factor;
	    break;
	 case 4:
	    v = v + 100 * weighting_factor;  // _avian_   forgives quickly
	    if(race!=RACE_FED) v += 300 * weighting_factor;
	    break;
	 case 5:
	    v = v - 300;   //_amorphous_         kills 5 clans
	    break;
	 case 6:
	    v = v + 300 * weighting_factor;   //_insectoid_  2x taxes
	    if(race!=RACE_FED) v += 900 * weighting_factor;
	    break;
	 case 7:           //_amphibious_     gives tech 10 beams
	    v = v + 200 * weighting_factor;
	    if(lowtech) v += 400;
	    break;
	 case 8:           //_ghipsoldal_     gives tech 10 engines
	    v = v + 200 * weighting_factor;
	    if(lowtech) v += 1500;
	    break;
	 case 9:           //_silicoid_       gives tech 10 torps
	    v = v + 200 * weighting_factor;
	    if(lowtech) v += 700;
	    break;
	 default:
	    break;
      }//SELECT
      //if( plan->species != 5 ) { v = v + plan->SPI * 10; }
   } //If
   return(v);
} //EnD sUb


int am_i_at_friendly_base(int shipnum)
{
  int I;

  for(I=1;I<=500;I++) {
    if(rBase[I-1]==0) continue;
    if(rBase[I-1]!=race) continue;

    if(mapx[shipnum-1]!=xPlanet[I-1]) continue;
    if(mapy[shipnum-1]!=yPlanet[I-1]) continue;

    return(I);
  }

  return(0);
}


//this is single check of planet vs minefield
int is_planet_in_minefield_x( int plannum, int minefield )
{
  float dx,dy;
  float distance_exact;
  float exact_radius;
  float dx_sqr,dy_sqr;

  if(zmine[minefield-1]<1) return(0);//field doesnt exist

  dx = xPlanet[plannum-1]-xmine[minefield-1];
  dy = yPlanet[plannum-1]-ymine[minefield-1];
  dx_sqr = (1.0*dx) * (1.0*dx);  //force cpu to do floating point
  dy_sqr = (1.0*dy) * (1.0*dy);

  exact_radius = SQR( zmine[minefield-1] );
  distance_exact = SQR( dx_sqr + dy_sqr );

  if(exact_radius>=distance_exact) return(1);
  return(0);
}


//this is single check of ship vs minefield
int am_i_in_minefield_x( int shipnum, int minefield )
{
  float dx,dy;
  float distance_exact;
  float exact_radius;
  float dx_sqr,dy_sqr;

  if(zmine[minefield-1]<1) return(0);//field doesnt exist

  dx = mapx[shipnum-1]-xmine[minefield-1];
  dy = mapy[shipnum-1]-ymine[minefield-1];
  dx_sqr = (1.0*dx) * (1.0*dx);  //force cpu to do floating point
  dy_sqr = (1.0*dy) * (1.0*dy);

  exact_radius = SQR( zmine[minefield-1] );
  distance_exact = SQR( dx_sqr + dy_sqr );

  if(exact_radius>=distance_exact) return(1);
  return(0);
}


//returns worst enemy minefield ID you are in, web is worse than normal
int is_planet_in_an_enemy_minefield( int plannum )
{
  int I;
  int minefield=0;
  int worst=0;

  for(I=1;I<=500;I++) {
    if(zmine[I-1] && rmine[I-1]!=race) {
      if(is_planet_in_minefield_x( plannum, I)) {
	if(wmine[I-1]) { //in web mine
	  minefield = I;
	  worst = I;
	} else if(worst==0 || wmine[worst-1]==0) { //in regular mine
	  //note this crashes if you compile in force mode for worst==0
	  //normally wmine[-1] never gets called since || clips it
	  minefield = I;  //so if 2 still returns 2
	  worst = I;
	}
      }
    }
  }
  return(minefield);
}

//maybe called in moveships inside warship minelaying routine
int is_planet_in_a_friendly_minefield( int plannum )
{
  int I;
  int best=0;
  int minefield=0;

  for(I=1;I<=500;I++) {
    if(zmine[I-1] && rmine[I-1]==race) {
      if(is_planet_in_minefield_x( plannum, I)) {
	minefield=I;
	if(wmine[I-1]) { //in web mine
	  minefield = I;
	  best = I;
	} else if(best==0 || wmine[best-1]==0) { //in regular mine
	  minefield = I;  //so if 2 still returns 2
	  best = I;
	}
      }
    }
  }
  return(minefield);
}



//returns worst enemy minefield ID you are in, web is worse than normal
int am_i_in_an_enemy_minefield( int shipnum )
{
  int I;
  int minefield=0;
  int worst=0;

  for(I=1;I<=500;I++) {
    if(zmine[I-1] && rmine[I-1]!=race) {
      if(am_i_in_minefield_x( shipnum, I)) {
	if(wmine[I-1]) { //in web mine
	  minefield = I;
	  worst = I;
	} else if(worst==0 || wmine[worst-1]==0) { //in regular mine
	  //note this crashes if you compile in force mode for worst==0
	  //normally wmine[-1] never gets called since || clips it
	  minefield = I;  //so if 2 still returns 2
	  worst = I;
	}

      }
    }
  }
  return(minefield);
}

//maybe called in moveships inside warship minelaying routine
int am_i_in_a_friendly_minefield( int shipnum )
{
  int I;
  int best=0;
  int minefield=0;

  for(I=1;I<=500;I++) {
    if(zmine[I-1] && rmine[I-1]==race) {
      if(am_i_in_minefield_x( shipnum, I)) {
	minefield=I;
	if(wmine[I-1]) { //in web mine
	  minefield = I;
	  best = I;
	} else if(best==0 || wmine[best-1]==0) { //in regular mine
	  minefield = I;  //so if 2 still returns 2
	  best = I;
	}
      }
    }
  }
  return(minefield);
}


void PlanetCheck() { //PlanetCheck
//long x1 ;//AS LONG
//long size ;//AS LONG
int p,tmp=0,x;//AS LONG
int v; char buf_g[80];
long pop;
PLANTYPE plan;
SHIPTYPE me;

//   '**** ABRAIN ****
//   ' 0  None
//   ' 1  Explored
//   ' 2  Attack
//   ' 3  Dropping Some Colonists
//   ' 4  Dropping Many Colonists
//   ' 5  My Planet
//   ' 6  Starbase
//   ' 7  Building Starbase here
//   ' 8  Please send colonists
//   ' 9  Enemy Planet

   printf( "THINKING ABOUT: Planetary Values\n");
      if(CLIP_INFO(2)) printf("Census:\n");
      for( p = 1 ; p<=500;p++){// 500
	 planet_in_a_minefield[p-1]=is_planet_in_an_enemy_minefield( p );
	 if( rPlanet[p-1] == race ) {
	    LPlanet( &plan, p );
	    if( rBase[p-1] == race ) {
	       abrain[p-1] = 6 ;
	    } //If
	    if( abrain[p-1] == ABRAIN_NONE ) { abrain[p-1] = ABRAIN_MY_PLANET;}
	    if( abrain[p-1] == ABRAIN_DROP_SOME ) { abrain[p-1] = ABRAIN_MY_PLANET;}
	    //LPlanet( &plan, p);
	    if( plan.pNum == race ) {
	       v=0;
	       v=PCheck(&plan);
	       pbrain[p-1] = v ;

	       pop=plan.eleC;

	       if(CLIP_INFO(2)) {
		 if(pop<101) printf(".");          //from 0-100 clans
		 else if(pop<5000) printf("o");    //below .01-.5M
		 else if(pop<50000) printf("O"); //.5M-5M
		 else if(pop<150000) printf("@");         //5M-15M
		 else printf("*");        //15M+
	       }
	       if(INFO_CLIP(4)&&plan.native)
			printf("plan %d species %d\n",plan.ID,plan.species);
	    } else {
	       sprintf( buf_g ,"Planet ID Error!\n");
	       PutError( buf_g );
	       exit(1);
	    } //If
	 } //If
	 if( abrain[p-1] == ABRAIN_DROP_SOME ) {
	    LPlanet(&plan, p);
	    v=PCheck(&plan);
	    pbrain[p-1] = v;
	    if( rPlanet[p-1] != race && rPlanet[p-1] > 0 ) {
	       abrain[p-1] = ABRAIN_ATTACK;
	    } else {
	       abrain[p-1] = ABRAIN_EXPLORED;
	    } //If
	 } //If
      } //NEXT p  NOTE PLANET IS LOADED IN ENTIRE SEGMENT ABOVE!!!
      if(CLIP_INFO(2)) printf("\n");

//#ifdef NOT_HERE
   printf("Surveying values of %s\n", RACENAME( race, 1 ));
   //count status
   pcount = 0;
   sbcount = 0;
   epcount = 0;
   total_dominion = 0;
   dominion_unexplored_count = 0;
   for( x = 1; x<=500;x++){// 500
      tmp=dominion[x-1];      //scope of tmp
      if(tmp==1) total_dominion++;

      //abrain is f***ed dont use could be old abrain even
      if(rPlanet[x-1]) {
	//inhabited
	if(rPlanet[x-1]==race) {
		pcount++;
		if(rBase[x-1]==race) {
			if(CLIP_INFO(2)) printf("*");  //starbase
			sbcount++;
		} else {
			//is it a major planet??
			if(pbrain[x-1]>1000) {
			  if(CLIP_INFO(2)) printf("O");
			//is it a good planet??
			} else if(pbrain[x-1]>500) {
			  if(CLIP_INFO(2)) printf("o");
			//is it a backwater world??
			} else {
			  if(CLIP_INFO(2)) printf(".");
			}
		}
	} else { //enemy race   below  NON BLANK ONLY
	 if(tmp==1){
	  if(abrain[x-1]==ABRAIN_ENEMY||abrain[x-1]==ABRAIN_ATTACK) {
	    //I know about them
	    if(abrain[x-1]==ABRAIN_ENEMY) {
		if(CLIP_INFO(2)) printf("x");    // they are here but not attacking
	    } else {
		if(CLIP_INFO(2)) printf("X");    // im attacking them here
	    }
	    epcount++;
	  } else { // i dont know they are there, but they are!
	    if(CLIP_INFO(2)) printf("?");
	    dominion_unexplored_count++;
	  }
	 }//tmp==1
	}//enemy race  above
      } else {   //blank race   BLANK ONLY
	if(tmp==1) { if(CLIP_INFO(2)) printf("?");
		dominion_unexplored_count++;
	}
      } //uninhabited


   } //NEXT x
   if(INFO_CLIP(2)) printf("\n");
   total_dominion=MAX(total_dominion,pcount);

   printf("Surveying the fleet\n");
   scouts=0;
   eggs=0;
   destroyers=0;
   battleships=0;
   refineries=0;
   merlins=0;
   fuel_carriers=0;
   big_eggs=0;
   specials=0;
#ifdef __HUGE__
   fuzzy_scouts=0.0;
   fuzzy_eggs=0.0;
   fuzzy_warships=0.0;
#endif __HUGE__

   for( x = 1 ; x<=500; x++){// 500

	 //put minefield check here???

	 if( mapr[x-1] ) {
	   in_a_minefield[x-1]=am_i_in_an_enemy_minefield( x );
	 } else { //ship is dead, set to zero
	   in_a_minefield[x-1]=0;
	 }
	 if(INFO_CLIP(2)) {  //shows general info like size or how screwed
	   if(mapr[x-1]==race) { //you are at the moment.
	     if(in_a_minefield[x-1]==0) {
		LShip( &me, x );
		if(me.damage<10) {
			if(mapm[x-1]>1000) printf("O");
			else if(mapm[x-1]>500) printf("o");
			else printf(".");
		}
		if(me.damage>=10 && me.damage <=35) printf("x");
		if(me.damage>35) printf("X");
	     }
	     else if(wmine[in_a_minefield[x-1]-1]==0) printf("x");
	     else if(wmine[in_a_minefield[x-1]-1]) printf("X");
	     else printf("?");
	   }
	   //printf("\n");
	 }
	 //end minefield check?

	 if( mapr[x-1] == race ) {
	    LShip( &me, x );
	    assert(me.hull>=1 && me.hull <= 105);


	    switch(classlist[me.hull-1]) {
	      case 1:
		scouts++;
		break;
	      case 2:
		eggs++;
		break;
	      case 3:
		destroyers++;
		break;
	      case 4:
		battleships++;
		break;
	      case 5:
		refineries++;
		break;
	      case 6:
		merlins++;
		break;
	      case 7:
		fuel_carriers++;
		break;
	      case 8:
		big_eggs++;
		break;
	      case 9:
		specials++;
		break;
	      default:
		printf("unknown class type\n");
		assert(0);
		break;
	    }
#ifdef __HUGE__
	    fuzzy_scouts   += fuzzyclasslist[me.hull-1][0];
	    fuzzy_eggs     += fuzzyclasslist[me.hull-1][1];
	    fuzzy_warships += fuzzyclasslist[me.hull-1][2];
#endif __HUGE__
	 }
   }// end for
   if(INFO_CLIP(2)) printf("\n");
   ships_counted++;
   //traps <3 planets which returns -1 for chull
//#endif NOT_HERE
} //EnD sUb

void PlanetEcon () { //PlanetEcon   translated
//long x1 ;//AS LONG
//long size ;//AS LONG
int p ;//AS LONG
int h,maxfact,maxmines,maxsdi;
int min_money;
PLANTYPE plan;
int min_prob;

   printf( "THINKING ABOUT: Planetary Economies\n");

   //size = 85;
      for( p = 1 ; p<=500;p++){// 500
	 if( rPlanet[p-1] == race ) {
	    LPlanet(&plan, p);
	    if( plan.pNum == race ) {
	       h=0;
	       if(plan.money >= 10000 && plan.eleS > plan.money/3 ) {
		   h = plan.eleS / 6;
	       }
	       if(plan.money < 10000 && plan.eleS > plan.money/2 ) {
		   h = plan.eleS / 5;
	       }
	       if(plan.money < 2000 && plan.eleS > plan.money ) {
		   h = plan.eleS / 4; //sell fraction of supplies
	       }
	       if(plan.money < 1000 && plan.eleS > plan.money * 1.5) {
		   h = plan.eleS/3;
	       }
	       if(plan.money < 500 && plan.eleS > plan.money * 2) {
		   h = plan.eleS/2;
	       }
	       if(plan.money < 100 && plan.eleS > plan.money * 4) {
		   h = plan.eleS/1.5;
	       }
	       if(plan.eleS>1 && h==0) {
		   h = 1;
	       }
	       total_cash_production += h;
	       total_eleS_consumption += h;

	       plan.eleS = plan.eleS - h;
	       plan.money = plan.money + h;
	       if(CLIP_INFO(2) && h) {
		 if(h<100) {
			printf("s");
		 } else printf("S");
	       }

	       if(plan.taxC && plan.eleC)
	       while(plan.taxC>0 && plan.taxC * plan.eleC / 1000 < 1) {
		 plan.taxC--;
		 //pop so low it wont give money dont tax them
	       }

	       if( plan.happynessC > 65 ) {
		  plan.taxC += 1;
		  if(CLIP_INFO(2)) printf("T");
	       } else if( plan.happynessC < 55 ) {
		  plan.taxC -= 9;
		  if(CLIP_INFO(2)) printf("t");
	       } else if( plan.happynessC < 63 ) {
		  plan.taxC -= 3;
		  if(CLIP_INFO(2)) printf("t");
	       }

	       if(plan.taxN && plan.native && plan.eleC)
	       while(plan.taxN>1 && plan.taxN * plan.native / 1000 > plan.eleC) {
		 plan.taxN--;
		 //overtaxing them wont give more than colonists
		 //still tax to get some money
	       }

	       if(plan.native) {
		 if( plan.happynessN > 65 ) {
		   plan.taxN += 1;
		   if(CLIP_INFO(2)) printf("N");
		 } else if( plan.happynessN < 55 ) {
		   plan.taxN -= 9;
		   if(CLIP_INFO(2)) printf("n");
		 } else if(plan.happynessN < 63 ) {
		   plan.taxN -= 3;
		   if(CLIP_INFO(2)) printf("n");
		 }
	       }

	       plan.taxN = MAX(0,MIN(100,plan.taxN));
	       plan.taxC = MAX(0,MIN(100,plan.taxC));

	       if( plan.eleC <= 100 ) {
		  maxfact = plan.eleC;
	       } else {
		  maxfact = 100 + (SQR( MIN(200000L,plan.eleC) - 95 ) );
	       } //If
	       maxfact = MIN( maxfact, plan.eleC );
	       while ( plan.factories < maxfact && plan.money > 3 && plan.eleS > 0){
		  if(CLIP_INFO(2)) printf("f");
		  plan.eleS = plan.eleS - 1;
		  plan.money = plan.money - 3;
		  plan.factories = plan.factories + 1;

		  total_cash_consumption += 3;
		  total_eleS_consumption += 1;
	       }
	       //calculate max mines
	       if( plan.eleC > 50 ) {
		  //new logic added
		  maxmines = 100 + (SQR(MIN(plan.eleC,200000L) - 95));
	       } else {
		  maxmines = plan.eleC;
	       } //If
	       maxmines = MIN( maxmines, plan.eleC );
	       //calculate min money to build mines
	       min_money = 4;
	       if(strategy_option & STRATEGY_MILITARIST) { //wait for 1 sdi
		 if(plan.SDI < MIN(1,plan.eleC)) min_money = 10;
	       }
	       if(strategy_option & STRATEGY_DEFENSIVE) { //wait for 3 sdi
		 if(plan.SDI < MIN(3,plan.eleC)) min_money = 30;
	       }


	       //new code since we have radioisotopes etc
	       //maxmines = MIN( 200, maxmines );

	       while ( plan.mines < maxmines && plan.money > min_money
		       && plan.eleS && plan.factories
		       && (plan.resT+plan.resN+plan.resD+plan.resM>4*fig.isotope)) {
		  if(CLIP_INFO(2)) printf("m");
		  plan.eleS = plan.eleS - 1;
		  plan.money = plan.money - 4;
		  plan.mines = plan.mines + 1;

		  total_cash_consumption += 4;
		  total_eleS_consumption += 1;
	       }

	       min_money = 50;
	       if(strategy_option & STRATEGY_MILITARIST) min_money = 10;
	       if(strategy_option & STRATEGY_DEFENSIVE) min_money = 10;

	       if( plan.money >= min_money && plan.eleS && plan.factories ) { //was 1000, 100
		  //DEBUG_MACRO;
		  maxsdi = SQR(MIN(plan.eleC,200000L)) + 30; //130 max???
		  maxsdi = MIN( maxsdi, plan.eleC );
		  //DEBUG_MACRO;
		  while ( plan.money > min_money && plan.eleS && plan.SDI < maxsdi){
		     if(CLIP_INFO(2)) printf("d");
		     plan.SDI = plan.SDI + 1;
		     plan.money = plan.money - 10;
		     plan.eleS = plan.eleS - 1 ;

		     total_cash_consumption += 10;
		     total_eleS_consumption += 1;
		  }
	       } //If
	       //plan.fCode = CHR$(64 + random( 50) + CHR$(64 + random( 50) + CHR$(64 + random( 50)
	       if(random(6)==3 || strategy_option & STRATEGY_DEFENSIVE) {
		 //casually switch friendly code
		 //so romulan sense not useless since humans dont
		 //switch their friendly codes that often either
		 plan.fCode[0] = random(26)+'a';
		 plan.fCode[1] = random(26)+'a';
		 plan.fCode[2] = random(26)+'a';

		 min_prob = 80;
		 if(strategy_option & STRATEGY_AGGRESSIVE) min_prob = 60;

		 if(fig.planetattack) {

		   if(rBase[plan.ID-1]==race||random(2)==1) { //base capture dont kill

		     if(plan.SDI>=100 && random(100)>min_prob) { //maybe att or nuk?
		     plan.fCode[0] = 'A';
		     plan.fCode[1] = 'T';
		     plan.fCode[2] = 'T';
		     }

		     if(plan.SDI>=200 && random(100)>min_prob) { //att or nuk?
		     plan.fCode[0] = 'A';
		     plan.fCode[1] = 'T';
		     plan.fCode[2] = 'T';
		     }

		     if(plan.SDI>=300 && random(100)>min_prob) { //att or nuk?
		     plan.fCode[0] = 'A';
		     plan.fCode[1] = 'T';
		     plan.fCode[2] = 'T';
		     }

		   } else {  //no base maybe nuke instead?

		     if(plan.SDI>100 && random(100)>min_prob) { //maybe att or nuk?
		     plan.fCode[0] = 'N';
		     plan.fCode[1] = 'U';
		     plan.fCode[2] = 'K';
		     }

		     if(plan.SDI>200 && random(100)>min_prob) { //att or nuk?
		     plan.fCode[0] = 'N';
		     plan.fCode[1] = 'U';
		     plan.fCode[2] = 'K';
		     }

		     if(plan.SDI>300 && random(100)>min_prob) { //att or nuk?
		     plan.fCode[0] = 'N';
		     plan.fCode[1] = 'U';
		     plan.fCode[2] = 'K';
		     }



		   }
		 }


	       }
	    } //If
	    //DEBUG_MACRO;
	    SPlanet(&plan, p);
	 } //If
      } //NEXT p
      if(CLIP_INFO(2)) printf("\n");
      //DEBUG_MACRO;
} //EnD sUb




//#define NUMBER(a,b)    ( random( b - a ) + a )
#define NP 500
struct point_type { int x,y,ID; } p[NP+1]; // correspond to planets
float mock_theta(struct point_type p1, struct point_type p2);
int wrap(int owned);
int fillarray(struct point_type *p);
//void Initialize(void);
//void box(int xupperleft, int yupperleft, int xlowerright, int ylowerright, int color);
//void plot_points(struct point_type *p, int M);

void compute_dominion()
{
  int I;
  printf("Computing Dominion\n");
  //first initialize greatest and least x
  //assert convex_hull_analysis has never been called yet
  assert(convex_trial==0);

  for(I=1;I<=500;I++) {    //initialize max and min planets
    if(rPlanet[I-1]!=race) continue;
    if(xPlanet[I-1]>greatest_x) greatest_x=xPlanet[I-1];
    if(yPlanet[I-1]>greatest_y) greatest_y=yPlanet[I-1];
    if(xPlanet[I-1]<least_x) least_x=xPlanet[I-1];
    if(yPlanet[I-1]<least_y) least_y=yPlanet[I-1];
  }


  for(I=1;I<=500;I++) {
    dominion[I-1]=convex_hull_analysis(I);
    if(CLIP_INFO(1)) printf(".");
  }
  if(INFO_CLIP(1)) printf("\n");
}


int convex_hull_analysis(int am_i_inside_ID)
{  // compute convex hull, decide which planets are in imperial domain
// if convex hull changes when planet added then its out
//of the domain, if hull is the same it is in the domain.
//need to analyze twice to find out about a point
  struct old_hull_ID { int ID; } id[50];   //assume <50 hull points
  int M = 0,M2 = 0,owned,i;
    int real_owner;
  int result_flag;

  if(am_i_inside_ID<=0) return(0); // null planet rejected
  if(am_i_inside_ID>500) return(0); //errors

  //randomize();
  convex_trial++;

  //the next 5 lines are just to speed up the process for obvious cases
  if(rPlanet[am_i_inside_ID-1]==race) return(1);
  if(xPlanet[am_i_inside_ID-1]>greatest_x) return(0);
  if(xPlanet[am_i_inside_ID-1]<least_x) return(0);
  if(yPlanet[am_i_inside_ID-1]>greatest_y) return(0);
  if(yPlanet[am_i_inside_ID-1]<least_y) return(0);


  owned=fillarray(p); // inits array so owned planets are added else not
  if(owned<3) return(-1); //inconclusive with only 2 or 1 points
  //actually this still works even with only one point but just in case
  //i messed up implementing the algorithm i am clipping this

  M = wrap(owned);
  //printf("convex hull points: %d out of %d planets.\n", M, owned );
  for(i=0;i<=M;i++) {  //had to add =M for some reason Miikka
    id[i].ID=p[i].ID;   // store hull point ID's for comparison
  }
  real_owner = rPlanet[am_i_inside_ID-1];
  rPlanet[am_i_inside_ID-1]=race; //simulate ownership
  //list_points(p, M); // M first are complex hull points
  owned=fillarray(p);      // reinit chull data
  M2 = wrap(owned);   // refind chull
  //compare with previous chull
  result_flag = 1;//assume inside, prove otherwise
  if(M2!=M) result_flag=0; //obviously mismatch in # of outposts --> outside
  //check id of outpost worlds, are they the same?
  for(i=0;i<=M;i++) { //had to add =M for some reason Miikka
    if(id[i].ID!=p[i].ID) result_flag=0;  //outposts are different --> outside
  }
  rPlanet[am_i_inside_ID-1]=real_owner;  //restore reality
  //printf("based on convex hull ID=%d %s is %s my dominion.\n",
  //  am_i_inside_ID, PLANETNAME(am_i_inside_ID), (result_flag)?"Inside\0":"Outside\0");
  return(result_flag);  // should return 1 if am_i_inside_ID inside, 0 if outside chull
}



int wrap(int owned)
{
  struct point_type t;
  int i, min, M;
  float minangle, v;

  min = 0;
  for(i=1; i<owned; i++ ) if(p[i].y < p[min].y) min = i;//get lowest pt
  M = -1;  p[owned] = p[min]; minangle = 0.0; //lowest pnt is now max index

  for(; min!=owned;)
  {
	//printf(".");
	M++;
	//assert(M>=0);
	t = p[M]; p[M] = p[min]; p[min] = t;   //swap with min
	min=owned; v = minangle; minangle = 360.0;
	for(i = M+1; i<=owned; i++)
	{
	  if(mock_theta(p[M], p[i]) > v)
	  {
	    if(mock_theta(p[M], p[i])<minangle)
	    {
	      min = i; minangle = mock_theta(p[M], p[min]);
	    }
	  }
	}
  }
  //printf("\n");
  return(M);
}

float mock_theta(struct point_type p1, struct point_type p2)
{
  int dx, dy, ax, ay;
  float t;
  dx = p2.x - p1.x;
  ax = ABS( dx );
  dy = p2.y - p1.y;
  ay = ABS( dy );
  if( (dx==0) && (dy==0) ) { t = 0.0; } else {
	t = (float)dy / (float)(ax + ay);
  }
  if(dx<0) { t = 2 - t; } else if(dy<0) { t = 4 + t; };
  return( t * 90.0 );
}

int fillarray(struct point_type *p)
{
  int i,caret,own;
#ifdef DEBUG
  //printf("filling chull array\n");
#endif
  for(i=1,caret=1; i<=NP; i++)
  {
    if(rPlanet[i-1]!=race) {
      continue;
    }
    p[caret-1].x = xPlanet[i-1];
    p[caret-1].y = yPlanet[i-1];
    p[caret-1].ID = i;
    caret++;
  }
  own = caret - 1;
  //fill extra points with zeroes
  for(i=caret;i<=NP;i++) {
    p[i-1].x = 0;
    p[i-1].y = 0;
    p[i-1].ID = 0;
  }
  return(own);
}


int list_points(struct point_type *p, int M)  // list chull
{
  int i = 0;
  printf("The following worlds are my farthest outposts:\n");
  for(i=0; i<M; i++)
  {
    printf("Planet ID=%d  %s\n", p[i].ID, PLANETNAME(p[i].ID));
  }
  printf("Extra? ID=%d  %s\n", p[i].ID, PLANETNAME(p[i].ID));
  printf("Extra? ID=%d  %s\n", p[i+1].ID, PLANETNAME(p[i+1].ID));
  return(M);
}




//this is also used to check if enemy planet already has a ship there to
//attack it
int has_a_defender(int planID)
{
  int I;
  int ball_x,ball_y;
  SHIPTYPE tmp;

  assert(planID>=1 && planID<=500);
  ball_x = xPlanet[planID-1];
  ball_y = yPlanet[planID-1];

  for(I=1;I<=500;I++) {
    if(mapx[I-1]!=ball_x) continue;
    if(mapy[I-1]!=ball_y) continue;
    if(mapr[I-1]!=race) continue;
    //assert(tmp.ID==I);
    LShip( &tmp, I);
    if(is_armed(&tmp)==0) continue;
    if(classlist[tmp.hull-1]==3||classlist[tmp.hull-1]==4) {
      return(I);
    }
  }
  return(0); //none found
}


int get_orbit_hull(PLANTYPE *ball, int wanted_hull)
{
  int I;
  int ball_x,ball_y;
  SHIPTYPE tmp;

  assert(ball);
  assert(wanted_hull>0&&wanted_hull<=105);
  ball_x = xPlanet[ball->ID-1];
  ball_y = yPlanet[ball->ID-1];

  for(I=1;I<=500;I++) {
    if(mapx[I-1]!=ball_x) continue;
    if(mapy[I-1]!=ball_y) continue;
    if(mapr[I-1]!=race) continue;
    //assert(tmp.ID==I);
    LShip( &tmp, I);
    if(tmp.hull!=wanted_hull) continue;
    return(I);
  }
  return(0); //none found
}

int get_orbit_planet(SHIPTYPE *me)
{
  int I;
  assert(me);
  for(I=1;I<=500;I++) {
    if(xPlanet[I-1]!=me->xShip) continue;
    if(yPlanet[I-1]!=me->yShip) continue;
    return(I);
  }
  return(0);
}

int get_plan_lowest_metal(PLANTYPE *plan)
{
  int which_one;
  long amount=10000L;
  assert(plan);
  if(plan->eleM<amount) { amount=plan->eleM; which_one=1; }
  if(plan->eleD<amount) { amount=plan->eleD; which_one=2; }
  if(plan->eleT<amount) { amount=plan->eleT; which_one=3; }
  return(which_one);
}

int get_plan_highest_metal(PLANTYPE *plan)
{
  int which_one;
  long amount=0;
  assert(plan);
  if(plan->eleM>amount) { amount=plan->eleM; which_one=1; }
  if(plan->eleD>amount) { amount=plan->eleD; which_one=2; }
  if(plan->eleT>amount) { amount=plan->eleT; which_one=3; }
  return(which_one);
}




