#
#	rfc822.pl	- procedure to parse a RFC822 header
#
#			Takes filehandle to read from as argument
#			Sets 4 GLOBAL variables:
#				$FROM	- "From:" field in header
#				$SUBJECT - subject in header
#				$MDATE - date in header
#				$MSGID - message ID in header
#				$opt_A if send to auto-assign
#				$opt_v if LONGACK in subject
#
#	$RCSfile: rfc822.pl,v $
#	$Revision: 0.18 $
#	$Author: marten $
#	$Date: 1994/09/20 12:34:41 $

require "defines.pl";

sub parserfc822 {

    local($file) = @_;
    local(%header) = ();
    local($firstreplyto) = 1;

    while (<$file>) {

	$line = $_;
	$line =~ tr/A-Z/a-z/;

	# check to see if this went to auto-assign, then set -A flag
	# Hardcoded and yuck.

	if ($line =~ /auto-assign/) {
	    $opt_A = 1;
	}

	if (/^\s*$/) {
	    if ($header{"ra"}) {
		$FROM = $header{"ra"};
		$SUBJECT = $header{"sj"};
		$MDATE = $header{"dt"};
		$MSGID = $header{"mi"};
		return $OK;
	    } else {
		return $NOK;
	    }
	}

	if (/^Reply-To:\s+(.*)/) {
	    $curfield = "ra";
	    if ($firstreplyto) {
		$header{$curfield} = $1;
		$firstreplyto = 0;
	    } else {
		$header{$curfield} .= ", ".$1;
	    }
	    next;
	}

	if (/^From:\s+(.*)/) {
	    if (!$header{"ra"}) {
		$curfield = "ra";
		$header{$curfield} = $1;
	    }
	    next;
	}

	if (/^Subject:\s+(.*)/) {
	    $curfield = "sj";
	    $header{$curfield} = $1;
	    if ($header{$curfield} =~ /[Ll][Oo][Nn][Gg][Aa][Cc][Kk]/) {
		$opt_v = 1;
	    }
	    next;
	}

	if (/^Message-Id:\s+(.*)/) {
	    $curfield = "mi";
	    $header{$curfield} = $1;
	    next;
	}

	if (/^Date:\s+(.*)/) {
	    $curfield = "dt";
	    $header{$curfield} = $1;
	    next;
	}

	if (/^(\s+.*)/) {
	    if ($curfield) {
		$header{$curfield} .= "\n".$1;
	    }
	    if ($curfield eq "sj") {
		if ($header{$curfield} =~ /[Ll][Oo][Nn][Gg][Aa][Cc][Kk]/) {
		    $opt_v = 1;
		}
	    }
	    
	    next;
	}

	$curfield = "";
    }
}
