#!PERL
#
#	$RCSfile: cleanhandledb.pl,v $
#	$Revision: 1.2 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 14:43:00 $

# This program is similar to cleandb.pl, but reindexes only the handle
# databases. It will lock and read from the existing database, and 
# generate new dbm files for all nic handles found for all objects. These
# are determined by the config file. One only needs to run this once a week
# so, since it does not grow that fast.
# !!! Only run this if you have nic handle generation support in your config
# and software !!!

USE_DBM

@INC = ("LIBDIR", @INC);

require "rconf.pl";
require "dblock.pl";
require "dbopen.pl";
require "dbclose.pl";
require "enread.pl";
require "handle.pl";

$conffile=$ENV{"RIPEDBCNF"};
$conffile= "DEFCONFIG" unless $conffile;
&rconf($conffile);

sub CleanAddHandle {

    local(*entry) = @_;
    
    local(%db) = ();
    
    local($type) = &entype(*entry);

    return 1 if (!$HANDLEATTR{$type});

    $nichandle = $entry{$HANDLEATTR{$type}};
    
    # nichandle is already in our database, check to see if this person
    # is already in. If the nic handle is already in, but the person is
# different, an error will be generated, stating that this is a
# person with the same nic handle. This can go, if we ever make just
# the nic handle the unique key for a person.

    if ($db{$nichandle}) {
	local($thisname) = $entry{$type};
        $thisname =~ tr/A-Z/a-z/;
        if ($db{$nichandle} ne $thisname) {
	    print STDERR "$ATTL{$HANDLEATTR{$type}} appears to be ".
		"assigned to \"$db{$nichandle}\"";
	    return -1;
	} else {
	    return 1;
	}
    }

    local($handlename) = $entry{$type};
    $handlename =~ tr/A-Z/a-z/;
    
    $db{$nichandle} = $handlename;
    if ($db{$handlename}) {
	$db{$handlename} .= ",".$nichandle;
    } else {
	$db{$handlename} = $nichandle;
    }
    
    return 1;
}

# Since we are indexing the live database, let's make sure it is locked
# during the whole period, because we do not want people to add while we
# are working on it.

local(*i) = 'curdb';
%nothing = ();
&dbopen(i, *nothing, 1, $ARGV[0]) || die "Cannot open $ARGV[0]: $!";
&dblock(*i);

unlink("$HANDLEDB{$type}");
unlink("$HANDLEDB{$type}.dir");
unlink("$HANDLEDB{$type}.pag");

$stat = &OpenHandleDB($HANDLEDB{$type}, *db);

if (!$stat) {
    &syslog("ERRLOG", "error opening handle database: $!");
    print STDERR "Cannot open handle database $HANDLEDB{$type}: $!\n";
    &CloseHandleDB(*db);
    exit;
}

&LockHandleDB(*db);

while (%en = &enread(i)) {
    &CleanAddHandle(*en);
}

&UnlockHandleDB(*db);

&dbunlock(*i);
&dbclose(*i);
