#       enwrite - write RIPE database entry
#
#	$RCSfile: enwrite.pl,v $
#	$Revision: 0.23 $
#	$Author: marten $
#	$Date: 1994/09/20 12:17:11 $
#
#	This routine writes a RIPE database entry to standard output
#	in long or short form.
#
#       Arguments:
#	*object		pointer to assoc array with database entry
#	$long		boolean flag for long or short format output
#	$witherror	boolean flag for with or without error messages
#       $withsugar      boolean flag for with or without syntactic sugar

require "entype.pl";

sub enwrite {

    local(*object, $long, $witherrors, $withsugar) = @_;
    local($ok) = 0;
    local($val);
    local(@errs)=();
    local($type)=&entype(*object);
    
    @errs=("uw","ue") if $witherrors;

    # If not long format, and we have an unknown object, let's try
    # and print this anyway to inform the user ...

    if (!$type) {

	return 0 if (!$long);
	return 0 if (!$witherrors);

	$ok = 1;

	foreach $key (keys %object) {
	    next if (grep(/^$key$/,@errs));
	    foreach $val (split(/\n/, $object{$key})) {
		printf "%-15s %s\n", $key.":", $val;
	    }
	}
	
	printf "%-15s %s\n", $ATTL{"ue"}.":", "Unknown object type";
	
	return $ok;
    
    }

    foreach $key (split(/\s+/, $OBJATSQ{$type}), @errs) {
    
	if ($object{$key}) {

	    $ok = 1;

	    foreach $val (split(/\n/, $object{$key})) {

		if ($long) {

		    # HARDCODED SYNTACTIC SUGAR !!!!

		    if ($withsugar) {
			
			local($M) = "\\S+\\s+\\S+\\s+\\S+";
			
			if ($key eq "ae") {
			    $val=~ s/^(AS\d+)/exclude \1 to/;
			}
			elsif ($key eq "ai") {
			    $val=~ s/^(AS\d+\s+\d+)/from \1 accept/;
			}
			elsif ($key eq "ao") {
			    $val=~ s/^(AS\d+)(\s+)/to \1 announce\2/;
			}
			elsif ($key eq "it") {
			    $val=~ s/^($M)\s+(\(\s*pref[=\s\S]+\))/from \1 \2 accept/ ||
			    $val=~ s/^($M)\s+/from \1 accept /;
			}
			elsif ($key eq "io") {
			    $val=~ s/^($M)\s+(\(\s*metric\-out[=\s\S]+\))/to \1 \2 announce/ ||
			    $val=~ s/^($M)\s+/to \1 announce /;
			}
		    }

		    # END HARDCODED

		    printf "%-12s %s\n", $ATTL{$key}.":", $val;
		
		}
		else {
		    print "*", $key, ": ", $val, "\n";
		}
	    }
	}
    }

    return $ok;
}

1;
