#       rconf - read RIPE database configuration file
#
#	$RCSfile: rconf.pl,v $
#	$Revision: 0.37 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 14:43:00 $
#
#       This routine reads all parameters from the configuration file
#       into scalars or associative arrays of the same name (uppercase).
#       Multi line texts are stored as scalar strings with embdded "\n"s.
#       Note the special variable names for the OBJ configuration.
#
#       Arguments:
#
#       $confname       name of the configuration file

require "defaults.pl";		# file containing some default configuration
				# definitions.
require "misc.pl";

sub rconf {

    local($confname) = @_;
    local ($i);

    # set the program name correctly

    if ($0=~ /\//) {
       ($PROGRAMNAME)= $0 =~ /\/([^\/]*)$/;
    }
    else {
       $PROGRAMNAME=$0;
    }
    $0=$PROGRAMNAME;
    
    # needed in several routines...
    
    ($DATE,$TIME)=&getYYMMDDandHHMMSS(); 
    
    open(CONF, $confname) || die "rconf: cannot open config \"$confname\", $!";

    while (<CONF>) {
	next if (/^\#/);
	next if (/^\s*$/);
	last if (/^ENDCONF/);

	if (/^ALIAS\s+(\S+)\s+(\S+)/) {
	    $ALIAS{$2} = $1;
	    next;
	}
	if (/^ATTA\s+(..)\s+(\S*)/) { $ATTR{$2}=$1; next;}
	if (/^ATTR\s+(..)\s+(\S*)/) { 
	    $ATTR{$1}=$1; $ATTR{$2}=$1; $ATTL{$1}=$2;
	    next;
	    print $ATTL{$1}, "\n";
	}
	if (/^CONGRAT\s+(.*)/) { $CONGRAT=$CONGRAT.$1."\n"; next;}
	if (/^CONNECT\s+(\S+)/) { $CONNECT{$1}=$1; next;}
	if (/^COUNTRY\s+(..)\s+(..)/) { 
	    $COUNTRY{$1}=$1; $COUNTRY{$2}=$1; 
	    next;
	}
	if (/^DOHANDLE\s+(\d+)/) {$DOHANDLE=$1+0; next;}
	if (/^HANDLEPOSTFIX\s+(\S+)/) {$HANDLEPOSTFIX=$1; next;}
	if (/^MAXHANDLE\s+(\d+)/) {$MAXHANDLE=$1; next;}
	if (/^HANDLEATTR\s+(\S+)\s+(\S+)\s+(\S+)/) {
	    $HANDLEATTR{$1} = $2;
	    $HANDLEDB{$1} = $3;
	    next;
	}
	if (/^MAXHITS\s+(\d+)/) {$MAXHITS=$1; next;}
	if (/^OVERFLOWSIZE\s+(\d+)/) {$OVERFLOWSIZE=$1; next;}
	if (/^TOPDIR\s+(\S+)/) {$TOPDIR=$1; next;}
	if (/^BINDIR\s+(\S+)/) {$BINDIR=$1; next;}
	if (/^TESTMODE\s+(\d+)/) {$TESTMODE=$1; next;}
	if (/^KEEPOPEN\s+(\d+)/) {$KEEPOPEN=$1; next;}
	if (/^AUTHORISECRYPTEDPW\s+(\S+)/) { $AUTHORISECRYPTEDPW=$1; next; }
	if (/^OVERRIDECRYPTEDPW\s+(\S+)/) { $OVERRIDECRYPTEDPW=$1; next; }
	if (/^WHOISUPDFROM\s+(\S.*\S)$/) { push(@WHOISUPDFROM,split(/\s+/,$1)); next; }
	if (/^GETUPDATESFROM\s+(\S.*\S)$/) { push(@GETUPDATESFROM,split(/\s+/,$1)); next; }
	if (/^DEFMAIL\s+(\S+)/) { $DEFMAIL=$1; next;}
	if (/^HUMAILBOX\s+(\S+)/) {$HUMAILBOX=$1; next;}
	if (/^AUTOBOX\s+(\S+)/) {$AUTOBOX=$1; next;}
	if (/^TMPDIR\s+(\S+)/) { $TMPDIR=$1; next;}
	if (/^CURDB\s+(\S+)/) { $CURDB=$1; next;}
	if (/^DEFSRC\s+(\S+)/) { $DEFSRC=$1; next;}
	if (/^ACKERR\s+(.*)/) { $ACKERR=$ACKERR.$1."\n"; next;}
	if (/^ACKOK\s+(.*)/) { $ACKOK=$ACKOK.$1."\n"; next;}
	if (/^ACKSIG\s+(.*)/) { $ACKSIG=$ACKSIG.$1."\n"; next;}
	if (/^INMAILS\s+(\S+)/) { $INMAILS=$1; next;}
	if (/^MAILCMD\s+(.*)/) { $MAILCMD=$1; next;}
	if (/^MAILTXT\s+(.*)/) { $MAILTXT.=$1."\n"; next;}
	if (/^MHEADER\s+(.*)/) { $MHEADER.=$1."\n"; next;}
	if (/^FWHEADER\s+(.*)/) { $FWHEADER.=$1."\n"; next;}
	if (/^FWTXT\s+(.*)/) { $FWTXT.=$1."\n"; next;}
	if (/^FWTEXT\s+(.*)/) { $FWTXT.=$1."\n"; next;} # backward compatible
	if (/^FWMAILTXT\s+(.*)/) { $FWMAILTXT.=$1."\n"; next;}
	if (/^FWNETWORKTXT\s+(.*)/) { $FWNETWORKTXT.=$1."\n"; next;}
	if (/^MTFWHEADER\s+(.*)/) { $MTFWHEADER.=$1."\n"; next;}
	if (/^MTFWTXT\s+(.*)/) { $MTFWTXT.=$1."\n"; next;}
	if (/^MTFWTEXT\s+(.*)/) { $MTFWTXT.=$1."\n"; next;} # backward compatible
	if (/^NAMNORM\s+(.)\s+(.)/) { $NAMNORM{$1}=$2; next;}
	if (/^NEWDB\s+(\S+)/) { $NEWDB=$1; next;}

	if (/^NHEADER\s+(.*)/) { $NHEADER.=$1."\n";next;}
	if (/^NOTITXT\s+(.*)/) { $NOTITXT.=$1."\n";next;}
	if (/^NOTIMAILTXT\s+(.*)/) { $NOTIMAILTXT.=$1."\n";next;}
	if (/^NOTINETWORKTXT\s+(.*)/) { $NOTINETWORKTXT.=$1."\n";next;}
	if (/^GRDCONFLICT\s+(.*)/) { $GRDCONFLICT.=$1."\n";next;}
	if (/^SPLITMSG\s+(.*)/) { $SPLITMSG.=$1."\n";next;}

	if (/^OBJ\s+(\S\S)\s+ATSQ\s+/) {
	    $i = $1;
	    while ($' =~ /(\S\S)\s*/) {
		$OBJATSQ{$i} = $OBJATSQ{$i}.$1." ";
	    }
	    next;
	}
	if (/^OBJ\s+(\S\S)\s+MAND\s+/) {
	    $i = $1;
	    while ($' =~ /(\S\S)\s*/) {
		$OBJ{$i, $1} = "M";
		$OBJMAND{$i} = $OBJMAND{$i}.$1." ";
	    }
	    next;
	}
	if (/^OBJ\s+(\S\S)\s+MULT\s+/) {
	    $i = $1;
	    while ($' =~ /(\S\S)\s*/) {
		$OBJMULT{$i} = $OBJMULT{$i}.$1." ";
	    }
	    next;
	}
	if (/^OBJ\s+(\S\S)\s+OPT\s+/) {
	    $i = $1;
	    while ($' =~ /(\S\S)\s*/) {
		$OBJ{$i, $1} = "O";
	    }
	    next;
	}
	if (/^OBJ\s+(\S\S)\s+KEYS\s+/) {
	    $i = $1;
	    while ($' =~ /(\S\S)\s*/) {
		$KEYS{$i} .= $1." ";
	    }
	    next;
	}
	if (/^OBJ\s+(\S\S)\s+GRD\s+/) {
	    $i = $1;
	    while ($' =~ /(\S\S)\s*/) {
		$GRD{$i} .= $1." ";
	    }
	    next;
	}
	if (/^OBJ\s+(\S\S)\s+REC\s+/) {
	    $i = $1;
	    while ($' =~ /(\S\S)\s*/) {
		$RECUR{$i} .= $1." ";
	    }
	    next;
	}
	if (/^OBJ\s+(\S\S)\s+UNIQ\s+/) {
	    $i = $1;
	    while ($' =~ /(\S\S)\s*/) {
		$UNIQ{$i} .= $1." ";
	    }
	    next;
	}
	if (/^OBJ\s+(\S\S)\s+OBS\s+/) {
            $i = $1;
            while ($' =~ /(\S\S)\s*/) {
                $OBS{$i} .= $1." ";
            }
            next;
        }


	if (/^CANUPD\s+(.+)/) {
	    $_ = $1;
	    while (s/(\S+)\s*//) {
		$CANUPD{$1} = 1;
	    }
	    next;
	}

	if (/^GRDOBJ\s+(.*)/) {
	    $_ = $1;
	    while (s/(\S+)\s*//) {
		$GRDOBJ{$1} = 1;
	    }
	    next;
	}

	if (/^DEFLOOK\s+(\S+)/) { $DEFLOOK=$1; next; }
	if (/^ALLLOOK\s+(.*)/) { $ALLLOOK=$1; next; }
	
	if (/^DBFILE\s+(\S+)\s+(\S+)\s*(\S*)/) { $DBFILE{$1} = $2; $TYPE{$1}=$3; next; }
	if (/^AUTHFILE\s+(\S+)/) { $AUTHFILE = $1; next; }
	if (/^PIDFILE\s+(\S+)/) { $PIDFILE = $1; next; }
	if (/^GUARD\s+(\S+)\s+(\S+)\s+(\S+)/) {
	    $GUARD{$1} = $2;
	    $GUARDTYPE{$1} = $3;
	    next;
	}

	if (/^OBJ\s+(\S\S)\s+SORT\s+(\S+)/) { $OBJSORT{$1} = $2; next;}
	if (/^RIGHTS\s+(.*)/) { $RIGHTS.=$1."\n"; next; }
	if (/^REPLYBANNER\s+(.*)/) { $REPLYBANNER.=$1."\n"; next; }
	if (/^NOMATCH\s+(.*)/) { $NOMATCH.=$1."\n"; next; }
	if (/^TOOMANY\s+(.*)/) { $TOOMANY.=$1."\n"; next; }
	if (/^SOURCE\s+(\S+)/) { $SOURCE{$1}=$1; next; }	
	if (/^STATS\s+(\S+)/) { $STATS=$1; next; }
	if (/^HELP\s+(\S+)/) { $HELP=$1; next; }
	if (/^QRYLOG\s+(\S+)/) { $LOGFILE{"QRYLOG"}=$1; next; }
	if (/^ERRLOG\s+(\S+)/) { $LOGFILE{"ERRLOG"}=$1; next; }
	if (/^AUTHLOG\s+(\S+)/) { $LOGFILE{"AUTHLOG"}=$1; next; }
	if (/^AUDITLOG\s+(\S+)/) { $LOGFILE{"AUDITLOG"}=$1; next; }
	if (/^UPDLOG\s+(\S+)/) { $LOGFILE{"UPDLOG"}=$1; next; }
	if (/^ACKLOG\s+(\S+)/) { $LOGFILE{"ACKLOG"}=$1; next; }
	if (/^LOCKDIR\s+(\S+)/) { $LOCKDIR=$1."/"; next; }
	if (/^SERIALDIR\s+(\S+)/) { $LOGFILE{"SERIALDIR"}=$1."/"; next; }
	if (/^OLDSERIALDIR\s+(\S+)/) { $LOGFILE{"OLDSERIALDIR"}=$1."/"; next; }
	if (/^SERIALINCOMINGDIR\s+(\S+)/) { $LOGFILE{"SERIALINCOMINGDIR"}=$1."/"; next; }
	if (/^CLEANLOCK\s+(\S+)/) {$CLEANLOCK = $1; next; }
	if (/^RENICECMD\s+(\S+)/) {$RENICECMD = $1; next; }
	print STDERR "Unknown config option: $_";
    }
    close(CONF);
    foreach $i (keys %OBJATSQ) { chop($OBJATSQ{$i}); }
    foreach $i (keys %OBJMAND) { chop($OBJMAND{$i}); }
    foreach $i (keys %OBJMULT) { chop($OBJMULT{$i}); }
	
    return 1;
}

1;
