#!PERL

#	$RCSfile: whois.pl,v $
#	$Revision: 1.4 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 15:44:59 $

# This is a very simple whois client, but it knows the new server arguments
# No support yet, use if you wish

require "getopts.pl";

$whoishost = "whois.ripe.net";
$port = WHOISPORT;
$AF_INET = 2;
$SOCK_STREAM = SOCKSTREAMVALUE;

&Getopts('aFrLmMSUg:h:s:t:T:');

if ($#ARGV < 0 && !$opt_t && !$opt_U && !opt_g) {
    print <<"EOF";

usage: whois [-aFrSv] [-h hostname] [-s source] [-T type] [-L|-m|-M] key ...
       whois -t type

where:

-a                    search all databases
-g Source:First-Last  get updates with 'Source' from 
                      serial 'First' till 'Last' (you may use LAST)        
-F                    fast raw output (implies -Fr)
-h hostname           search alternate server
-L                    find all Less specific matches
-m                    find first level More specific matches
-M                    find all More specific matches
-r                    turn off recursive lookups
-s source             search databases with source "source"
-S                    tell server to leave out "syntactic sugar"
-U                    do updates
-t type               requests template for object of type "type"
-T type               only look for objects of type "type"
-U                    do updates

Please note that most of these flags are NOT understood by
non RIPE whois servers
EOF
	exit(0);
}

if ($opt_h) { $whoishost = $opt_h; }

$sockaddr = 'S n a4 x8';
($name, $aliases, $type, $len, $thataddr) = gethostbyname($whoishost);
$that = pack($sockaddr, $AF_INET, $port, $thataddr);
socket(S, $AF_INET, $SOCK_STREAM, $proto) || die "socket failed\n";
connect(S, $that) || die "Connect failed\n";
select(S); $| = 1; select(STDOUT);

if ($opt_L) {
    print STDERR "whois: warning -L overrides -m\n" if $opt_m;
    print STDERR "whois: warning -L overrides -M\n" if $opt_M;
    $opt_m = 0;
    $opt_M = 0;
}
if ($opt_m) {
    print STDERR "whois: warning -m overrides -M\n" if $opt_M;
    $opt_M = 0;
}

if ($opt_t) {
    print S "-t $opt_t\n";
}
elsif ($opt_U) {
   if ($child = fork) {
		
	local($NAME)="";
	local($SAFENAME);
		
	if ($ENV{'LOGNAME'}) {
	   $NAME=$ENV{'LOGNAME'};
	}
	elsif ($ENV{'USER'}) {
	   $NAME=$ENV{'USER'};
	}
	elsif ($ENV{'USERNAME'}) {
	   $NAME=$ENV{'USERNAME'};
	}
	elsif ($ENV{'WHOAMI'}) {
	   $NAME=$ENV{'WHOAMI'};
	} 
	else {
	   $NAME.=`$WHOAMIPROGRAM`;
	} 
	
	if ($NAME) {
	   $NAME.="@";
	   if ($ENV{'HOST'}) {
	      $NAME.=$ENV{'HOST'};
	   }
	   elsif ($ENV{'HOSTNAME'}) {
	      $NAME.=$ENV{'HOSTNAME'};
	   }
	   else {
	      $NAME.=`$HOSTNAMEPROGRAM`;
	   }
	} 

	$SAFENAME = ($NAME=~ /^\s*(\S*)\s*$/);
		
	if ($SAFENAME=~ /^\@/) {
	   $SAFENAME="";
	}
		
	if (!$SAFENAME) {
	   if (($opt_U) && ($opt_U!=1)) {
	      $SAFENAME=$opt_U;
	   }
	   else {
	      $SAFENAME=nologname;
	   }
	} 
		
	# print STDERR $SAFENAME,"\n";
	
	print S "-U \"$SAFENAME\"\n";
		
	while(<STDIN>) {
   	   last if /^\.\s*$/;
	   print S;
	}
	print S "\n.\n";
	close(S);
	exit;
     }
     else {
	while(<S>) {
	print;
     }
     close(S);
     exit;
   }
} 
else {
    if ($opt_a) { print S "-a ";}
    if ($opt_g) { print S "-g $opt_g ";}
    if ($opt_F) { print S "-F ";}
    if ($opt_L) { print S "-L ";}
    if ($opt_m) { print S "-m ";}
    if ($opt_M) { print S "-M ";}
    if ($opt_r) { print S "-r ";}
    if ($opt_S) { print S "-S ";}
    if ($opt_s) { print S "-s $opt_s ";}
    if ($opt_T) { print S "-T $opt_T ";}
    foreach $i (0 .. $#ARGV) {
	print S $ARGV[$i], " ";
    }
    print S "\n";
}

while (<S>) {
	print;
}
