#       entype - return type of RIPE database entry
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
# Copyright (c) 1998                              RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: entype.pl,v 2.2 1998/07/15 18:01:29 joao Exp $
#
#	$RCSfile: entype.pl,v $
#	$Revision: 2.2 $
#	$Author: joao $
#	$Date: 1998/07/15 18:01:29 $
#
#       This routine returns the type of RIPE database entry given to it.
#	An entry type is defined by the first line of an entry eg
#	"pn", "in", "rp" etc.
#
#	Arguments:
#	*object		pointer to database entry in assoc array.

sub entype {

    local(*object) = @_;
  
    foreach (keys %OBJATSQ) {
	
	return ($_) if ($object{$_});
	
    }
    
    return 0;
}
1;
