#       internicstats2inetnum - generate inetnum objects from the InterNIC
#                               statistics files
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: internicstats2inetnums.pl,v 2.3 1997/10/02 15:25:56 chris Exp $
#
#
#	$RCSfile: internicstats2inetnums.pl,v $
#	$Revision: 2.3 $
#	$Author: chris $
#	$Date: 1997/10/02 15:25:56 $


require "defines.pl";
require "rconf.pl";
require "misc.pl";
require "net2net.pl";


local($conffile) = $ENV{"RIPEDBCNF"};
$conffile = $RIPEConfig{DEFCONFIG} unless $conffile;

&rconf($conffile);


local($value, $code, $day, $month);

local(%month2number)=("jan", "01",
                      "feb", "02",
                      "mar", "03",
                      "apr", "04",
                      "may", "05",
                      "jun", "06",
                      "jul", "07",
                      "aug", "08",
                      "sep", "09",
                      "sept", "09",
                      "oct", "10",
                      "nov", "11",
                      "dec", "12");
                      

local($remark)="
*rm: this network is assigned by the InterNIC
*rm: please query whois.internic.net for more information.
*ch: hostmaster\@internic.net ";

local($trailer)="
*ch: ripe-dbm\@ripe.net ".$DATE."
*so: INTERNIC\n";

&printrights(STDOUT);

my($line);
while ($line=<>) {
   
   if ($line =~ /\s(\d+\.\d+\.\d+\.\d+\/\d+)/) {
      
      ($value, $code)=&normalizerange($1, "in");
      
      next if ($code!=$O_OK);
     
      $line=<>;
      if ($line =~ /date\:\s+(\d+)\-([a-zA-Z]+)\-(\d+)/i) {
         
         $day=$1;
         $day="0".$day if ($day<10);
         ($month=$2)=~ tr/A-Z/a-z/;
         
         print STDOUT "\n*in: ", $value, $remark, $3, $month2number{$month}, $day, $trailer;

      }
      else {
         
         print STDOUT "\n*in: ", $value, $remark, $trailer;
         
      }
      
   }   
   
}
