/* ppp_str.h - streams version include file defines ioctl calls for MRU, COMPPROT and ASYNCMAP */
/*
 * Copyright (C) 1990 Brad K. Clements, All Rights Reserved, See copyright statement
   in Readme.streams
*/
/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */

#include	<sys/ioccom.h>

#define	SIOCSIFCOMPAC	_IOW(p, 130, char)
#define	SIOCSIFCOMPPROT	_IOW(p, 131, char)
#define	SIOCSIFMRU	_IOW(p, 132, int)
#define	SIOCGIFMRU	_IOR(p, 133, int)
#define	SIOCGIFASYNCMAP	_IOR(p, 134, long)
#define	SIOCSIFASYNCMAP	_IOW(p, 135, long)
#define	SIOCGETU	_IOR(p, 136, int)	/* get unit number */
#define	SIOCSIFVJCOMP	_IOW(p, 137, char)	/* enable/disable VJ Compression */

struct	ppp_if_info {
	int	pii_flags;
#define	PII_FLAGS_INUSE		0x1		/* in use by  a stream	*/
#define	PII_FLAGS_COMPAC	0x2
#define	PII_FLAGS_COMPPROT	0x4
#define	PII_FLAGS_ATTACHED	0x8		/* already if_attached	*/
#define	PII_FLAGS_VJC_ON	0x10		/* VJ TCP header compression enabled */
	struct	ifnet	pii_ifnet;
	queue_t		*pii_writeq;		/* used by ppp_output 	*/
#ifdef	VJC
	struct 	slcompress	pii_sc_comp;	/* vjc control buffer */
#endif
#ifdef	PPP_STATS
	struct slipstat		pii_stats;
#endif
};

