#ifndef MUTEX_H
#define MUTEX_H

#ifdef IN_LIBRARY
#undef USE_THREADS
#endif

#ifdef USE_THREADS
#ifdef HAVE_PTHREAD_H

#ifdef linux
#define _MIT_POSIX_THREADS
#endif

#include <pthread.h>

typedef pthread_mutex_t MUTEX_T;
typedef pthread_attr_t  ATTR_T;
typedef pthread_t       THREAD_T;

/* A good guess at the default mutex initializer...                          */
#ifndef PTHREAD_MUTEX_INITIALIZER
#define PTHREAD_MUTEX_INITIALIZER { 0 } 
#endif

#define ATTR_INIT(x)   pthread_attr_init(&(x))
#define ATTR_SCOPE(x, y)   pthread_attr_setscope(&(x), y)
#define ATTR_DETACH(x, y)   pthread_attr_setdetachstate(&(x), y)

#ifdef _AIX
#define THREAD_SIGMASK(x, y, z)   sigthreadmask(x, &(y), &(z))
#else
#define THREAD_SIGMASK(x, y, z)   pthread_sigmask(x, &(y), &(z))
#endif

#define MUTEX_SETUP(x)
#define MUTEX_LOCK(x)     pthread_mutex_lock(&(x))
#define MUTEX_UNLOCK(x)   pthread_mutex_unlock(&(x))
#define MUTEX_INITIALIZER PTHREAD_MUTEX_INITIALIZER

#define THREAD_SELF()     pthread_self()
#define THREAD_EXIT(x)    pthread_exit(NULL)

#else
#undef  USE_THREADS
#endif
#endif

#ifdef USE_THREADS
#define IFTHREADED(x)     x
#else

typedef int MUTEX_T;
#define MUTEX_INITIALIZER 0

#define MUTEX_LOCK(x)
#define MUTEX_UNLOCK(x)
#define IFTHREADED(x)     

#define THREAD_SELF()  0
#define THREAD_EXIT(x) exit(x)


#endif /* ! use threads */
#endif /* ! mutex_h */




