/* Copyright (c) 1996 NEC Corporation.  All rights reserved.                 */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("COPYRIGHT") included with this distribution.                   */
#include "socks5p.h"
#include "buffer.h"
#include "block.h"
#include "addr.h"
#include "log.h"
#include "msg.h"

#define DATAHEAD(b) ((b)->data + (b)->off)
#define DATASIZE(b) ((b)->len  - (b)->off)

    
int S5BufCheckPacket(S5IOHandle fd, S5IOInfo *cinfo) {
    return 0;
}

int S5BufUnreadPacket(S5IOInfo *cinfo, char *ibuf, int ilen) {
    S5Packet nbuf;
    
    if (!cinfo) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(0), 0, "S5BufUnread: No IO Info to buffer data");
	return -1;
    }

    if (ilen == 0) return 0;

    if (!cinfo->obuf.data) {
	cinfo->obuf.len  = 0;
	cinfo->obuf.off  = 0;
    }

    /* Try to put the data back into the buffer...                           */
    if (cinfo->obuf.off >= ilen) {
	memcpy(DATAHEAD(&cinfo->obuf) - ilen, ibuf, ilen);
	cinfo->obuf.off -= ilen;
	return 0;
    }

    /* Make a new buffer which can hold what was already there and this.     */
    nbuf.len  = DATASIZE(&cinfo->obuf) + ilen;
    nbuf.off  = 0;
    
    if (!(nbuf.data = (char *)malloc(nbuf.len * sizeof(char)))) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(0), 0, "S5BufUnread: Couldn't allocate buffer");
	return -1;
    }

    /* Put the already read data at the beginning of the buffer...           */
    memcpy(DATAHEAD(&nbuf), ibuf, ilen);
    nbuf.off  = ilen;

    /* There was already some data there, so copy it in...                   */
    if (cinfo->obuf.data) {
	memcpy(DATAHEAD(&nbuf), DATAHEAD(&cinfo->obuf), DATASIZE(&cinfo->obuf));
	nbuf.off += DATASIZE(&cinfo->obuf);
    }

    free(cinfo->obuf.data);
    cinfo->obuf = nbuf;
    return 0;
}

int S5BufReadPacket(S5IOHandle fd, S5IOInfo *cinfo, char *ibuf, int ilen, int ioflags) {
    return (int)RECVSOCKET(fd, ibuf, ilen, ioflags);
}

int S5BufWritePacket(S5IOHandle fd, S5IOInfo *cinfo, char *obuf, int olen, int ioflags) {
    return SENDSOCKET(fd, obuf, olen, ioflags);
}

void S5BufSetupContext(S5IOInfo *cinfo) {
    cinfo->fd           = S5InvalidIOHandle;
    cinfo->ibuf.data    = NULL;
    cinfo->obuf.data    = NULL;
    cinfo->auth.context = NULL;
    cinfo->auth.clean   = NULL;
}

void S5BufCleanContext(S5IOInfo *cinfo) {
    if (!cinfo) return;
    
    if (cinfo->auth.clean) cinfo->auth.clean(cinfo->auth.context);
    if (cinfo->fd != S5InvalidIOHandle) CLOSESOCKET(cinfo->fd);
    if (cinfo->ibuf.data) free(cinfo->ibuf.data);
    if (cinfo->obuf.data) free(cinfo->obuf.data);

    S5BufSetupContext(cinfo);
}

