/* libemtn.h */

/* Copyright 1997 by Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
   Donated to the public domain.  No warranty.

   1997-01-04 Initial version
   1997-01-17 Rename flags, add flag arg to tn_init()
   1997-04-05 Reorganize library */

#define TN_INIT_TELNET	0x01
#define TN_GETS_ECHO	0x02

typedef struct libemtn_tnconn tnconn;
struct libemfw_Cmd;
typedef enum {TN_CHAR, TN_MORE, TN_IGNORE, TN_IP} tndfa;

void tn_write (tnconn *, const char *, size_t);
void tn_putc (tnconn *, char);
void tn_puts (tnconn *, const char *);
void tn_putslen (tnconn *, const char *, size_t);
void tn_putnl (tnconn *);
void tn_printf (tnconn *, const char *, ...);
int tn_getc (tnconn *);
tnconn * tn_init (int, unsigned);
void tn_gets (tnconn *, char *, size_t, int, unsigned);
void tn_help (tnconn *, const struct libemfw_Cmd *);
void tn_reset_dfa (tnconn *);
tndfa tn_dfa (tnconn *, int);
